/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.util;

import com.google.caja.util.Lists;
import com.google.caja.util.Maps;
import com.google.caja.util.Multimap;
import com.google.caja.util.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Multimaps {
    public static <K, V> Multimap<K, V> newListHashMultimap() {
        return new MultimapImpl(new HashMapMaker(), new ListMaker());
    }

    public static <K, V> Multimap<K, V> newListLinkedHashMultimap() {
        return new MultimapImpl(new LinkedHashMapMaker(), new ListMaker());
    }

    public static <K, V> Multimap<K, V> newListIdentityMultimap() {
        return new MultimapImpl(new IdentityHashMapMaker(), new ListMaker());
    }

    public static <K, V> Multimap<K, V> newSetHashMultimap() {
        return new MultimapImpl(new HashMapMaker(), new SetMaker());
    }

    public static <K, V> Multimap<K, V> newSetLinkedHashMultimap() {
        return new MultimapImpl(new LinkedHashMapMaker(), new SetMaker());
    }

    public static <K, V> Multimap<K, V> newSetIdentityMultimap() {
        return new MultimapImpl(new IdentityHashMapMaker(), new SetMaker());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class MultimapImpl<K, V, C extends Collection<V>>
    implements Multimap<K, V> {
        private final Maker<Map<K, C>> mapMaker;
        private final Maker<C> collectionMaker;
        private final Map<K, C> underlying;

        MultimapImpl(Maker<Map<K, C>> mapMaker, Maker<C> collectionMaker) {
            this.mapMaker = mapMaker;
            this.collectionMaker = collectionMaker;
            this.underlying = mapMaker.newInstance();
        }

        @Override
        public final Multimap<K, V> clone() {
            MultimapImpl<K, V, C> clone = new MultimapImpl<K, V, C>(this.mapMaker, this.collectionMaker);
            clone.underlying.putAll(this.underlying);
            for (Map.Entry<K, C> e : clone.underlying.entrySet()) {
                Collection c = (Collection)this.collectionMaker.newInstance();
                c.addAll((Collection)e.getValue());
                e.setValue(c);
            }
            return clone;
        }

        @Override
        public Collection<V> get(K k) {
            Collection c = (Collection)this.underlying.get(k);
            return c != null ? Collections.unmodifiableCollection(c) : Collections.emptySet();
        }

        @Override
        public boolean isEmpty() {
            return this.underlying.isEmpty();
        }

        @Override
        public Set<K> keySet() {
            return this.underlying.keySet();
        }

        @Override
        public boolean put(K k, V v) {
            boolean result;
            Collection c = (Collection)this.underlying.get(k);
            if (c == null) {
                c = (Collection)this.collectionMaker.newInstance();
                result = c.add(v);
                if (!c.isEmpty()) {
                    this.underlying.put(k, c);
                }
            } else {
                result = c.add(v);
            }
            return result;
        }

        @Override
        public void putAll(K k, Collection<? extends V> v) {
            if (v.isEmpty()) {
                return;
            }
            Collection c = (Collection)this.underlying.get(k);
            if (c == null) {
                c = (Collection)this.collectionMaker.newInstance();
                c.addAll(v);
                if (!c.isEmpty()) {
                    this.underlying.put(k, c);
                }
            } else {
                c.addAll(v);
            }
        }

        @Override
        public boolean remove(K k, V v) {
            Collection c = (Collection)this.underlying.get(k);
            if (c == null) {
                return false;
            }
            boolean result = c.remove(v);
            if (c.isEmpty()) {
                this.underlying.remove(k);
            }
            return result;
        }

        @Override
        public void removeAll(K k, Collection<? extends V> v) {
            Collection c = (Collection)this.underlying.get(k);
            if (c != null) {
                c.removeAll(v);
                if (c.isEmpty()) {
                    this.underlying.remove(k);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SetMaker<T>
    implements Maker<Set<T>> {
        private SetMaker() {
        }

        @Override
        public Set<T> newInstance() {
            return Sets.newLinkedHashSet();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ListMaker<T>
    implements Maker<List<T>> {
        private ListMaker() {
        }

        @Override
        public List<T> newInstance() {
            return Lists.newArrayList();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IdentityHashMapMaker<K, V>
    implements Maker<Map<K, V>> {
        private IdentityHashMapMaker() {
        }

        @Override
        public Map<K, V> newInstance() {
            return Maps.newIdentityHashMap();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LinkedHashMapMaker<K, V>
    implements Maker<Map<K, V>> {
        private LinkedHashMapMaker() {
        }

        @Override
        public Map<K, V> newInstance() {
            return Maps.newLinkedHashMap();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HashMapMaker<K, V>
    implements Maker<Map<K, V>> {
        private HashMapMaker() {
        }

        @Override
        public Map<K, V> newInstance() {
            return Maps.newHashMap();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface Maker<T> {
        public T newInstance();
    }
}

