/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.controller.impl.state;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.gatein.common.util.ParameterMap;
import org.gatein.pc.api.info.NavigationInfo;
import org.gatein.pc.api.info.ParameterInfo;
import org.gatein.pc.api.info.PortletInfo;
import org.gatein.pc.controller.impl.state.StateControllerContextImpl;
import org.gatein.pc.controller.state.PortletPageNavigationalState;
import org.gatein.pc.controller.state.PortletWindowNavigationalState;

public class PortletPageNavigationalStateImpl
implements PortletPageNavigationalState,
Serializable {
    protected final StateControllerContextImpl context;
    protected final Map<String, PortletWindowNavigationalState> windows;
    protected final Map<QName, String[]> page;
    private final boolean modifiable;

    protected PortletPageNavigationalStateImpl(StateControllerContextImpl context, boolean modifiable) {
        this.context = context;
        this.windows = new HashMap<String, PortletWindowNavigationalState>();
        this.page = new HashMap<QName, String[]>();
        this.modifiable = modifiable;
    }

    public PortletPageNavigationalStateImpl(PortletPageNavigationalStateImpl original, boolean modifiable) {
        this.context = original.context;
        this.windows = new HashMap<String, PortletWindowNavigationalState>(original.windows);
        this.page = new HashMap<QName, String[]>(original.page);
        this.modifiable = modifiable;
    }

    @Override
    public Set<String> getPortletWindowIds() {
        return this.windows.keySet();
    }

    @Override
    public PortletWindowNavigationalState getPortletWindowNavigationalState(String portletWindowId) {
        return this.windows.get(portletWindowId);
    }

    @Override
    public Map<String, String[]> getPortletPublicNavigationalState(String portletWindowId) {
        PortletInfo info = this.context.portletControllerContext.getPortletInfo(portletWindowId);
        if (info != null) {
            ParameterMap publicNavigationalState = new ParameterMap();
            for (ParameterInfo parameterInfo : info.getNavigation().getPublicParameters()) {
                String[] parameterValue = this.page.get(parameterInfo.getName());
                if (parameterValue == null) continue;
                String parameterId = parameterInfo.getId();
                publicNavigationalState.put((Object)parameterId, parameterValue.clone());
            }
            return publicNavigationalState;
        }
        return null;
    }

    @Override
    public Set<QName> getPublicNames() {
        return this.page.keySet();
    }

    @Override
    public String[] getPublicNavigationalState(QName name) {
        String[] values = this.page.get(name);
        return values != null ? (String[])values.clone() : null;
    }

    @Override
    public void setPortletWindowNavigationalState(String portletWindowId, PortletWindowNavigationalState portletWindowState) {
        if (!this.modifiable) {
            throw new IllegalStateException("The page navigational state is not modifiable");
        }
        this.windows.put(portletWindowId, portletWindowState);
    }

    @Override
    public void setPortletPublicNavigationalState(String portletWindowId, Map<String, String[]> update) {
        if (!this.modifiable) {
            throw new IllegalStateException("The page navigational state is not modifiable");
        }
        PortletInfo info = this.context.portletControllerContext.getPortletInfo(portletWindowId);
        if (info != null) {
            NavigationInfo navigationInfo = info.getNavigation();
            for (Map.Entry<String, String[]> entry : update.entrySet()) {
                String id = entry.getKey();
                ParameterInfo parameterInfo = navigationInfo.getPublicParameter(id);
                if (parameterInfo == null) continue;
                QName name = parameterInfo.getName();
                String[] value = entry.getValue();
                if (value.length > 0) {
                    this.setPublicNavigationalState(name, value);
                    continue;
                }
                this.removePublicNavigationalState(name);
            }
        }
    }

    @Override
    public void setPublicNavigationalState(QName name, String[] value) {
        if (!this.modifiable) {
            throw new IllegalStateException("The page navigational state is not modifiable");
        }
        this.page.put(name, (String[])value.clone());
    }

    @Override
    public void removePublicNavigationalState(QName name) {
        if (!this.modifiable) {
            throw new IllegalStateException("The page navigational state is not modifiable");
        }
        this.page.remove(name);
    }
}

