/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.rest.api;

import java.lang.reflect.UndeclaredThrowableException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.storage.IdentityStorageException;
import org.exoplatform.social.service.rest.RestChecker;
import org.exoplatform.social.service.rest.Util;
import org.exoplatform.social.service.rest.api.models.IdentityRestOut;

@Path(value="api/social/v1-alpha3/{portalContainerName}/identity/")
public class IdentityResources
implements ResourceContainer {
    private static final String[] SUPPORTED_FORMAT = new String[]{"json"};

    @GET
    @Path(value="{identityId}.{format}")
    @Produces(value={"application/json"})
    public Response getIdentityById(@Context UriInfo uriInfo, @PathParam(value="portalContainerName") String portalContainerName, @PathParam(value="identityId") String identityId, @PathParam(value="format") String format) {
        RestChecker.checkAuthenticatedRequest();
        RestChecker.checkValidPortalContainerName(portalContainerName);
        if (identityId == null || identityId.equals("")) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        MediaType mediaType = RestChecker.checkSupportedFormat(format, SUPPORTED_FORMAT);
        IdentityManager identityManager = Util.getIdentityManager(portalContainerName);
        try {
            Identity identity = identityManager.getIdentity(identityId, true);
            IdentityRestOut resultIdentity = new IdentityRestOut(identity);
            Util.buildAbsoluteAvatarURL(resultIdentity);
            return Util.getResponse(resultIdentity, uriInfo, mediaType, Response.Status.OK);
        }
        catch (UndeclaredThrowableException undeclaredThrowableException) {
            if (undeclaredThrowableException.getCause() instanceof IdentityStorageException) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
    }

    @GET
    @Path(value="{providerId}/{remoteId}.{format}")
    @Produces(value={"application/json"})
    public Response getIdentityProviderIdAndRemoteId(@Context UriInfo uriInfo, @PathParam(value="portalContainerName") String portalContainerName, @PathParam(value="providerId") String providerId, @PathParam(value="remoteId") String remoteId, @PathParam(value="format") String format) {
        RestChecker.checkAuthenticatedRequest();
        RestChecker.checkValidPortalContainerName(portalContainerName);
        if (providerId == null || providerId.equals("") || remoteId == null || remoteId.equals("")) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        MediaType mediaType = RestChecker.checkSupportedFormat(format, SUPPORTED_FORMAT);
        IdentityManager identityManager = Util.getIdentityManager(portalContainerName);
        try {
            Identity identity = identityManager.getOrCreateIdentity(providerId, remoteId, true);
            IdentityRestOut resultIdentity = new IdentityRestOut(identity);
            Util.buildAbsoluteAvatarURL(resultIdentity);
            return Util.getResponse(resultIdentity, uriInfo, mediaType, Response.Status.OK);
        }
        catch (UndeclaredThrowableException undeclaredThrowableException) {
            if (undeclaredThrowableException.getCause() instanceof IdentityStorageException) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
    }
}

