/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.jndi;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsecurity.jndi.JndiCallback;

public class JndiTemplate {
    private static final Log log = LogFactory.getLog(JndiTemplate.class);
    private Properties environment;

    public JndiTemplate() {
    }

    public JndiTemplate(Properties environment) {
        this.environment = environment;
    }

    public void setEnvironment(Properties environment) {
        this.environment = environment;
    }

    public Properties getEnvironment() {
        return this.environment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(JndiCallback contextCallback) throws NamingException {
        Context ctx = this.createInitialContext();
        try {
            Object object = contextCallback.doInContext(ctx);
            return object;
        }
        finally {
            try {
                ctx.close();
            }
            catch (NamingException ex) {
                log.debug((Object)"Could not close JNDI InitialContext", (Throwable)ex);
            }
        }
    }

    protected Context createInitialContext() throws NamingException {
        Properties env = this.getEnvironment();
        Hashtable<String, String> icEnv = null;
        if (env != null) {
            icEnv = new Hashtable<String, String>(env.size());
            Enumeration<?> en = env.propertyNames();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                icEnv.put(key, env.getProperty(key));
            }
        }
        return new InitialContext(icEnv);
    }

    public Object lookup(final String name) throws NamingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Looking up JNDI object with name [" + name + "]"));
        }
        return this.execute(new JndiCallback(){

            public Object doInContext(Context ctx) throws NamingException {
                Object located = ctx.lookup(name);
                if (located == null) {
                    throw new NameNotFoundException("JNDI object with [" + name + "] not found: JNDI implementation returned null");
                }
                return located;
            }
        });
    }

    public Object lookup(String name, Class requiredType) throws NamingException {
        Object jndiObject = this.lookup(name);
        if (requiredType != null && !requiredType.isInstance(jndiObject)) {
            String msg = "Jndi object acquired under name '" + name + "' is of type [" + jndiObject.getClass().getName() + "] and not assignable to the required type [" + requiredType.getName() + "].";
            throw new NamingException(msg);
        }
        return jndiObject;
    }

    public void bind(final String name, final Object object) throws NamingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Binding JNDI object with name [" + name + "]"));
        }
        this.execute(new JndiCallback(){

            public Object doInContext(Context ctx) throws NamingException {
                ctx.bind(name, object);
                return null;
            }
        });
    }

    public void rebind(final String name, final Object object) throws NamingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Rebinding JNDI object with name [" + name + "]"));
        }
        this.execute(new JndiCallback(){

            public Object doInContext(Context ctx) throws NamingException {
                ctx.rebind(name, object);
                return null;
            }
        });
    }

    public void unbind(final String name) throws NamingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Unbinding JNDI object with name [" + name + "]"));
        }
        this.execute(new JndiCallback(){

            public Object doInContext(Context ctx) throws NamingException {
                ctx.unbind(name);
                return null;
            }
        });
    }
}

