/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.common;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.DynamicIdentity;
import org.exoplatform.services.jcr.core.ExtendedSession;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.SessionLifecycleListener;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.security.MembershipEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionProvider
implements SessionLifecycleListener {
    public static final String SESSION_PROVIDER = "JCRsessionProvider";
    private final Map<String, ExtendedSession> cache;
    private boolean isSystem;
    private ManageableRepository currentRepository;
    private String currentWorkspace;
    private boolean closed;
    private ConversationState conversationState;

    public SessionProvider(ConversationState userState) {
        this(false);
        if (userState.getAttribute(SESSION_PROVIDER) == null) {
            userState.setAttribute(SESSION_PROVIDER, (Object)this);
        }
    }

    private SessionProvider(HashSet<MembershipEntry> membershipEntries) {
        this(false);
        Identity id = new Identity(DynamicIdentity.DYNAMIC, membershipEntries);
        this.conversationState = new ConversationState(id);
    }

    private SessionProvider(boolean isSystem) {
        this.isSystem = isSystem;
        this.cache = new HashMap<String, ExtendedSession>();
        this.closed = false;
    }

    public static SessionProvider createSystemProvider() {
        return new SessionProvider(true);
    }

    public static SessionProvider createAnonimProvider() {
        Identity id = new Identity(IdentityConstants.ANONIM, new HashSet());
        return new SessionProvider(new ConversationState(id));
    }

    public static SessionProvider createProvider(List<AccessControlEntry> accessList) {
        if (accessList == null || accessList.isEmpty()) {
            return SessionProvider.createAnonimProvider();
        }
        HashSet<MembershipEntry> membershipEntries = new HashSet<MembershipEntry>();
        for (AccessControlEntry ace : accessList) {
            membershipEntries.add(ace.getMembershipEntry());
        }
        return new SessionProvider(membershipEntries);
    }

    public synchronized Session getSession(String workspaceName, ManageableRepository repository) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        if (this.closed) {
            throw new IllegalStateException("Session provider already closed");
        }
        if (workspaceName == null) {
            throw new IllegalArgumentException("Workspace Name is null");
        }
        ExtendedSession session = this.cache.get(this.key(repository, workspaceName));
        if (session == null) {
            session = this.conversationState != null ? (ExtendedSession)repository.getDynamicSession(workspaceName, this.conversationState.getIdentity().getMemberships()) : (!this.isSystem ? (ExtendedSession)repository.login(workspaceName) : (ExtendedSession)repository.getSystemSession(workspaceName));
            session.registerLifecycleListener((SessionLifecycleListener)this);
            this.cache.put(this.key(repository, workspaceName), session);
        }
        return session;
    }

    public synchronized void close() {
        if (this.closed) {
            throw new IllegalStateException("Session provider already closed");
        }
        this.closed = true;
        for (ExtendedSession session : this.cache.values().toArray(new ExtendedSession[this.cache.values().size()])) {
            session.logout();
        }
        this.cache.clear();
    }

    public synchronized void onCloseSession(ExtendedSession session) {
        this.cache.remove(this.key((ManageableRepository)session.getRepository(), session.getWorkspace().getName()));
    }

    private String key(ManageableRepository repository, String workspaceName) {
        String repositoryName = repository.getConfiguration().getName();
        return repositoryName + workspaceName;
    }

    public ManageableRepository getCurrentRepository() {
        return this.currentRepository;
    }

    public String getCurrentWorkspace() {
        return this.currentWorkspace;
    }

    public void setCurrentRepository(ManageableRepository currentRepository) {
        this.currentRepository = currentRepository;
    }

    public void setCurrentWorkspace(String currentWorkspace) {
        this.currentWorkspace = currentWorkspace;
    }
}

