/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.rendering.converter;

import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.exoplatform.wiki.rendering.converter.BlockConverter;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.FormatBlock;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.ParagraphBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.converter.ConversionException;
import org.xwiki.rendering.listener.Format;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.util.ParserUtils;

@Component(value="confluence/1.0")
public class ConfluenceBlockConverter
implements BlockConverter {
    @Inject
    private ComponentManager componentManager;

    public void convert(XDOM xdom) throws ConversionException {
        List blocks = xdom.getChildrenByType(MacroBlock.class, true);
        for (MacroBlock block : blocks) {
            this.transformDivMacro(block);
            this.transformSpanMacro(block);
        }
    }

    private void transformSpanMacro(MacroBlock block) throws ConversionException {
        if (block.getId().equals("span")) {
            Block parent = block.getParent();
            Map params = block.getParameters();
            String content = block.getContent().replaceAll("\\{span\\}", "");
            XDOM xdom = this.parse(content);
            new ParserUtils().removeTopLevelParagraph(xdom.getChildren());
            FormatBlock newBlock = new FormatBlock(xdom.getChildren(), Format.NONE, params);
            parent.replaceChild((Block)newBlock, (Block)block);
        }
    }

    private void transformDivMacro(MacroBlock block) throws ConversionException {
        if (block.getId().equals("div")) {
            Block parent = block.getParent();
            Map params = block.getParameters();
            XDOM xdom = this.parse(block.getContent());
            List children = xdom.getChildrenByType(MacroBlock.class, true);
            for (MacroBlock child : children) {
                this.transformSpanMacro(child);
            }
            new ParserUtils().removeTopLevelParagraph(xdom.getChildren());
            ParagraphBlock newBlock = new ParagraphBlock(xdom.getChildren(), params);
            parent.replaceChild((Block)newBlock, (Block)block);
        }
    }

    private XDOM parse(String content) throws ConversionException {
        try {
            Parser parser = (Parser)this.componentManager.lookup(Parser.class, Syntax.CONFLUENCE_1_0.toIdString());
            return parser.parse((Reader)new StringReader(content));
        }
        catch (ComponentLookupException e) {
            throw new ConversionException("Failed to locate Parser for syntax [Confluence 1.0]", (Throwable)e);
        }
        catch (ParseException e) {
            throw new ConversionException("Failed to parse input source", (Throwable)e);
        }
    }
}

