/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.rendering.internal.parser.confluence;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.wiki.rendering.internal.parser.confluence.ConfluenceLink;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.parser.ResourceReferenceParser;

@Component(value="confluence/1.0/link")
public class ConfluenceLinkReferenceParser
implements ResourceReferenceParser {
    private static final Pattern URL_SCHEME_PATTERN = Pattern.compile("[a-zA-Z0-9+.-]*://|mailto:|skype:|ymsgr:");

    public ResourceReference parse(String rawReference) {
        ConfluenceLink link = this.parseAsLink(rawReference);
        return link.toResourceReference();
    }

    public ConfluenceLink parseAsLink(String rawReference) {
        ConfluenceLink link = new ConfluenceLink();
        StringBuffer buf = new StringBuffer(rawReference);
        link.setRawReference(rawReference);
        if (!rawReference.startsWith("~")) {
            StringBuffer shortcutBuf = new StringBuffer(rawReference);
            link.setShortcutName(this.trimIfPossible(this.divideAfterLast(shortcutBuf, '@')));
            if (!StringUtils.isEmpty((String)link.getShortcutName())) {
                link.setShortcutValue(shortcutBuf.toString());
            }
        }
        link.setAttachmentName(this.trimIfPossible(this.divideAfter(buf, '^')));
        link.setAnchor(this.trimIfPossible(this.divideAfter(buf, '#')));
        Matcher matcher = URL_SCHEME_PATTERN.matcher(buf.toString().trim());
        if (matcher.lookingAt()) {
            link.setUriPrefix(this.trimIfPossible(ConfluenceLinkReferenceParser.divideOn(buf, ':')));
        } else {
            link.setDestinationReference(buf.toString().trim());
        }
        return link;
    }

    private String trimIfPossible(String s) {
        if (s == null) {
            return null;
        }
        return s.trim();
    }

    public static String divideOn(StringBuffer buffer, char divider) {
        if (buffer.length() == 0) {
            return null;
        }
        int i = buffer.indexOf(Character.toString(divider));
        if (i < 0) {
            return null;
        }
        if (i == 0) {
            buffer.deleteCharAt(0);
            return null;
        }
        String body = buffer.substring(0, i);
        buffer.delete(0, i + 1);
        return body;
    }

    private String divideAfter(StringBuffer buffer, char divider) {
        if (buffer.length() == 0) {
            return null;
        }
        return this.divideAfter(buffer, buffer.indexOf(Character.toString(divider)));
    }

    private String divideAfterLast(StringBuffer buffer, char divider) {
        if (buffer.length() == 0) {
            return null;
        }
        return this.divideAfter(buffer, buffer.lastIndexOf(Character.toString(divider)));
    }

    private String divideAfter(StringBuffer buffer, int index) {
        if (index < 0) {
            return null;
        }
        if (index == buffer.length() - 1) {
            buffer.deleteCharAt(buffer.length() - 1);
            return null;
        }
        String body = buffer.substring(index + 1);
        buffer.delete(index, buffer.length());
        return body;
    }
}

