/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.restatom.collections;

import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.abdera.model.Person;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.context.ResponseContextException;
import org.xcmis.restatom.AtomCMIS;
import org.xcmis.restatom.AtomUtils;
import org.xcmis.restatom.abdera.ObjectTypeElement;
import org.xcmis.restatom.collections.AbstractCmisCollection;
import org.xcmis.spi.ChangeLogTokenHolder;
import org.xcmis.spi.Connection;
import org.xcmis.spi.ConstraintException;
import org.xcmis.spi.FilterNotValidException;
import org.xcmis.spi.ItemsList;
import org.xcmis.spi.model.CmisObject;

public class ChangesLogCollection
extends AbstractCmisCollection<CmisObject> {
    public ChangesLogCollection(Connection connection) {
        super(connection);
        this.setHref("/changes");
    }

    public String getAuthor(RequestContext request) throws ResponseContextException {
        return "system";
    }

    public List<Person> getAuthors(CmisObject object, RequestContext request) throws ResponseContextException {
        Person p = request.getAbdera().getFactory().newAuthor();
        p.setName(this.getAuthor(request));
        return Collections.singletonList(p);
    }

    public Iterable<CmisObject> getEntries(RequestContext request) throws ResponseContextException {
        throw new UnsupportedOperationException("entries");
    }

    public CmisObject getEntry(String resourceName, RequestContext request) throws ResponseContextException {
        throw new UnsupportedOperationException("entry");
    }

    public String getId(CmisObject object) throws ResponseContextException {
        return object.getObjectInfo().getId();
    }

    public String getId(RequestContext request) {
        return "cmis:changes:" + this.getRepositoryId(request);
    }

    public String getName(CmisObject object) throws ResponseContextException {
        return "changes";
    }

    public String getTitle(CmisObject object) throws ResponseContextException {
        return "Change log event";
    }

    public String getTitle(RequestContext request) {
        return "Changes log";
    }

    public Date getUpdated(CmisObject object) throws ResponseContextException {
        Calendar changeTime = object.getChangeInfo().getChangeTime();
        if (changeTime != null) {
            return changeTime.getTime();
        }
        return new Date();
    }

    protected String addEntryDetails(RequestContext request, Entry entry, IRI feedIri, CmisObject object) throws ResponseContextException {
        String objectId = this.getId(object);
        entry.setId(objectId);
        entry.setUpdated(AtomUtils.getAtomDate(this.getUpdated(object)));
        entry.setSummary("Change Log Even");
        for (Person person : this.getAuthors(object, request)) {
            entry.addAuthor(person);
        }
        entry.setTitle(this.getTitle(object));
        String service = this.getServiceLink(request);
        entry.addLink(service, "service", "application/atomsvc+xml", null, null, -1L);
        ObjectTypeElement objectElement = new ObjectTypeElement(request.getAbdera().getFactory(), AtomCMIS.OBJECT);
        objectElement.build(object);
        entry.addExtension((Element)objectElement);
        return objectId;
    }

    protected void addFeedDetails(Feed feed, RequestContext request) throws ResponseContextException {
        try {
            String changeLogToken = request.getParameter("changeLogToken");
            boolean includeProperties = this.getBooleanParameter(request, "includeProperties", false);
            boolean includePolicyIds = this.getBooleanParameter(request, "includePolicyIds", false);
            boolean includeAcl = this.getBooleanParameter(request, "includeACL", false);
            String propertyFilter = request.getParameter("filter");
            int maxItems = this.getIntegerParameter(request, "maxItems", Integer.MAX_VALUE);
            Connection connection = this.getConnection(request);
            ChangeLogTokenHolder changeLogTokenHolder = new ChangeLogTokenHolder();
            if (changeLogToken != null) {
                changeLogTokenHolder.setValue((Object)changeLogToken);
            }
            ItemsList list = connection.getContentChanges(changeLogTokenHolder, includeProperties, propertyFilter, includePolicyIds, includeAcl, true, maxItems);
            this.addPageLinks((String)changeLogTokenHolder.getValue(), feed, "changes", maxItems, -1, list.getNumItems(), list.isHasMoreItems(), request);
            if (list.getItems().size() > 0) {
                if (list.getNumItems() != -1) {
                    Element numItems = feed.addExtension(AtomCMIS.NUM_ITEMS);
                    numItems.setText(Integer.toString(list.getNumItems()));
                }
                for (CmisObject oif : list.getItems()) {
                    Entry e = feed.addEntry();
                    IRI feedIri = new IRI(this.getFeedIriForEntry(oif, request));
                    this.addEntryDetails(request, e, feedIri, oif);
                }
            }
        }
        catch (FilterNotValidException fe) {
            throw new ResponseContextException(this.createErrorResponse(fe, 400));
        }
        catch (ConstraintException cve) {
            throw new ResponseContextException(this.createErrorResponse(cve, 409));
        }
        catch (Throwable t) {
            throw new ResponseContextException(this.createErrorResponse(t, 500));
        }
    }

    @Override
    protected void addPageLinks(String changeLogToken, Feed feed, String atomdocType, int maxItems, int skipCount, int total, boolean hasMore, RequestContext request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("repoid", this.getRepositoryId(request));
        params.put("atomdoctype", atomdocType);
        params.put("changeLogToken", changeLogToken);
        if (maxItems != Integer.MAX_VALUE) {
            params.put("maxItems", Integer.toString(maxItems));
        }
        feed.addLink(request.absoluteUrlFor((Object)"feed", params), "next", "application/atom+xml;type=feed", null, null, -1L);
    }

    protected Feed createFeedBase(RequestContext request) throws ResponseContextException {
        Factory factory = request.getAbdera().getFactory();
        Feed feed = factory.newFeed();
        feed.setId(this.getId(request));
        feed.setTitle(this.getTitle(request));
        feed.addAuthor(this.getAuthor(request));
        feed.setUpdated(AtomUtils.getAtomDate(Calendar.getInstance()));
        feed.addLink(this.getServiceLink(request), "service", "application/atomsvc+xml", null, null, -1L);
        return feed;
    }
}

