/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.restatom.collections;

import java.util.HashMap;
import java.util.List;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.ResponseContext;
import org.apache.abdera.protocol.server.context.EmptyResponseContext;
import org.apache.abdera.protocol.server.context.ResponseContextException;
import org.xcmis.restatom.AtomCMIS;
import org.xcmis.restatom.abdera.ObjectTypeElement;
import org.xcmis.restatom.collections.CmisObjectCollection;
import org.xcmis.spi.Connection;
import org.xcmis.spi.ConstraintException;
import org.xcmis.spi.FilterNotValidException;
import org.xcmis.spi.InvalidArgumentException;
import org.xcmis.spi.ObjectNotFoundException;
import org.xcmis.spi.model.CmisObject;
import org.xcmis.spi.model.IncludeRelationships;
import org.xcmis.spi.model.Property;
import org.xcmis.spi.model.impl.IdProperty;

public class PoliciesCollection
extends CmisObjectCollection {
    public PoliciesCollection(Connection connection) {
        super(connection);
        this.setHref("/policies");
    }

    protected void addFeedDetails(Feed feed, RequestContext request) throws ResponseContextException {
        try {
            String propertyFilter = request.getParameter("filter");
            int maxItems = this.getIntegerParameter(request, "maxItems", Integer.MAX_VALUE);
            int skipCount = this.getIntegerParameter(request, "skipCount", 0);
            Connection connection = this.getConnection(request);
            String objectId = this.getId(request);
            List list = connection.getAppliedPolicies(objectId, true, propertyFilter);
            if (list.size() > 0) {
                Element numItems = feed.addExtension(AtomCMIS.NUM_ITEMS);
                numItems.setText(Integer.toString(list.size()));
                this.addPageLinks(objectId, feed, "policies", maxItems, skipCount, list.size(), skipCount + maxItems < list.size(), request);
                for (CmisObject one : list) {
                    Entry e = feed.addEntry();
                    IRI feedIri = new IRI(this.getFeedIriForEntry(one, request));
                    this.addEntryDetails(request, e, feedIri, one);
                }
            }
        }
        catch (FilterNotValidException fe) {
            throw new ResponseContextException(this.createErrorResponse(fe, 400));
        }
        catch (ObjectNotFoundException onfe) {
            throw new ResponseContextException(this.createErrorResponse(onfe, 404));
        }
        catch (Throwable t) {
            throw new ResponseContextException(this.createErrorResponse(t, 500));
        }
    }

    @Override
    public ResponseContext postEntry(RequestContext request) {
        CmisObject object;
        String objectId;
        Entry entry;
        try {
            entry = this.getEntryFromRequest(request);
            objectId = this.getId(request);
        }
        catch (ResponseContextException rce) {
            return rce.getResponseContext();
        }
        ObjectTypeElement objectElement = (ObjectTypeElement)entry.getFirstChild(AtomCMIS.OBJECT);
        boolean hasCMISElement = objectElement != null;
        object = hasCMISElement ? (object = objectElement.getObject()) : new CmisObject();
        this.updatePropertiesFromEntry(object, entry);
        String policyId = null;
        if (hasCMISElement) {
            for (Property p : object.getProperties().values()) {
                String pName = p.getId();
                if (!"cmis:objectId".equals(pName)) continue;
                policyId = (String)((IdProperty)p).getValues().get(0);
            }
        }
        try {
            Connection connection = this.getConnection(request);
            if (policyId != null) {
                connection.applyPolicy(policyId, objectId);
            }
            entry = request.getAbdera().getFactory().newEntry();
            this.addEntryDetails(request, entry, request.getResolvedUri(), connection.getObject(policyId, true, IncludeRelationships.BOTH, true, true, true, null, null));
            HashMap params = new HashMap();
            String link = request.absoluteUrlFor((Object)"ENTRY", params);
            return this.buildCreateEntryResponse(link, entry);
        }
        catch (ConstraintException cve) {
            return this.createErrorResponse(cve, 409);
        }
        catch (ObjectNotFoundException onfe) {
            return this.createErrorResponse(onfe, 404);
        }
        catch (InvalidArgumentException iae) {
            return this.createErrorResponse(iae, 400);
        }
        catch (ResponseContextException rce) {
            return rce.getResponseContext();
        }
        catch (FilterNotValidException fae) {
            return this.createErrorResponse(fae, 400);
        }
        catch (Throwable t) {
            return this.createErrorResponse(t, 500);
        }
    }

    public ResponseContext deleteEntry(RequestContext request) {
        String objectId;
        Entry entry;
        try {
            entry = this.getEntryFromRequest(request);
            objectId = this.getId(request);
        }
        catch (ResponseContextException rce) {
            return this.createErrorResponse(rce, 400);
        }
        ObjectTypeElement objectElement = (ObjectTypeElement)entry.getFirstChild(AtomCMIS.OBJECT);
        CmisObject object = objectElement.getObject();
        String policyId = null;
        for (Property p : object.getProperties().values()) {
            String pName = p.getId();
            if (!pName.equals("cmis:objectId")) continue;
            policyId = (String)((IdProperty)p).getValues().get(0);
        }
        try {
            Connection connection = this.getConnection(request);
            if (policyId != null) {
                connection.removePolicy(policyId, objectId);
            }
            EmptyResponseContext response = new EmptyResponseContext(200);
            return response;
        }
        catch (ConstraintException cve) {
            return this.createErrorResponse(cve, 409);
        }
        catch (ObjectNotFoundException onfe) {
            return this.createErrorResponse(onfe, 404);
        }
        catch (InvalidArgumentException iae) {
            return this.createErrorResponse(iae, 400);
        }
        catch (Throwable t) {
            return this.createErrorResponse(t, 500);
        }
    }

    public Iterable<CmisObject> getEntries(RequestContext request) throws ResponseContextException {
        throw new UnsupportedOperationException("policies");
    }

    public String getTitle(RequestContext request) {
        return "Policies";
    }
}

