/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.chars;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import org.exoplatform.services.chars.StringDecoder;

class CharsetSD
extends StringDecoder {
    private final Charset cs;
    private final CharsetDecoder cd;

    CharsetSD(Charset cs, String rcn) {
        super(rcn);
        this.cs = cs;
        this.cd = cs.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
    }

    String charsetName() {
        return this.cs.name();
    }

    char[] decode(byte[] ba, int off, int len) {
        int en = this.scale(len, this.cd.maxCharsPerByte());
        char[] ca = new char[en];
        if (len == 0) {
            return ca;
        }
        this.cd.reset();
        ByteBuffer bb = ByteBuffer.wrap(ba, off, len);
        CharBuffer cb = CharBuffer.wrap(ca);
        try {
            CoderResult cr = this.cd.decode(bb, cb, true);
            if (!cr.isUnderflow()) {
                cr.throwException();
            }
            if (!(cr = this.cd.flush(cb)).isUnderflow()) {
                cr.throwException();
            }
        }
        catch (CharacterCodingException x) {
            throw new Error(x);
        }
        return this.trim(ca, cb.position());
    }
}

