/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.rightclick.manager;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.jcr.version.VersionException;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.component.explorer.control.filter.CanSetPropertyFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsCheckedOutFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsHoldsLockFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotInTrashFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotLockedFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotTrashHomeNodeFilter;
import org.exoplatform.ecm.webui.component.explorer.control.listener.UIWorkingAreaActionListener;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.ecm.webui.utils.LockUtil;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilters;
import org.exoplatform.webui.ext.manager.UIAbstractManager;
import org.exoplatform.webui.ext.manager.UIAbstractManagerComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(events={@EventConfig(listeners={UnlockActionListener.class})})
public class UnlockManageComponent
extends UIAbstractManagerComponent {
    private static final List<UIExtensionFilter> FILTERS = Arrays.asList(new UIExtensionFilter[]{new IsNotInTrashFilter(), new IsHoldsLockFilter(), new IsNotLockedFilter(true, true), new CanSetPropertyFilter(), new IsCheckedOutFilter(), new IsNotTrashHomeNodeFilter()});
    private static final Log LOG = ExoLogger.getLogger((String)UnlockManageComponent.class.getName());

    @UIExtensionFilters
    public List<UIExtensionFilter> getFilters() {
        return FILTERS;
    }

    private static Node getNodeByPath(String nodePath, UIJCRExplorer uiExplorer) throws Exception {
        Matcher matcher = UIWorkingArea.FILE_EXPLORER_URL_SYNTAX.matcher(nodePath);
        String wsName = null;
        if (!matcher.find()) {
            throw new IllegalArgumentException("The ObjectId is invalid '" + nodePath + "'");
        }
        wsName = matcher.group(1);
        nodePath = matcher.group(2);
        Session session = uiExplorer.getSessionByWorkspace(wsName);
        return uiExplorer.getNodeByPath(nodePath, session);
    }

    private static void processUnlock(String nodePath, Event<UnlockManageComponent> event, UIJCRExplorer uiExplorer) throws Exception {
        Session session;
        Node node;
        UIApplication uiApp = (UIApplication)uiExplorer.getAncestorOfType(UIApplication.class);
        try {
            node = UnlockManageComponent.getNodeByPath(nodePath, uiExplorer);
            session = node.getSession();
        }
        catch (PathNotFoundException path) {
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.path-not-found-exception", null, 1));
            return;
        }
        catch (Exception e) {
            JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
            return;
        }
        String superUser = ((UserACL)WCMCoreUtils.getService(UserACL.class)).getSuperUser();
        String remoteUser = node.getSession().getUserID();
        if (remoteUser.equalsIgnoreCase(superUser)) {
            session = WCMCoreUtils.getSystemSessionProvider().getSession(node.getSession().getWorkspace().getName(), (ManageableRepository)node.getSession().getRepository());
            node = (Node)session.getItem(node.getPath());
        }
        try {
            if (node.holdsLock()) {
                String lockToken = LockUtil.getLockToken((Node)node);
                if (lockToken != null) {
                    session.addLockToken(lockToken);
                }
                node.unlock();
                node.removeMixin("mix:lockable");
                node.getSession().save();
                LockUtil.removeLock((Node)node);
            }
        }
        catch (LockException le) {
            Object[] args = new Object[]{node.getName()};
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.can-not-unlock-node", args, 1));
            uiExplorer.updateAjax(event);
            return;
        }
        catch (VersionException versionException) {
            Object[] args = new Object[]{node.getName()};
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.can-not-unlock-node-is-checked-in", args, 1));
            uiExplorer.updateAjax(event);
            return;
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"an unexpected error occurs while unloking the node", (Throwable)e);
            }
            JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
            uiExplorer.updateAjax(event);
        }
    }

    public Class<? extends UIAbstractManager> getUIAbstractManagerClass() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UnlockActionListener
    extends UIWorkingAreaActionListener<UnlockManageComponent> {
        private void unlockManage(Event<UnlockManageComponent> event, UIJCRExplorer uiExplorer) throws Exception {
            String nodePath = event.getRequestContext().getRequestParameter("objectId");
            if (nodePath.indexOf(";") > -1) {
                this.processMultiUnlock(nodePath.split(";"), event, uiExplorer);
            } else {
                UnlockManageComponent.processUnlock(nodePath, (Event<UnlockManageComponent>)event, uiExplorer);
            }
        }

        private void processMultiUnlock(String[] nodePaths, Event<UnlockManageComponent> event, UIJCRExplorer uiExplorer) throws Exception {
            for (String nodePath : nodePaths) {
                if (!this.acceptForMultiNode(event, nodePath)) continue;
                UnlockManageComponent.processUnlock(nodePath, (Event<UnlockManageComponent>)event, uiExplorer);
            }
            uiExplorer.getSession().save();
            uiExplorer.updateAjax(event);
        }

        public void processEvent(Event<UnlockManageComponent> event) throws Exception {
            UIJCRExplorer uiExplorer = (UIJCRExplorer)((UnlockManageComponent)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            this.unlockManage(event, uiExplorer);
        }
    }
}

