/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.search;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinition;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.search.UIConstraintsForm;
import org.exoplatform.ecm.webui.component.explorer.search.UISearchContainer;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormRadioBoxInput;
import org.exoplatform.webui.form.UIFormSelectBox;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(phase=Event.Phase.DECODE, listeners={CancelActionListener.class}), @EventConfig(listeners={AddActionListener.class}), @EventConfig(listeners={ChangeMetadataTypeActionListener.class})})
public class UISelectPropertyForm
extends UIForm
implements UIPopupComponent {
    public static final String METADATA_TYPE = "metadataType";
    public static final String PROPERTY = "property";
    private String fieldName_ = null;
    private List<SelectItemOption<String>> properties_ = new ArrayList<SelectItemOption<String>>();

    public UISelectPropertyForm() throws Exception {
        this.setActions(new String[]{"Add", "Cancel"});
    }

    public String getLabel(ResourceBundle res, String id) {
        try {
            return super.getLabel(res, id);
        }
        catch (Exception ex) {
            return id;
        }
    }

    public void activate() throws Exception {
        ArrayList<SelectItemOption> options = new ArrayList<SelectItemOption>();
        NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)this.getApplicationComponent(NodeHierarchyCreator.class);
        UIFormSelectBox uiSelect = new UIFormSelectBox(METADATA_TYPE, METADATA_TYPE, options);
        uiSelect.setOnChange("ChangeMetadataType");
        this.addUIFormInput((UIFormInput)uiSelect);
        String metadataPath = nodeHierarchyCreator.getJcrPath("metadataPath");
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        DMSConfiguration dmsConfiguration = (DMSConfiguration)this.getApplicationComponent(DMSConfiguration.class);
        String workspaceName = dmsConfiguration.getConfig().getSystemWorkspace();
        Session session = uiExplorer.getSystemProvider().getSession(workspaceName, uiExplorer.getRepository());
        Node homeNode = (Node)session.getItem(metadataPath);
        NodeIterator nodeIter = homeNode.getNodes();
        Node meta = nodeIter.nextNode();
        this.renderProperties(meta.getName());
        options.add(new SelectItemOption(meta.getName(), (Object)meta.getName()));
        while (nodeIter.hasNext()) {
            meta = nodeIter.nextNode();
            options.add(new SelectItemOption(meta.getName(), (Object)meta.getName()));
        }
        this.addUIFormInput((UIFormInput)new UIFormRadioBoxInput(PROPERTY, null, this.properties_).setAlign(UIFormRadioBoxInput.VERTICAL_ALIGN));
    }

    public void deActivate() throws Exception {
    }

    public void setFieldName(String fieldName) {
        this.fieldName_ = fieldName;
    }

    public void renderProperties(String metadata) throws Exception {
        PropertyDefinition[] properties;
        this.properties_.clear();
        UIJCRExplorer uiExpolrer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        NodeTypeManager ntManager = uiExpolrer.getSession().getWorkspace().getNodeTypeManager();
        NodeType nt = ntManager.getNodeType(metadata);
        for (PropertyDefinition property : properties = nt.getPropertyDefinitions()) {
            String name = property.getName();
            if (name.equals("exo:internalUse")) continue;
            this.properties_.add((SelectItemOption<String>)new SelectItemOption(name, (Object)name));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeMetadataTypeActionListener
    extends EventListener<UISelectPropertyForm> {
        public void execute(Event<UISelectPropertyForm> event) throws Exception {
            UISelectPropertyForm uiForm = (UISelectPropertyForm)((Object)event.getSource());
            uiForm.renderProperties((String)uiForm.getUIFormSelectBox(UISelectPropertyForm.METADATA_TYPE).getValue());
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddActionListener
    extends EventListener<UISelectPropertyForm> {
        public void execute(Event<UISelectPropertyForm> event) throws Exception {
            UISelectPropertyForm uiForm = (UISelectPropertyForm)((Object)event.getSource());
            String property = (String)((UIFormRadioBoxInput)uiForm.getUIInput(UISelectPropertyForm.PROPERTY)).getValue();
            UIPopupContainer UIPopupContainer2 = (UIPopupContainer)uiForm.getAncestorOfType(UIPopupContainer.class);
            UISearchContainer uiSearchContainer = (UISearchContainer)UIPopupContainer2.getParent();
            UIConstraintsForm uiConstraintsForm = (UIConstraintsForm)uiSearchContainer.findFirstComponentOfType(UIConstraintsForm.class);
            uiConstraintsForm.getUIStringInput(uiForm.fieldName_).setValue((Object)property);
            if (uiForm.fieldName_.equals("property1")) {
                uiConstraintsForm.getUIFormCheckBoxInput("exactlyPro").setChecked(true);
            } else if (uiForm.fieldName_.equals("property2")) {
                uiConstraintsForm.getUIFormCheckBoxInput("containPro").setChecked(true);
            } else if (uiForm.fieldName_.equals("property3")) {
                uiConstraintsForm.getUIFormCheckBoxInput("notContainPro").setChecked(true);
            }
            UIPopupContainer2.deActivate();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)UIPopupContainer2);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiConstraintsForm);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UISelectPropertyForm> {
        public void execute(Event<UISelectPropertyForm> event) throws Exception {
            UISearchContainer uiSearchContainer = (UISearchContainer)((UISelectPropertyForm)((Object)event.getSource())).getAncestorOfType(UISearchContainer.class);
            UIPopupContainer uiPopup = (UIPopupContainer)uiSearchContainer.getChild(UIPopupContainer.class);
            uiPopup.deActivate();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopup);
        }
    }
}

