/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.chromattic.api.BuilderException;
import org.chromattic.api.format.ObjectFormatter;
import org.chromattic.common.ObjectInstantiator;
import org.chromattic.common.collection.Collections;
import org.chromattic.common.jcr.Path;
import org.chromattic.common.jcr.PathException;
import org.chromattic.core.NameKind;
import org.chromattic.core.ObjectContext;
import org.chromattic.core.jcr.type.TypeManager;
import org.chromattic.core.mapper.ObjectMapper;
import org.chromattic.core.query.QueryManager;
import org.chromattic.metamodel.mapping.BeanMapping;
import org.chromattic.spi.instrument.Instrumentor;
import org.chromattic.spi.instrument.MethodHandler;
import org.chromattic.spi.instrument.ProxyType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Domain {
    private static final ProxyType<?> NULL_PROXY_TYPE = new ProxyType<Object>(){

        public Object createProxy(MethodHandler handler) {
            throw new UnsupportedOperationException("Cannot create proxy for " + handler);
        }

        public Class<?> getType() {
            throw new UnsupportedOperationException("Cannot get proxy type for NULL_PROXY_TYPE");
        }
    };
    private static final Instrumentor NULL_INSTRUMENTOR = new Instrumentor(){

        public <O> ProxyType<O> getProxyClass(Class<O> clazz) {
            return NULL_PROXY_TYPE;
        }

        public MethodHandler getInvoker(Object proxy) {
            throw new UnsupportedOperationException();
        }
    };
    public static int LAZY_CREATE_MODE = 0;
    public static int CREATE_MODE = 1;
    public static int NO_CREATE_MODE = 2;
    private static final Set<Integer> CREATE_MODES = Collections.set((Object[])new Integer[]{LAZY_CREATE_MODE, CREATE_MODE, NO_CREATE_MODE});
    private final Map<String, ObjectMapper> typeMapperByNodeType;
    private final Map<Class<?>, ObjectMapper> typeMapperByClass;
    private final Instrumentor defaultInstrumentor;
    private final Map<Class<?>, Instrumentor> proxyTypeToInstrumentor;
    private final Map<Class<?>, Instrumentor> chromatticTypeToInstrumentor;
    final ObjectFormatter objectFormatter;
    final boolean propertyCacheEnabled;
    final boolean propertyReadAheadEnabled;
    final boolean hasPropertyOptimized;
    final boolean hasNodeOptimized;
    final String rootNodePath;
    final List<String> rootNodePathSegments;
    final String rootNodeType;
    final int rootCreateMode;
    final TypeManager nodeInfoManager;
    final QueryManager queryManager;

    public Domain(Collection<ObjectMapper<?>> mappers, Instrumentor defaultInstrumentor, ObjectFormatter objectFormatter, boolean propertyCacheEnabled, boolean propertyReadAheadEnabled, boolean hasPropertyOptimized, boolean hasNodeOptimized, String rootNodePath, int rootCreateMode, String rootNodeType) {
        List rootNodePathSegments;
        if (!CREATE_MODES.contains(rootCreateMode)) {
            throw new IllegalArgumentException("Invalid create mode " + rootCreateMode);
        }
        HashMap proxyTypeToInstrumentor = new HashMap();
        HashMap chromatticTypeToInstrumentor = new HashMap();
        block4: for (ObjectMapper<?> mapper : mappers) {
            BeanMapping beanMapping = mapper.getMapping();
            Class clazz = (Class)beanMapping.getBean().getClassType().unwrap();
            for (Annotation annotation : clazz.getAnnotations()) {
                if (!"org.chromattic.groovy.annotations.GroovyInstrumentor".equals(annotation.annotationType().getName())) continue;
                Class instrumentorClass = null;
                try {
                    instrumentorClass = (Class)annotation.annotationType().getMethod("value", new Class[0]).invoke((Object)annotation, new Object[0]);
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                Instrumentor i = (Instrumentor)ObjectInstantiator.newInstance((String)instrumentorClass.getName(), Instrumentor.class);
                proxyTypeToInstrumentor.put(i.getProxyClass(clazz).getType(), i);
                chromatticTypeToInstrumentor.put(clazz, i);
                continue block4;
            }
            if (Object.class.equals((Object)clazz)) {
                proxyTypeToInstrumentor.put(clazz, defaultInstrumentor);
                chromatticTypeToInstrumentor.put(clazz, defaultInstrumentor);
                continue;
            }
            proxyTypeToInstrumentor.put(defaultInstrumentor.getProxyClass(clazz).getType(), defaultInstrumentor);
            chromatticTypeToInstrumentor.put(clazz, defaultInstrumentor);
        }
        HashMap<String, ObjectMapper> typeMapperByNodeType = new HashMap<String, ObjectMapper>();
        HashMap typeMapperByClass = new HashMap();
        for (ObjectMapper<?> typeMapper : mappers) {
            if (typeMapperByNodeType.containsKey(typeMapper.getNodeTypeName())) {
                throw new IllegalStateException("Duplicate node type name " + typeMapper);
            }
            typeMapperByNodeType.put(typeMapper.getNodeTypeName(), typeMapper);
            typeMapperByClass.put(typeMapper.getObjectClass(), typeMapper);
        }
        try {
            rootNodePathSegments = Path.splitAbsolutePath((String)Path.normalizeAbsolutePath((String)rootNodePath));
        }
        catch (PathException e) {
            throw new BuilderException("Root node path must be valid");
        }
        this.typeMapperByClass = typeMapperByClass;
        this.typeMapperByNodeType = typeMapperByNodeType;
        this.defaultInstrumentor = defaultInstrumentor;
        this.objectFormatter = objectFormatter;
        this.propertyCacheEnabled = propertyCacheEnabled;
        this.propertyReadAheadEnabled = propertyReadAheadEnabled;
        this.hasPropertyOptimized = hasPropertyOptimized;
        this.hasNodeOptimized = hasNodeOptimized;
        this.rootNodePath = rootNodePath;
        this.rootNodePathSegments = rootNodePathSegments;
        this.nodeInfoManager = new TypeManager();
        this.queryManager = new QueryManager(rootNodePath);
        this.rootCreateMode = rootCreateMode;
        this.rootNodeType = rootNodeType;
        this.proxyTypeToInstrumentor = proxyTypeToInstrumentor;
        this.chromatticTypeToInstrumentor = chromatticTypeToInstrumentor;
    }

    public boolean isHasPropertyOptimized() {
        return this.hasPropertyOptimized;
    }

    public boolean isHasNodeOptimized() {
        return this.hasNodeOptimized;
    }

    public MethodHandler getHandler(Object o) {
        Instrumentor instrumentor = this.proxyTypeToInstrumentor.get(o.getClass());
        return instrumentor != null ? instrumentor.getInvoker(o) : null;
    }

    public <O> ProxyType<O> getProxyType(Class<O> type) {
        Instrumentor instrumentor = this.chromatticTypeToInstrumentor.get(type);
        return instrumentor.getProxyClass(type);
    }

    public ObjectMapper getTypeMapper(String nodeTypeName) {
        return this.typeMapperByNodeType.get(nodeTypeName);
    }

    public ObjectMapper getTypeMapper(Class<?> clazz) {
        return this.typeMapperByClass.get(clazz);
    }

    public QueryManager getQueryManager() {
        return this.queryManager;
    }

    String decodeName(Node ownerNode, String internal, NameKind nameKind) throws NullPointerException, UndeclaredThrowableException, IllegalStateException, RepositoryException {
        if (ownerNode == null) {
            throw new NullPointerException();
        }
        String nodeTypeName = ownerNode.getPrimaryNodeType().getName();
        ObjectMapper ownerMapper = this.getTypeMapper(nodeTypeName);
        ObjectFormatter formatter = null;
        if (ownerMapper != null) {
            formatter = ownerMapper.getFormatter();
        }
        return this.decodeName(formatter, internal, nameKind);
    }

    String decodeName(ObjectContext ownerCtx, String internal, NameKind nameKind) throws NullPointerException, UndeclaredThrowableException, IllegalStateException, RepositoryException {
        if (ownerCtx == null) {
            throw new NullPointerException();
        }
        return this.decodeName(ownerCtx.getMapper().getFormatter(), internal, nameKind);
    }

    private String decodeName(ObjectFormatter formatter, String internal, NameKind nameKind) throws UndeclaredThrowableException, IllegalStateException, RepositoryException {
        String external;
        if (nameKind == NameKind.PROPERTY) {
            return internal;
        }
        if (formatter == null) {
            formatter = this.objectFormatter;
        }
        try {
            if (nameKind != NameKind.OBJECT) {
                throw new UnsupportedOperationException();
            }
            external = formatter.decodeNodeName(null, internal);
        }
        catch (Exception e) {
            if (e instanceof IllegalStateException) {
                throw (IllegalStateException)e;
            }
            throw new UndeclaredThrowableException(e);
        }
        if (external == null && nameKind == NameKind.OBJECT) {
            throw new IllegalStateException();
        }
        return external;
    }

    String encodeName(Node ownerNode, String externalName, NameKind nameKind) throws NullPointerException, UndeclaredThrowableException, RepositoryException {
        if (ownerNode == null) {
            throw new NullPointerException();
        }
        String nodeTypeName = ownerNode.getPrimaryNodeType().getName();
        ObjectMapper ownerMapper = this.getTypeMapper(nodeTypeName);
        ObjectFormatter formatter = null;
        if (ownerMapper != null) {
            formatter = ownerMapper.getFormatter();
        }
        return this.encodeName(formatter, externalName, nameKind);
    }

    String encodeName(ObjectContext ownerCtx, String externalName, NameKind nameKind) throws NullPointerException, UndeclaredThrowableException, RepositoryException {
        if (ownerCtx == null) {
            throw new NullPointerException("No null owner node accepted");
        }
        return this.encodeName(ownerCtx.getMapper().getFormatter(), externalName, nameKind);
    }

    private String encodeName(ObjectFormatter formatter, String externalName, NameKind nameKind) throws UndeclaredThrowableException, NullPointerException, RepositoryException {
        String internal;
        if (externalName == null) {
            throw new NullPointerException("No null name accepted");
        }
        if (nameKind == null) {
            throw new NullPointerException("No null name kind accepted");
        }
        if (nameKind == NameKind.PROPERTY) {
            return externalName;
        }
        if (formatter == null) {
            formatter = this.objectFormatter;
        }
        try {
            if (nameKind != NameKind.OBJECT) {
                throw new UnsupportedOperationException();
            }
            internal = formatter.encodeNodeName(null, externalName);
        }
        catch (Exception e) {
            if (e instanceof NullPointerException) {
                throw (NullPointerException)e;
            }
            if (e instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)e;
            }
            throw new UndeclaredThrowableException(e);
        }
        if (internal == null) {
            throw new IllegalArgumentException("Name " + externalName + " was converted to null");
        }
        Path.validateLocalName((String)internal);
        return internal;
    }
}

