/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.profile;

import org.apache.commons.lang.Validate;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.social.webui.activity.UIActivitiesLoader;
import org.exoplatform.social.webui.composer.UIComposer;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="classpath:groovy/social/webui/profile/UIUserActivitiesDisplay.gtmpl", events={@EventConfig(listeners={ChangeDisplayModeActionListener.class})})
public class UIUserActivitiesDisplay
extends UIContainer {
    private static final Log LOG = ExoLogger.getLogger(UIUserActivitiesDisplay.class);
    private static final int ACTIVITY_PER_PAGE = 20;
    private Object locker = new Object();
    private DisplayMode selectedDisplayMode = DisplayMode.ALL_UPDATES;
    private UIActivitiesLoader activitiesLoader;
    private String ownerName;
    private String viewerName;
    private boolean isActivityStreamOwner = false;

    public UIActivitiesLoader getActivitiesLoader() {
        return this.activitiesLoader;
    }

    public boolean isActivityStreamOwner() {
        return this.isActivityStreamOwner;
    }

    public void setSelectedDisplayMode(DisplayMode displayMode) {
        this.selectedDisplayMode = displayMode;
        try {
            this.init();
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to init()");
        }
    }

    public DisplayMode getSelectedDisplayMode() {
        return this.selectedDisplayMode;
    }

    public void setOwnerName(String ownerName) throws Exception {
        this.ownerName = ownerName;
        this.viewerName = PortalRequestContext.getCurrentInstance().getRemoteUser();
        this.isActivityStreamOwner = this.viewerName.equals(ownerName);
        if (!this.isActivityStreamOwner) {
            this.selectedDisplayMode = DisplayMode.OWNER_STATUS;
        }
        this.init();
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws Exception {
        Validate.notNull((Object)this.ownerName, (String)"ownerName must not be null.");
        Validate.notNull((Object)this.viewerName, (String)"viewerName must not be null.");
        Object object = this.locker;
        synchronized (object) {
            this.removeChild(UIActivitiesLoader.class);
            this.activitiesLoader = (UIActivitiesLoader)this.addChild(UIActivitiesLoader.class, null, "UIActivitiesLoader");
        }
        this.activitiesLoader.setPostContext(UIComposer.PostContext.USER);
        this.activitiesLoader.setLoadingCapacity(20);
        this.activitiesLoader.setOwnerName(this.ownerName);
        Identity ownerIdentity = Utils.getIdentityManager().getOrCreateIdentity("organization", this.ownerName, false);
        ActivityManager activityManager = Utils.getActivityManager();
        if (DisplayMode.MY_STATUS.equals((Object)this.getSelectedDisplayMode()) || DisplayMode.OWNER_STATUS.equals((Object)this.getSelectedDisplayMode())) {
            this.activitiesLoader.setActivityListAccess((ListAccess<ExoSocialActivity>)activityManager.getActivitiesWithListAccess(ownerIdentity));
        } else if (DisplayMode.NETWORK_UPDATES.equals((Object)this.getSelectedDisplayMode())) {
            this.activitiesLoader.setActivityListAccess((ListAccess<ExoSocialActivity>)activityManager.getActivitiesOfConnectionsWithListAccess(ownerIdentity));
        } else if (DisplayMode.SPACE_UPDATES.equals((Object)this.getSelectedDisplayMode())) {
            this.activitiesLoader.setActivityListAccess((ListAccess<ExoSocialActivity>)activityManager.getActivitiesOfUserSpacesWithListAccess(ownerIdentity));
        } else {
            this.activitiesLoader.setActivityListAccess((ListAccess<ExoSocialActivity>)activityManager.getActivityFeedWithListAccess(ownerIdentity));
        }
        this.activitiesLoader.init();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeDisplayModeActionListener
    extends EventListener<UIUserActivitiesDisplay> {
        public void execute(Event<UIUserActivitiesDisplay> event) throws Exception {
            UIUserActivitiesDisplay uiUserActivitiesDisplay = (UIUserActivitiesDisplay)((Object)event.getSource());
            WebuiRequestContext requestContext = event.getRequestContext();
            String selectedDisplayMode = requestContext.getRequestParameter("objectId");
            if (selectedDisplayMode.equals(DisplayMode.ALL_UPDATES.toString())) {
                uiUserActivitiesDisplay.setSelectedDisplayMode(DisplayMode.ALL_UPDATES);
            } else if (selectedDisplayMode.equals(DisplayMode.MY_STATUS.toString())) {
                uiUserActivitiesDisplay.setSelectedDisplayMode(DisplayMode.MY_STATUS);
            } else if (selectedDisplayMode.equals(DisplayMode.SPACE_UPDATES.toString())) {
                uiUserActivitiesDisplay.setSelectedDisplayMode(DisplayMode.SPACE_UPDATES);
            } else {
                uiUserActivitiesDisplay.setSelectedDisplayMode(DisplayMode.NETWORK_UPDATES);
            }
            requestContext.addUIComponentToUpdateByAjax((UIComponent)uiUserActivitiesDisplay);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DisplayMode {
        OWNER_STATUS,
        ALL_UPDATES,
        NETWORK_UPDATES,
        SPACE_UPDATES,
        MY_STATUS;

    }
}

