/*
 * Copyright 2010 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "ln" locale.
 */
public class LocalizedNamesImpl_ln extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "AE",
        "AF",
        "AI",
        "AL",
        "AX",
        "DE",
        "DZ",
        "AM",
        "AN",
        "AD",
        "AO",
        "AG",
        "AQ",
        "AR",
        "AS",
        "AT",
        "AU",
        "AW",
        "AZ",
        "BD",
        "BB",
        "BH",
        "BY",
        "BJ",
        "BL",
        "BM",
        "BN",
        "BO",
        "BA",
        "BW",
        "BR",
        "BS",
        "BG",
        "BF",
        "BI",
        "BT",
        "BV",
        "BZ",
        "BE",
        "CC",
        "CI",
        "CK",
        "CL",
        "CO",
        "CP",
        "CR",
        "CU",
        "CV",
        "CX",
        "CY",
        "DG",
        "DJ",
        "DK",
        "DM",
        "DO",
        "EA",
        "EC",
        "EE",
        "EG",
        "ER",
        "ES",
        "US",
        "ET",
        "EU",
        "FR",
        "FI",
        "FJ",
        "FK",
        "FM",
        "FO",
        "GA",
        "GM",
        "GD",
        "GE",
        "GF",
        "GG",
        "GH",
        "GI",
        "GN",
        "GW",
        "GL",
        "GP",
        "GQ",
        "GR",
        "GS",
        "GT",
        "GU",
        "GY",
        "HK",
        "HM",
        "HN",
        "NL",
        "HT",
        "IC",
        "IL",
        "IM",
        "ID",
        "GB",
        "IO",
        "IQ",
        "IR",
        "IE",
        "IS",
        "IT",
        "JE",
        "JM",
        "CM",
        "CA",
        "KZ",
        "KE",
        "KH",
        "KI",
        "KG",
        "KM",
        "KN",
        "CG",
        "CD",
        "KP",
        "KR",
        "HR",
        "KW",
        "KY",
        "LA",
        "LC",
        "LV",
        "LI",
        "LB",
        "LR",
        "LY",
        "LT",
        "LK",
        "LS",
        "LU",
        "MA",
        "MV",
        "MO",
        "ML",
        "MK",
        "MC",
        "MD",
        "ME",
        "MF",
        "MG",
        "MH",
        "MM",
        "MN",
        "MZ",
        "MP",
        "MQ",
        "MR",
        "MS",
        "MT",
        "MU",
        "MW",
        "MX",
        "MY",
        "NA",
        "NC",
        "NP",
        "NF",
        "NI",
        "NE",
        "NG",
        "NO",
        "NR",
        "NU",
        "NZ",
        "OM",
        "PA",
        "PK",
        "PE",
        "PF",
        "PG",
        "PH",
        "PM",
        "PN",
        "PL",
        "PR",
        "PS",
        "PT",
        "PW",
        "PY",
        "QA",
        "QO",
        "RE",
        "CZ",
        "RS",
        "RO",
        "RU",
        "RW",
        "SA",
        "EH",
        "CF",
        "SH",
        "SM",
        "ST",
        "SB",
        "SC",
        "SG",
        "SI",
        "ZA",
        "CN",
        "SY",
        "SJ",
        "SK",
        "SL",
        "SN",
        "SO",
        "SR",
        "SD",
        "SV",
        "SE",
        "CH",
        "SZ",
        "TA",
        "TW",
        "TJ",
        "TC",
        "TD",
        "TF",
        "TH",
        "TK",
        "TL",
        "TO",
        "TG",
        "TT",
        "TN",
        "TR",
        "TM",
        "TV",
        "TZ",
        "UA",
        "UG",
        "UM",
        "HU",
        "UY",
        "UZ",
        "VA",
        "VC",
        "VE",
        "VG",
        "VI",
        "VN",
        "VU",
        "WF",
        "WS",
        "JP",
        "YE",
        "YT",
        "ZM",
        "ZW",
        "JO",
        "IN",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "mokili mobimba");
    namesMap.put("002", "Afríka");
    namesMap.put("005", "Ameríka ya Sídi");
    namesMap.put("011", "Afríka ya límbe");
    namesMap.put("015", "Afríka ya Nola");
    namesMap.put("018", "Afríka ya Sídi");
    namesMap.put("142", "Azía");
    namesMap.put("150", "Erópa");
    namesMap.put("154", "Erópa ya Nola");
    namesMap.put("155", "Erópa ya límbe");
    namesMap.put("AD", "Andora");
    namesMap.put("AF", "Afganistáni");
    namesMap.put("AG", "Antigua mpé Barbuda");
    namesMap.put("AO", "Angóla");
    namesMap.put("AX", "Albania");
    namesMap.put("BA", "Bosnia na Erzegovina");
    namesMap.put("BD", "Bángaladɛ́si");
    namesMap.put("BE", "Bɛ́ljika");
    namesMap.put("BR", "Bresíli");
    namesMap.put("BT", "Butáni");
    namesMap.put("BY", "Bielorusia");
    namesMap.put("CA", "Kanadá");
    namesMap.put("CD", "Kongó-Kinsásá");
    namesMap.put("CF", "Santrafríka");
    namesMap.put("CG", "Kongó-Brazzaville");
    namesMap.put("CH", "Swisi");
    namesMap.put("CM", "Kamerun");
    namesMap.put("CN", "Sína");
    namesMap.put("CZ", "Republiki Sheki");
    namesMap.put("DE", "Alémani");
    namesMap.put("DJ", "Djibuti");
    namesMap.put("DZ", "Aljeria");
    namesMap.put("EG", "Ejipti");
    namesMap.put("EH", "Sahara ya límbe");
    namesMap.put("ES", "Espania");
    namesMap.put("ET", "Etiopya");
    namesMap.put("FI", "Finilanda");
    namesMap.put("FR", "Falansia");
    namesMap.put("GB", "Ingɛlɛ́tɛlɛ");
    namesMap.put("GN", "Gine");
    namesMap.put("GR", "Gresi");
    namesMap.put("GW", "Gine-Bisau");
    namesMap.put("HR", "Kroasia");
    namesMap.put("HU", "Ungri");
    namesMap.put("ID", "Indoneziá");
    namesMap.put("IE", "Irlandí");
    namesMap.put("IN", "Ɛndɛ");
    namesMap.put("IS", "Islandi");
    namesMap.put("IT", "Italia");
    namesMap.put("JO", "Zordaní");
    namesMap.put("JP", "Yapan");
    namesMap.put("KG", "Kirghizistáni");
    namesMap.put("KP", "Kore ya Nola");
    namesMap.put("KR", "Kore ya Sidi");
    namesMap.put("KZ", "Kazakstáni");
    namesMap.put("LB", "Liban");
    namesMap.put("LT", "Litwani");
    namesMap.put("LU", "Luksamburg");
    namesMap.put("LV", "Letoni");
    namesMap.put("LY", "Libíya");
    namesMap.put("MK", "Masedoni");
    namesMap.put("MN", "Mongolí");
    namesMap.put("MO", "Makau");
    namesMap.put("MV", "Madívi");
    namesMap.put("MZ", "Mozambíki");
    namesMap.put("NE", "Nijé");
    namesMap.put("NG", "Nijeria");
    namesMap.put("NL", "Holanda");
    namesMap.put("NO", "Norvej");
    namesMap.put("NP", "Nepáli");
    namesMap.put("PK", "Pakistáni");
    namesMap.put("PL", "Poloni");
    namesMap.put("PT", "Pulutugal");
    namesMap.put("RO", "Rumania");
    namesMap.put("RU", "Rusí");
    namesMap.put("SD", "Sudani");
    namesMap.put("SE", "Swési");
    namesMap.put("SH", "Santu Helena");
    namesMap.put("SM", "Santu Marino");
    namesMap.put("ST", "Sǎo Tomé na Principe");
    namesMap.put("SY", "Sirí");
    namesMap.put("TJ", "Tazikistáni");
    namesMap.put("TM", "Turkmenistáni");
    namesMap.put("TN", "Tunizia");
    namesMap.put("TR", "Turkí");
    namesMap.put("TT", "Trinidad mpé Tobago");
    namesMap.put("US", "Etazíni");
    namesMap.put("UZ", "Uzbekistáni");
    namesMap.put("VA", "Vatikáni");
    namesMap.put("VN", "Vietnami");
    namesMap.put("YE", "Yeméni");
    namesMap.put("ZA", "Sidafríka");
    namesMap.put("ZZ", "Esíká eyébámí tɛ́");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "mokili mobimba",
        "002": "Afríka",
        "005": "Ameríka ya Sídi",
        "011": "Afríka ya límbe",
        "015": "Afríka ya Nola",
        "018": "Afríka ya Sídi",
        "142": "Azía",
        "150": "Erópa",
        "154": "Erópa ya Nola",
        "155": "Erópa ya límbe",
        "AD": "Andora",
        "AF": "Afganistáni",
        "AG": "Antigua mpé Barbuda",
        "AO": "Angóla",
        "AX": "Albania",
        "BA": "Bosnia na Erzegovina",
        "BD": "Bángaladɛ́si",
        "BE": "Bɛ́ljika",
        "BR": "Bresíli",
        "BT": "Butáni",
        "BY": "Bielorusia",
        "CA": "Kanadá",
        "CD": "Kongó-Kinsásá",
        "CF": "Santrafríka",
        "CG": "Kongó-Brazzaville",
        "CH": "Swisi",
        "CM": "Kamerun",
        "CN": "Sína",
        "CZ": "Republiki Sheki",
        "DE": "Alémani",
        "DJ": "Djibuti",
        "DZ": "Aljeria",
        "EG": "Ejipti",
        "EH": "Sahara ya límbe",
        "ES": "Espania",
        "ET": "Etiopya",
        "FI": "Finilanda",
        "FR": "Falansia",
        "GB": "Ingɛlɛ́tɛlɛ",
        "GN": "Gine",
        "GR": "Gresi",
        "GW": "Gine-Bisau",
        "HR": "Kroasia",
        "HU": "Ungri",
        "ID": "Indoneziá",
        "IE": "Irlandí",
        "IN": "Ɛndɛ",
        "IS": "Islandi",
        "IT": "Italia",
        "JO": "Zordaní",
        "JP": "Yapan",
        "KG": "Kirghizistáni",
        "KP": "Kore ya Nola",
        "KR": "Kore ya Sidi",
        "KZ": "Kazakstáni",
        "LB": "Liban",
        "LT": "Litwani",
        "LU": "Luksamburg",
        "LV": "Letoni",
        "LY": "Libíya",
        "MK": "Masedoni",
        "MN": "Mongolí",
        "MO": "Makau",
        "MV": "Madívi",
        "MZ": "Mozambíki",
        "NE": "Nijé",
        "NG": "Nijeria",
        "NL": "Holanda",
        "NO": "Norvej",
        "NP": "Nepáli",
        "PK": "Pakistáni",
        "PL": "Poloni",
        "PT": "Pulutugal",
        "RO": "Rumania",
        "RU": "Rusí",
        "SD": "Sudani",
        "SE": "Swési",
        "SH": "Santu Helena",
        "SM": "Santu Marino",
        "ST": "Sǎo Tomé na Principe",
        "SY": "Sirí",
        "TJ": "Tazikistáni",
        "TM": "Turkmenistáni",
        "TN": "Tunizia",
        "TR": "Turkí",
        "TT": "Trinidad mpé Tobago",
        "US": "Etazíni",
        "UZ": "Uzbekistáni",
        "VA": "Vatikáni",
        "VN": "Vietnami",
        "YE": "Yeméni",
        "ZA": "Sidafríka",
        "ZZ": "Esíká eyébámí tɛ́"
    };
  }-*/;
}
