/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.sidebar;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.query.Query;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.ecm.webui.component.explorer.UIDocumentWorkspace;
import org.exoplatform.ecm.webui.component.explorer.UIDrivesArea;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.component.explorer.search.UIContentNameSearch;
import org.exoplatform.ecm.webui.component.explorer.search.UIECMSearch;
import org.exoplatform.ecm.webui.component.explorer.search.UISavedQuery;
import org.exoplatform.ecm.webui.component.explorer.search.UISearchResult;
import org.exoplatform.ecm.webui.component.explorer.search.UISimpleSearch;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.queries.QueryService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/webui/component/explorer/sidebar/UISavedSearches.gtmpl", events={@EventConfig(listeners={ExecuteActionListener.class}), @EventConfig(listeners={AdvanceSearchActionListener.class}), @EventConfig(listeners={SavedQueriesActionListener.class})})
public class UISavedSearches
extends UIComponent {
    public static final String ACTION_TAXONOMY = "exo:taxonomyAction";
    public static final String EXO_TARGETPATH = "exo:targetPath";
    public static final String EXO_TARGETWORKSPACE = "exo:targetWorkspace";
    private String queryPath;

    public List<Object> queryList() throws Exception {
        List<Query> queries;
        ArrayList<Object> objectList = new ArrayList<Object>();
        List<Node> sharedQueries = this.getSharedQueries();
        if (!sharedQueries.isEmpty()) {
            for (Node node : sharedQueries) {
                objectList.add(new NodeData(node));
            }
        }
        if (!(queries = this.getQueries()).isEmpty()) {
            for (Query query : queries) {
                objectList.add(new QueryData(query));
            }
        }
        return objectList;
    }

    public String getCurrentUserId() {
        return Util.getPortalRequestContext().getRemoteUser();
    }

    public List<Query> getQueries() throws Exception {
        QueryService queryService = (QueryService)this.getApplicationComponent(QueryService.class);
        try {
            return queryService.getQueries(this.getCurrentUserId(), WCMCoreUtils.getUserSessionProvider());
        }
        catch (AccessDeniedException ace) {
            return new ArrayList<Query>();
        }
    }

    public List<Node> getSharedQueries() throws Exception {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        QueryService queryService = (QueryService)this.getApplicationComponent(QueryService.class);
        String userId = pcontext.getRemoteUser();
        return queryService.getSharedQueries(userId, WCMCoreUtils.getSystemSessionProvider());
    }

    public void setQueryPath(String queryPath) throws Exception {
        this.queryPath = queryPath;
    }

    public String getQueryPath() throws Exception {
        return this.queryPath;
    }

    public class NodeData {
        private String path_;
        private String name_;

        public NodeData(Node node) throws RepositoryException {
            this.path_ = node.getPath();
            this.name_ = node.getName();
        }

        public String getPath() {
            return this.path_;
        }

        public void setPath(String path) {
            this.path_ = path;
        }

        public String getName() {
            return this.name_;
        }

        public void setName(String name) {
            this.name_ = name;
        }
    }

    public class QueryData {
        private String storedQueryPath_;

        public QueryData(Query query) {
            try {
                this.storedQueryPath_ = query.getStoredQueryPath();
            }
            catch (RepositoryException e) {
                this.storedQueryPath_ = "";
            }
        }

        public String getStoredQueryPath() {
            return this.storedQueryPath_;
        }

        public void setStoredQueryPath(String storedQueryPath) {
            this.storedQueryPath_ = storedQueryPath;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SavedQueriesActionListener
    extends EventListener<UISavedSearches> {
        public void execute(Event<UISavedSearches> event) throws Exception {
            UIJCRExplorer uiJCRExplorer = (UIJCRExplorer)((UISavedSearches)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            UIPopupContainer UIPopupContainer2 = (UIPopupContainer)uiJCRExplorer.getChild(UIPopupContainer.class);
            UISavedQuery uiSavedQuery = (UISavedQuery)((UISavedSearches)((Object)event.getSource())).createUIComponent(UISavedQuery.class, null, null);
            uiSavedQuery.setIsQuickSearch(true);
            uiSavedQuery.updateGrid(1);
            UIPopupContainer2.activate((UIComponent)uiSavedQuery, 700, 400);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)UIPopupContainer2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AdvanceSearchActionListener
    extends EventListener<UISavedSearches> {
        public void execute(Event<UISavedSearches> event) throws Exception {
            UIJCRExplorer uiJCRExplorer = (UIJCRExplorer)((UISavedSearches)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            UIPopupContainer UIPopupContainer2 = (UIPopupContainer)uiJCRExplorer.getChild(UIPopupContainer.class);
            UIECMSearch uiECMSearch = (UIECMSearch)((UISavedSearches)((Object)event.getSource())).createUIComponent(UIECMSearch.class, null, null);
            UIContentNameSearch contentNameSearch = (UIContentNameSearch)uiECMSearch.findFirstComponentOfType(UIContentNameSearch.class);
            String currentNodePath = uiJCRExplorer.getCurrentNode().getPath();
            contentNameSearch.setLocation(currentNodePath);
            UISimpleSearch uiSimpleSearch = (UISimpleSearch)uiECMSearch.findFirstComponentOfType(UISimpleSearch.class);
            uiSimpleSearch.getUIFormInputInfo("nodePath").setValue((Object)currentNodePath);
            UIPopupContainer2.activate((UIComponent)uiECMSearch, 800, 500, false);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)UIPopupContainer2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExecuteActionListener
    extends EventListener<UISavedSearches> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Event<UISavedSearches> event) throws Exception {
            UISavedSearches uiSavedSearches = (UISavedSearches)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiSavedSearches.getAncestorOfType(UIJCRExplorer.class);
            String queryPath = event.getRequestContext().getRequestParameter("objectId");
            uiSavedSearches.setQueryPath(queryPath);
            uiExplorer.setPathToAddressBar(Text.unescapeIllegalJcrChars((String)uiExplorer.filterPath(queryPath)));
            String wsName = ((UIJCRExplorer)uiSavedSearches.getAncestorOfType(UIJCRExplorer.class)).getCurrentWorkspace();
            UIApplication uiApp = (UIApplication)uiSavedSearches.getAncestorOfType(UIApplication.class);
            QueryService queryService = (QueryService)uiSavedSearches.getApplicationComponent(QueryService.class);
            UIWorkingArea uiWorkingArea = (UIWorkingArea)uiExplorer.getChild(UIWorkingArea.class);
            UIComponent uiSearch = uiWorkingArea.getChild(UIDocumentWorkspace.class);
            UIDrivesArea uiDrivesArea = (UIDrivesArea)uiWorkingArea.getChild(UIDrivesArea.class);
            UISearchResult uiSearchResult = (UISearchResult)((UIDocumentWorkspace)uiSearch).getChild(UISearchResult.class);
            Query query = null;
            try {
                query = queryService.getQuery(queryPath, wsName, WCMCoreUtils.getSystemSessionProvider(), uiSavedSearches.getCurrentUserId());
                query.execute();
            }
            catch (Exception e) {
                uiApp.addMessage(new ApplicationMessage("UISearchResult.msg.query-invalid", null, 1));
            }
            finally {
                uiSearchResult.setQuery(query.getStatement(), wsName, query.getLanguage(), false, null);
                uiSearchResult.updateGrid();
            }
            if (uiDrivesArea != null) {
                uiDrivesArea.setRendered(false);
            }
            ((UIDocumentWorkspace)uiWorkingArea.getChild(UIDocumentWorkspace.class)).setRendered(true);
            ((UIDocumentWorkspace)uiSearch).setRenderedChild(UISearchResult.class);
        }
    }
}

