/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web;

import java.util.EventObject;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpSessionEvent;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.util.EnvSpecific;
import org.exoplatform.container.web.AbstractHttpSessionListener;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericHttpListener
extends AbstractHttpSessionListener
implements ServletContextListener {
    public static final String SESSION_CREATED = "org.exoplatform.web.GenericHttpListener.sessionCreated";
    public static final String SESSION_DESTROYED = "org.exoplatform.web.GenericHttpListener.sessionDestroyed";
    public static final String CONTEXT_INITIALIZED = "org.exoplatform.web.GenericHttpListener.contextInitialized";
    public static final String CONTEXT_DESTROYED = "org.exoplatform.web.GenericHttpListener.contextDestroyed";
    private static Log log = ExoLogger.getLogger((String)"portal:GenericHttpListener");

    protected void onSessionCreated(ExoContainer container, HttpSessionEvent event) {
        try {
            this.broadcast((PortalContainer)container, SESSION_CREATED, event);
        }
        catch (Exception ex) {
            log.error((Object)"Error on sessionCreated", (Throwable)ex);
        }
    }

    protected void onSessionDestroyed(ExoContainer container, HttpSessionEvent event) {
        try {
            this.broadcast((PortalContainer)container, SESSION_DESTROYED, event);
        }
        catch (Exception ex) {
            log.error((Object)"Error on sessionDestroyed", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextDestroyed(ServletContextEvent event) {
        boolean hasBeenSet = false;
        ExoContainer oldContainer = ExoContainerContext.getCurrentContainer();
        try {
            String ctxName;
            PortalContainer portalContainer = PortalContainer.getInstanceIfPresent();
            if (portalContainer == null) {
                portalContainer = PortalContainer.getCurrentInstance((ServletContext)event.getServletContext());
                PortalContainer.setInstance((PortalContainer)portalContainer);
                hasBeenSet = true;
            }
            if (!PortalContainer.isPortalContainerNameDisabled((String)(ctxName = event.getServletContext().getServletContextName())) && portalContainer instanceof PortalContainer) {
                this.broadcast(portalContainer, CONTEXT_DESTROYED, event);
            } else if (PropertyManager.isDevelopping()) {
                log.info((Object)("The portal environment could not be set for the webapp '" + ctxName + "' because this servlet context has not been defined as a " + "dependency of any portal container or it is a disabled portal" + " container, the contextDestroyed event will be ignored"));
            }
        }
        catch (Exception ex) {
            log.error((Object)"Error on contextDestroyed", (Throwable)ex);
        }
        finally {
            if (hasBeenSet) {
                PortalContainer.setInstance(null);
                ExoContainerContext.setCurrentContainer((ExoContainer)oldContainer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextInitialized(final ServletContextEvent event) {
        RootContainer.PortalContainerPostInitTask task = new RootContainer.PortalContainerPostInitTask(){

            public void execute(ServletContext scontext, PortalContainer portalContainer) {
                try {
                    GenericHttpListener.this.broadcast(portalContainer, GenericHttpListener.CONTEXT_INITIALIZED, (EventObject)event);
                }
                catch (Exception ex) {
                    log.error((Object)"Error on contextInitialized", (Throwable)ex);
                }
            }
        };
        ServletContext ctx = event.getServletContext();
        try {
            EnvSpecific.initThreadEnv((ServletContext)ctx);
            RootContainer.getInstance().addInitTask(event.getServletContext(), (RootContainer.PortalContainerInitTask)task);
        }
        finally {
            EnvSpecific.cleanupThreadEnv((ServletContext)ctx);
        }
    }

    protected boolean requirePortalEnvironment() {
        return true;
    }

    private <T extends EventObject> void broadcast(PortalContainer portalContainer, String eventName, T event) {
        try {
            ListenerService listenerService = (ListenerService)portalContainer.getComponentInstanceOfType(ListenerService.class);
            listenerService.broadcast(eventName, (Object)portalContainer, event);
        }
        catch (Exception e) {
            log.warn((Object)("Cannot broadcast the event '" + eventName + "'"), (Throwable)e);
        }
    }
}

