/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.form.validator;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.exception.MessageException;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormDateTimeInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.validator.DateTimeValidator;

public class DateValidator
extends DateTimeValidator {
    public void validate(UIFormInput uiInput) throws Exception {
        String inputValue = (String)uiInput.getValue();
        if (inputValue.trim().indexOf(" ") > 0) {
            super.validate(uiInput);
        } else {
            this.validateDateFormat(uiInput);
        }
    }

    private void validateDateFormat(UIFormInput uiInput) throws Exception {
        String inputValue = (String)uiInput.getValue();
        try {
            WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            DateFormat dateFormat_ = SimpleDateFormat.getDateInstance(3, requestContext.getLocale());
            dateFormat_.setLenient(false);
            dateFormat_.parse(inputValue);
            ((UIFormDateTimeInput)uiInput).setValue((Object)(inputValue + " 00:00:00"));
        }
        catch (ParseException parseEx) {
            String label;
            UIComponent uiComponent = (UIComponent)uiInput;
            UIForm uiForm = (UIForm)uiComponent.getAncestorOfType(UIForm.class);
            try {
                label = uiForm.getLabel(uiInput.getName());
            }
            catch (Exception ex) {
                label = uiInput.getName();
            }
            label = label.trim();
            if (label.charAt(label.length() - 1) == ':') {
                label = label.substring(0, label.length() - 1);
            }
            throw new MessageException(new ApplicationMessage("DateTimeValidator.msg.Invalid-input", new Object[]{label, inputValue}));
        }
    }
}

