/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.nodetype;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import org.exoplatform.ecm.webui.component.admin.nodetype.UINodeTypeForm;
import org.exoplatform.ecm.webui.component.admin.nodetype.UINodeTypeManager;
import org.exoplatform.ecm.webui.form.UIFormInputSetWithAction;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormTableInputSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/ecm/webui/form/UIFormInputSetWithAction.gtmpl", events={@EventConfig(listeners={AddTypeActionListener.class})})
public class UINodeTypeOptionList
extends UIFormInputSetWithAction {
    static final String TABLE_NAME = "UINodeTypeOptionList";
    static final String[] TABLE_COLUMNS = new String[]{"label", "input"};

    public UINodeTypeOptionList(String name) throws Exception {
        super(name);
        this.setComponentConfig(((Object)((Object)this)).getClass(), null);
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        super.processRender(context);
    }

    private boolean getCheckedValue(String values, String name) {
        String[] selectNodes = values.split(",");
        for (int i = 0; i < selectNodes.length; ++i) {
            if (!selectNodes[i].equals(name)) continue;
            return true;
        }
        return false;
    }

    public void update(String values) throws Exception {
        UIFormTableInputSet uiTableInputSet = (UIFormTableInputSet)this.createUIComponent(UIFormTableInputSet.class, null, null);
        ExtendedNodeTypeManager ntManager = ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getCurrentRepository().getNodeTypeManager();
        NodeTypeIterator nodeTypeIter = ntManager.getAllNodeTypes();
        ArrayList<NodeType> nodeTypeList = new ArrayList<NodeType>();
        while (nodeTypeIter.hasNext()) {
            NodeType nt = nodeTypeIter.nextNodeType();
            nodeTypeList.add(nt);
        }
        Collections.sort(nodeTypeList, new Utils.NodeTypeNameComparator());
        uiTableInputSet.setName(TABLE_NAME);
        uiTableInputSet.setColumns(TABLE_COLUMNS);
        for (NodeType nt : nodeTypeList) {
            String ntName = nt.getName();
            UIFormInputSet uiInputSet = new UIFormInputSet(ntName);
            UIFormInputInfo uiInfo = new UIFormInputInfo("label", null, ntName);
            uiInputSet.addChild((UIComponent)uiInfo);
            UIFormCheckBoxInput uiCheckbox = new UIFormCheckBoxInput(ntName, ntName, null);
            if (values != null) {
                if (this.getCheckedValue(values, ntName)) {
                    uiCheckbox.setChecked(true);
                }
            } else {
                uiCheckbox.setChecked(false);
            }
            uiCheckbox.setValue((Object)ntName);
            uiInputSet.addChild((UIComponent)uiCheckbox);
            uiTableInputSet.addChild((UIComponent)uiInputSet);
        }
        this.addUIFormInput((UIFormInputSet)uiTableInputSet);
    }

    private void setFieldValues(String fieldName, List<String> selectedNodes) throws Exception {
        StringBuffer strNodeList = null;
        UINodeTypeForm uiNodeTypeForm = (UINodeTypeForm)this.getParent();
        for (int i = 0; i < selectedNodes.size(); ++i) {
            if (strNodeList == null) {
                strNodeList = new StringBuffer(selectedNodes.get(i));
                continue;
            }
            strNodeList.append(",").append(selectedNodes.get(i));
        }
        uiNodeTypeForm.getUIStringInput(fieldName).setValue((Object)strNodeList.toString());
        if (fieldName.equals("superTypes")) {
            for (UIComponent uiComp : uiNodeTypeForm.getChildren()) {
                UIFormInputSetWithAction tab = (UIFormInputSetWithAction)uiNodeTypeForm.getChildById(uiComp.getId());
                if (!tab.getId().equals("nodeTypeDefinition")) continue;
                uiNodeTypeForm.setSelectedTab(tab.getId());
            }
            uiNodeTypeForm.removeChildById("SuperTypeTab");
        } else if (fieldName.equals("requiredPrimaryType")) {
            for (UIComponent uiComp : uiNodeTypeForm.getChildren()) {
                UIFormInputSetWithAction tab = (UIFormInputSetWithAction)uiNodeTypeForm.getChildById(uiComp.getId());
                if (!tab.getId().equals("childNodeDefinition")) continue;
                uiNodeTypeForm.setSelectedTab(tab.getId());
            }
            uiNodeTypeForm.removeChildById("RequiredTypeTab");
        } else if (fieldName.equals("defaultPrimaryType")) {
            for (UIComponent uiComp : uiNodeTypeForm.getChildren()) {
                UIFormInputSetWithAction tab = (UIFormInputSetWithAction)uiNodeTypeForm.getChildById(uiComp.getId());
                if (!tab.getId().equals("childNodeDefinition")) continue;
                uiNodeTypeForm.setSelectedTab(tab.getId());
            }
            uiNodeTypeForm.removeChildById("DefaultTypeTab");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelTabActionListener
    extends EventListener<UINodeTypeForm> {
        public void execute(Event<UINodeTypeForm> event) throws Exception {
            UINodeTypeForm uiForm = (UINodeTypeForm)((Object)event.getSource());
            String tabName = event.getRequestContext().getRequestParameter("objectId");
            if (tabName.equals("SuperTypeTab")) {
                uiForm.removeChildById(tabName);
                uiForm.setSelectedTab("nodeTypeDefinition");
            } else if (tabName.equals("DefaultTypeTab") || tabName.equals("RequiredTypeTab")) {
                uiForm.removeChildById(tabName);
                uiForm.setSelectedTab("childNodeDefinition");
            }
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddTypeActionListener
    extends EventListener<UINodeTypeForm> {
        public void execute(Event<UINodeTypeForm> event) throws Exception {
            UINodeTypeForm uiForm = (UINodeTypeForm)((Object)event.getSource());
            UINodeTypeOptionList uiOptionList = (UINodeTypeOptionList)uiForm.getChild(UINodeTypeOptionList.class);
            UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
            String fieldName = event.getRequestContext().getRequestParameter("objectId");
            ArrayList<String> selectedNodes = new ArrayList<String>();
            UINodeTypeManager uiManager = (UINodeTypeManager)uiForm.getAncestorOfType(UINodeTypeManager.class);
            ArrayList listCheckbox = new ArrayList();
            uiForm.findComponentOfType(listCheckbox, UIFormCheckBoxInput.class);
            int count = 0;
            for (int i = 0; i < listCheckbox.size(); ++i) {
                if (!((UIFormCheckBoxInput)listCheckbox.get(i)).isChecked()) continue;
                selectedNodes.add(((UIFormCheckBoxInput)listCheckbox.get(i)).getName());
                ++count;
            }
            if (fieldName.equals("defaultPrimaryType") && count > 1) {
                uiApp.addMessage(new ApplicationMessage("UINodeTypeForm.msg.values-error", null));
                uiForm.setTabRender("DefaultTypeTab");
                return;
            }
            uiOptionList.setFieldValues(fieldName, selectedNodes);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }
}

