/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.text;

import org.gatein.common.text.CharEncoder;
import org.gatein.common.text.CharWriter;
import org.gatein.common.util.ParameterValidation;

public class CharBuffer
implements CharWriter {
    protected char[] buffer;
    protected int length;

    public CharBuffer(int size) throws IllegalArgumentException {
        if (size < 0) {
            throw new IllegalArgumentException("Size must be positive!");
        }
        this.buffer = new char[size];
        this.length = 0;
    }

    public CharBuffer() {
        this.buffer = new char[512];
        this.length = 0;
    }

    public CharBuffer append(String s, CharEncoder encoder) {
        ParameterValidation.throwIllegalArgExceptionIfNull(s, "String");
        ParameterValidation.throwIllegalArgExceptionIfNull(encoder, "CharEncoder");
        encoder.encode(s, (CharWriter)this);
        return this;
    }

    @Override
    public CharWriter append(CharSequence s) {
        ParameterValidation.throwIllegalArgExceptionIfNull(s, "CharSequence");
        this.appendNoCheck(s);
        return this;
    }

    @Override
    public CharWriter append(char[] chars, int off, int len) {
        ParameterValidation.throwIllegalArgExceptionIfRangeInvalid(chars, off, len);
        this.appendNoCheck(chars, off, len);
        return this;
    }

    @Override
    public CharWriter append(char c) {
        this.ensureCapacity(this.length + 1);
        this.buffer[this.length++] = c;
        return this;
    }

    @Override
    public CharWriter append(char[] chars) {
        ParameterValidation.throwIllegalArgExceptionIfNull(chars, "char[]");
        this.appendNoCheck(chars, 0, chars.length);
        return this;
    }

    public String asString() {
        return this.asString(true);
    }

    public String asString(boolean reset) {
        String s = new String(this.buffer, 0, this.length);
        if (reset) {
            this.reset();
        }
        return s;
    }

    public int getCapacity() {
        return this.buffer.length;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("Length must be positive!");
        }
        this.length = length;
        if (length > this.buffer.length) {
            char[] tmp = new char[length];
            System.arraycopy(this.buffer, 0, tmp, 0, this.buffer.length);
            this.buffer = tmp;
        }
    }

    public void reset() {
        this.length = 0;
    }

    protected final void appendNoCheck(char[] chars, int off, int len) {
        this.ensureCapacity(this.length + len);
        if (len < 10) {
            int toCopy = off + len;
            while (off < toCopy) {
                this.buffer[this.length++] = chars[off++];
            }
        } else {
            System.arraycopy(chars, off, this.buffer, this.length, len);
            this.length += len;
        }
    }

    protected final void appendNoCheck(CharSequence s) {
        this.ensureCapacity(this.length + s.length());
        if (s instanceof String) {
            ((String)s).getChars(0, s.length(), this.buffer, this.length);
            this.length += s.length();
        } else {
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                this.buffer[this.length++] = c;
            }
        }
    }

    protected final void ensureCapacity(int minimumCapacity) {
        int capacity = this.buffer.length;
        if (capacity < minimumCapacity) {
            while (capacity < minimumCapacity) {
                capacity = capacity * 2 + 1;
            }
            char[] tmp = new char[capacity];
            System.arraycopy(this.buffer, 0, tmp, 0, this.length);
            this.buffer = tmp;
        }
    }
}

