/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.io.IOException;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.Iterator;
import net.fortuna.ical4j.model.ComponentFactory;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateList;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Dur;
import net.fortuna.ical4j.model.Period;
import net.fortuna.ical4j.model.PeriodList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.ValidationException;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.model.property.DtEnd;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.Duration;
import net.fortuna.ical4j.model.property.ExDate;
import net.fortuna.ical4j.model.property.ExRule;
import net.fortuna.ical4j.model.property.RDate;
import net.fortuna.ical4j.model.property.RRule;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public abstract class Component
implements Serializable {
    public static final String BEGIN = "BEGIN";
    public static final String END = "END";
    public static final String VEVENT = "VEVENT";
    public static final String VTODO = "VTODO";
    public static final String VJOURNAL = "VJOURNAL";
    public static final String VFREEBUSY = "VFREEBUSY";
    public static final String VTIMEZONE = "VTIMEZONE";
    public static final String VALARM = "VALARM";
    public static final String VAVAILABILITY = "VAVAILABILITY";
    public static final String VVENUE = "VVENUE";
    public static final String AVAILABLE = "AVAILABLE";
    public static final String EXPERIMENTAL_PREFIX = "X-";
    private String name;
    private PropertyList properties;

    protected Component(String s) {
        this(s, new PropertyList());
    }

    protected Component(String s, PropertyList p) {
        this.name = s;
        this.properties = p;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(BEGIN);
        buffer.append(':');
        buffer.append(this.getName());
        buffer.append("\r\n");
        buffer.append(this.getProperties());
        buffer.append(END);
        buffer.append(':');
        buffer.append(this.getName());
        buffer.append("\r\n");
        return buffer.toString();
    }

    public final String getName() {
        return this.name;
    }

    public final PropertyList getProperties() {
        return this.properties;
    }

    public final PropertyList getProperties(String name) {
        return this.getProperties().getProperties(name);
    }

    public final Property getProperty(String name) {
        return this.getProperties().getProperty(name);
    }

    public final void validate() throws ValidationException {
        this.validate(true);
    }

    public abstract void validate(boolean var1) throws ValidationException;

    protected final void validateProperties() throws ValidationException {
        Iterator i = this.getProperties().iterator();
        while (i.hasNext()) {
            Property property = (Property)i.next();
            property.validate();
        }
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof Component) {
            Component c = (Component)arg0;
            return new EqualsBuilder().append((Object)this.getName(), (Object)c.getName()).append((Object)this.getProperties(), (Object)c.getProperties()).isEquals();
        }
        return super.equals(arg0);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getName()).append((Object)this.getProperties()).toHashCode();
    }

    public Component copy() throws ParseException, IOException, URISyntaxException {
        PropertyList newprops = new PropertyList(this.getProperties());
        return ComponentFactory.getInstance().createComponent(this.getName(), newprops);
    }

    public final PeriodList calculateRecurrenceSet(Period period) {
        Iterator j;
        PeriodList recurrenceSet = new PeriodList();
        DtStart start = (DtStart)this.getProperty("DTSTART");
        DtEnd end = (DtEnd)this.getProperty("DTEND");
        Duration duration = (Duration)this.getProperty("DURATION");
        if (start == null) {
            return recurrenceSet;
        }
        Value startValue = (Value)start.getParameter("VALUE");
        if (start.getDate() instanceof DateTime) {
            recurrenceSet.setTimeZone(((DateTime)start.getDate()).getTimeZone());
        }
        Dur rDuration = end == null && duration == null ? new Dur(start.getDate(), start.getDate()) : (duration == null ? new Dur(start.getDate(), end.getDate()) : duration.getDuration());
        Iterator i = this.getProperties("RDATE").iterator();
        while (i.hasNext()) {
            Iterator j2;
            RDate rdate = (RDate)i.next();
            Value rdateValue = (Value)rdate.getParameter("VALUE");
            if (Value.PERIOD.equals(rdateValue)) {
                j2 = rdate.getPeriods().iterator();
                while (j2.hasNext()) {
                    Period rdatePeriod = (Period)j2.next();
                    if (!period.intersects(rdatePeriod)) continue;
                    recurrenceSet.add(period);
                }
                continue;
            }
            if (Value.DATE_TIME.equals(rdateValue)) {
                j2 = rdate.getDates().iterator();
                while (j2.hasNext()) {
                    DateTime rdateTime = (DateTime)j2.next();
                    if (!period.includes(rdateTime)) continue;
                    recurrenceSet.add(new Period(rdateTime, rDuration));
                }
                continue;
            }
            j2 = rdate.getDates().iterator();
            while (j2.hasNext()) {
                DateTime rdateDate = (DateTime)j2.next();
                if (!period.includes(rdateDate)) continue;
                recurrenceSet.add(new Period(new DateTime(rdateDate), rDuration));
            }
        }
        DateTime startMinusDuration = new DateTime(period.getStart());
        startMinusDuration.setTime(rDuration.negate().getTime(period.getStart()).getTime());
        Iterator i2 = this.getProperties("RRULE").iterator();
        while (i2.hasNext()) {
            RRule rrule = (RRule)i2.next();
            DateList rruleDates = rrule.getRecur().getDates(start.getDate(), new Period(startMinusDuration, period.getEnd()), startValue);
            j = rruleDates.iterator();
            while (j.hasNext()) {
                Date rruleDate = (Date)j.next();
                recurrenceSet.add(new Period(new DateTime(rruleDate), rDuration));
            }
        }
        Period startPeriod = null;
        if (end != null) {
            startPeriod = new Period(new DateTime(start.getDate()), new DateTime(end.getDate()));
        } else {
            if (duration == null) {
                duration = new Duration(rDuration);
            }
            startPeriod = new Period(new DateTime(start.getDate()), duration.getDuration());
        }
        if (period.intersects(startPeriod)) {
            recurrenceSet.add(startPeriod);
        }
        Iterator i3 = this.getProperties("EXDATE").iterator();
        while (i3.hasNext()) {
            ExDate exdate = (ExDate)i3.next();
            j = recurrenceSet.iterator();
            while (j.hasNext()) {
                Period recurrence = (Period)j.next();
                if (!exdate.getDates().contains(recurrence.getStart()) && !exdate.getDates().contains(new Date(recurrence.getStart()))) continue;
                j.remove();
            }
        }
        i3 = this.getProperties("EXRULE").iterator();
        while (i3.hasNext()) {
            ExRule exrule = (ExRule)i3.next();
            DateList exruleDates = exrule.getRecur().getDates(start.getDate(), period, startValue);
            Iterator j3 = recurrenceSet.iterator();
            while (j3.hasNext()) {
                Period recurrence = (Period)j3.next();
                if (!exruleDates.contains(recurrence.getStart()) && !exruleDates.contains(new Date(recurrence.getStart()))) continue;
                j3.remove();
            }
        }
        return recurrenceSet;
    }
}

