/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.spi;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.xcmis.spi.FilterNotValidException;

public class PropertyFilter {
    public static final String ALL = "*";
    public static final PropertyFilter ALL_FILTER = new PropertyFilter();
    private static final Pattern SPLITTER;
    private static final String ILLEGAL_CHARACTERS = ",\"'\\.()";
    private Set<String> propertyNames;
    private boolean retrievalAllProperties = false;

    public PropertyFilter(String filterString) throws FilterNotValidException {
        if (filterString == null || filterString.length() == 0) {
            this.retrievalAllProperties = true;
            return;
        }
        if (ALL.equals(filterString = filterString.trim())) {
            this.retrievalAllProperties = true;
        } else {
            this.propertyNames = new HashSet<String>();
            for (String token : SPLITTER.split(filterString)) {
                if (token.length() > 0 && !token.equals(ALL)) {
                    for (char ch : token.toCharArray()) {
                        if (!Character.isWhitespace(ch) && ILLEGAL_CHARACTERS.indexOf(ch) == -1) continue;
                        String msg = "Invalid filter \"" + filterString + "\" contains illegal characters.";
                        throw new FilterNotValidException(msg);
                    }
                } else {
                    String msg = "Invalid filter \"" + filterString + "\". Filter must contains either '*' OR comma-separated list of properties.";
                    throw new FilterNotValidException(msg);
                }
                this.propertyNames.add(token);
            }
        }
    }

    protected PropertyFilter() {
    }

    public boolean accept(String name) {
        return this.retrievalAllProperties || this.propertyNames.contains(name);
    }

    static {
        PropertyFilter.ALL_FILTER.retrievalAllProperties = true;
        SPLITTER = Pattern.compile("\\s*,\\s*");
    }
}

