/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.method;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.ws.rs.FormParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import org.exoplatform.services.rest.ApplicationContext;
import org.exoplatform.services.rest.Parameter;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;
import org.exoplatform.services.rest.impl.method.ParameterHelper;
import org.exoplatform.services.rest.impl.method.ParameterResolver;
import org.exoplatform.services.rest.method.TypeProducer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormParameterResolver
extends ParameterResolver<FormParam> {
    private static final Type FORM_TYPE = (ParameterizedType)MultivaluedMapImpl.class.getGenericInterfaces()[0];
    private final FormParam formParam;

    FormParameterResolver(FormParam formParam) {
        this.formParam = formParam;
    }

    @Override
    public Object resolve(Parameter parameter, ApplicationContext context) throws Exception {
        String param = this.formParam.value();
        TypeProducer typeProducer = ParameterHelper.createTypeProducer(parameter.getParameterClass(), parameter.getGenericType());
        MediaType conetentType = context.getHttpHeaders().getMediaType();
        MessageBodyReader<MultivaluedMap> reader = context.getProviders().getMessageBodyReader(MultivaluedMap.class, FORM_TYPE, null, conetentType);
        if (reader == null) {
            throw new IllegalStateException("Can't find appropriate entity reader for entity type " + MultivaluedMap.class.getName() + " and content-type " + conetentType);
        }
        MultivaluedMap form = (MultivaluedMap)reader.readFrom(MultivaluedMap.class, FORM_TYPE, null, conetentType, context.getHttpHeaders().getRequestHeaders(), context.getContainerRequest().getEntityStream());
        return typeProducer.createValue(param, (MultivaluedMap<String, String>)form, parameter.getDefaultValue());
    }
}

