/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import org.exoplatform.services.rest.provider.EntityProvider;
import org.exoplatform.ws.frameworks.json.JsonHandler;
import org.exoplatform.ws.frameworks.json.JsonWriter;
import org.exoplatform.ws.frameworks.json.impl.BeanBuilder;
import org.exoplatform.ws.frameworks.json.impl.JsonDefaultHandler;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.exoplatform.ws.frameworks.json.impl.JsonGeneratorImpl;
import org.exoplatform.ws.frameworks.json.impl.JsonParserImpl;
import org.exoplatform.ws.frameworks.json.impl.JsonWriterImpl;
import org.exoplatform.ws.frameworks.json.value.JsonValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class JsonEntityProvider
implements EntityProvider<Object> {
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Object.class.isAssignableFrom(type);
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        try {
            JsonParserImpl jsonParser = new JsonParserImpl();
            JsonDefaultHandler jsonHandler = new JsonDefaultHandler();
            jsonParser.parse(entityStream, (JsonHandler)jsonHandler);
            JsonValue jsonValue = jsonHandler.getJsonObject();
            if (jsonValue == null) {
                return null;
            }
            return new BeanBuilder().createObject(type, jsonValue);
        }
        catch (Exception e) {
            throw new IOException("Can't read from input stream " + e);
        }
    }

    public long getSize(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Object.class.isAssignableFrom(type);
    }

    public void writeTo(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        try {
            JsonValue jv = new JsonGeneratorImpl().createJsonObject(t);
            JsonWriterImpl jsonWriter = new JsonWriterImpl(entityStream);
            jv.writeTo((JsonWriter)jsonWriter);
            jsonWriter.flush();
        }
        catch (JsonException e) {
            throw new IOException("Can't write to output stream " + (Object)((Object)e));
        }
    }
}

