/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.defaults.AssignabilityRegistrationException;
import org.picocontainer.defaults.DecoratingComponentAdapter;
import org.picocontainer.defaults.NotConcreteRegistrationException;
import org.picocontainer.defaults.PicoInvocationTargetInitializationException;
import org.picocontainer.defaults.SetterIntrospector;

public class BeanPropertyComponentAdapter
extends DecoratingComponentAdapter {
    private Map properties;
    private transient Map setters = null;

    public BeanPropertyComponentAdapter(ComponentAdapter delegate) throws PicoInitializationException {
        super(delegate);
    }

    public Object getComponentInstance(PicoContainer container) throws PicoInitializationException, PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        Object componentInstance = super.getComponentInstance(container);
        if (this.setters == null) {
            this.setters = new SetterIntrospector().getSetters(this.getComponentImplementation());
        }
        if (this.properties != null) {
            Set propertyNames = this.properties.keySet();
            Iterator iterator = propertyNames.iterator();
            while (iterator.hasNext()) {
                String propertyName = (String)iterator.next();
                String propertyValue = (String)this.properties.get(propertyName);
                Method setter = (Method)this.setters.get(propertyName);
                Object value = null;
                try {
                    value = this.convertType(container, setter, propertyValue);
                }
                catch (ClassNotFoundException e) {
                    throw new PicoInvocationTargetInitializationException(e);
                }
                try {
                    setter.invoke(componentInstance, value);
                }
                catch (Exception e) {
                    throw new PicoInitializationException("Failed to set property " + propertyName + " to " + propertyValue + ": " + e.getMessage(), e);
                }
            }
        }
        return componentInstance;
    }

    private Object convertType(PicoContainer container, Method setter, String propertyValue) throws ClassNotFoundException {
        Object component;
        if (propertyValue == null) {
            return null;
        }
        Class<?> type = setter.getParameterTypes()[0];
        String typeName = type.getName();
        Object result = BeanPropertyComponentAdapter.convert(typeName, propertyValue, Thread.currentThread().getContextClassLoader());
        if (result == null && container != null && (component = container.getComponentInstance(propertyValue)) != null && type.isAssignableFrom(component.getClass())) {
            return component;
        }
        return result;
    }

    public static Object convert(String typeName, String value, ClassLoader classLoader) throws ClassNotFoundException {
        if (typeName.equals(Boolean.class.getName()) || typeName.equals(Boolean.TYPE.getName())) {
            return Boolean.valueOf(value);
        }
        if (typeName.equals(Byte.class.getName()) || typeName.equals(Byte.TYPE.getName())) {
            return Byte.valueOf(value);
        }
        if (typeName.equals(Short.class.getName()) || typeName.equals(Short.TYPE.getName())) {
            return Short.valueOf(value);
        }
        if (typeName.equals(Integer.class.getName()) || typeName.equals(Integer.TYPE.getName())) {
            return Integer.valueOf(value);
        }
        if (typeName.equals(Long.class.getName()) || typeName.equals(Long.TYPE.getName())) {
            return Long.valueOf(value);
        }
        if (typeName.equals(Float.class.getName()) || typeName.equals(Float.TYPE.getName())) {
            return Float.valueOf(value);
        }
        if (typeName.equals(Double.class.getName()) || typeName.equals(Double.TYPE.getName())) {
            return Double.valueOf(value);
        }
        if (typeName.equals(Character.class.getName()) || typeName.equals(Character.TYPE.getName())) {
            return new Character(value.toCharArray()[0]);
        }
        if (typeName.equals(String.class.getName()) || typeName.equals("string")) {
            return value;
        }
        if (typeName.equals(File.class.getName()) || typeName.equals("file")) {
            return new File(value);
        }
        if (typeName.equals(URL.class.getName()) || typeName.equals("url")) {
            try {
                return new URL(value);
            }
            catch (MalformedURLException e) {
                throw new PicoInitializationException(e);
            }
        }
        if (typeName.equals(Class.class.getName()) || typeName.equals("class")) {
            return classLoader.loadClass(value);
        }
        return null;
    }

    public void setProperties(Map properties) {
        this.properties = properties;
    }
}

