/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.jmx;

import java.lang.reflect.Method;
import java.util.List;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.component.ComponentLifecycle;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.Component;
import org.exoplatform.container.xml.ComponentPlugin;
import org.exoplatform.container.xml.ExternalComponentPlugins;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.AbstractComponentAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MX4JComponentAdapter
extends AbstractComponentAdapter {
    private static final long serialVersionUID = -9001193588034229411L;
    private volatile Object instance_;
    private Log log = ExoLogger.getLogger((String)"exo.kernel.container.MX4JComponentAdapter");

    public MX4JComponentAdapter(Object key, Class implementation) {
        super(key, implementation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getComponentInstance(PicoContainer container) {
        if (this.instance_ != null) {
            return this.instance_;
        }
        ExoContainer exocontainer = (ExoContainer)container;
        Component component = null;
        try {
            ExternalComponentPlugins ecplugins;
            ConfigurationManager manager;
            String componentKey;
            InitParams params = null;
            boolean debug = false;
            MX4JComponentAdapter mX4JComponentAdapter = this;
            synchronized (mX4JComponentAdapter) {
                if (this.instance_ != null) {
                    return this.instance_;
                }
                Object key = this.getComponentKey();
                componentKey = key instanceof String ? (String)key : ((Class)key).getName();
                manager = (ConfigurationManager)exocontainer.getComponentInstanceOfType(ConfigurationManager.class);
                component = manager.getComponent(componentKey);
                if (component != null) {
                    params = component.getInitParams();
                    debug = component.getShowDeployInfo();
                }
                this.instance_ = exocontainer.createComponent(this.getComponentImplementation(), params);
            }
            if (debug) {
                this.log.debug((Object)("==> create  component : " + this.instance_));
            }
            if (component != null && component.getComponentPlugins() != null) {
                this.addComponentPlugin(debug, this.instance_, component.getComponentPlugins(), exocontainer);
            }
            if ((ecplugins = manager.getConfiguration().getExternalComponentPlugins(componentKey)) != null) {
                this.addComponentPlugin(debug, this.instance_, ecplugins.getComponentPlugins(), exocontainer);
            }
            if (this.instance_ instanceof ComponentLifecycle) {
                ComponentLifecycle lc = (ComponentLifecycle)this.instance_;
                lc.initComponent(exocontainer);
            }
        }
        catch (Exception ex) {
            String msg = "Cannot instantiate component " + this.getComponentImplementation();
            if (component != null) {
                msg = "Cannot instantiate component key=" + component.getKey() + " type=" + component.getType() + " found at " + component.getDocumentURL();
            }
            throw new RuntimeException(msg, ex);
        }
        return this.instance_;
    }

    private void addComponentPlugin(boolean debug, Object component, List<ComponentPlugin> plugins, ExoContainer container) throws Exception {
        if (plugins == null) {
            return;
        }
        for (ComponentPlugin plugin : plugins) {
            try {
                Class<?> clazz = Class.forName(plugin.getType());
                org.exoplatform.container.component.ComponentPlugin cplugin = (org.exoplatform.container.component.ComponentPlugin)container.createComponent(clazz, plugin.getInitParams());
                cplugin.setName(plugin.getName());
                cplugin.setDescription(plugin.getDescription());
                clazz = component.getClass();
                Method m = this.getSetMethod(clazz, plugin.getSetMethod());
                Object[] params = new Object[]{cplugin};
                m.invoke(component, params);
                if (debug) {
                    this.log.debug((Object)("==> add component plugin: " + cplugin));
                }
                cplugin.setName(plugin.getName());
                cplugin.setDescription(plugin.getDescription());
            }
            catch (Exception ex) {
                this.log.error((Object)("Failed to instanciate plugin " + plugin.getName() + "for component " + component + ": " + ex.getMessage()), (Throwable)ex);
            }
        }
    }

    private Method getSetMethod(Class clazz, String name) {
        Method[] methods;
        for (Method m : methods = clazz.getMethods()) {
            Class<?>[] types;
            if (!name.equals(m.getName()) || (types = m.getParameterTypes()) == null || types.length != 1 || !org.exoplatform.container.component.ComponentPlugin.class.isAssignableFrom(types[0])) continue;
            return m;
        }
        return null;
    }

    public void verify(PicoContainer container) {
    }
}

