/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.txoj;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
import com.arjuna.ats.arjuna.coordinator.BasicAction;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.txoj.LockManager;
import com.arjuna.ats.txoj.logging.txojLogger;
import java.io.PrintWriter;
import java.io.StringWriter;

class LockRecord
extends AbstractRecord {
    protected BasicAction actionHandle;
    private LockManager managerAddress;
    private boolean readOnly;
    private String managerType;

    public LockRecord(LockManager lm, BasicAction currAct) {
        super(lm.get_uid(), lm.type(), 1);
        this.actionHandle = currAct;
        this.managerAddress = lm;
        this.readOnly = false;
        this.managerType = lm.type();
    }

    public LockRecord(LockManager lm, boolean rdOnly, BasicAction currAct) {
        super(lm.get_uid(), lm.type(), 1);
        if (txojLogger.aitLogger.isDebugEnabled()) {
            txojLogger.aitLogger.debug(1L, 4L, 10L, "LockRecord::LockRecord(" + lm.get_uid() + ", " + (this.readOnly ? "PREPARE_READONLY" : "WRITEABLE") + ")");
        }
        this.actionHandle = currAct;
        this.managerAddress = lm;
        this.readOnly = rdOnly;
        this.managerType = lm.type();
    }

    public int typeIs() {
        return 121;
    }

    public Object value() {
        return this.managerAddress;
    }

    public void setValue(Object o) {
        if (txojLogger.aitLoggerI18N.isWarnEnabled()) {
            txojLogger.aitLoggerI18N.warn("com.arjuna.ats.txoj.LockRecord_1");
        }
    }

    public int nestedAbort() {
        if (txojLogger.aitLogger.isDebugEnabled()) {
            txojLogger.aitLogger.debug(16L, 4L, 10L, "LockRecord::nestedAbort() for " + this.order());
        }
        if (this.managerAddress == null) {
            return 8;
        }
        if (this.actionHandle != null) {
            Uid toRelease = this.actionHandle.get_uid();
            this.actionHandle = this.actionHandle.parent();
            if (!this.managerAddress.releaseAll(toRelease)) {
                if (txojLogger.aitLoggerI18N.isWarnEnabled()) {
                    txojLogger.aitLoggerI18N.warn("com.arjuna.ats.txoj.LockRecord_2", new Object[]{toRelease});
                }
                return 8;
            }
        } else if (txojLogger.aitLoggerI18N.isWarnEnabled()) {
            txojLogger.aitLoggerI18N.warn("com.arjuna.ats.txoj.LockRecord_3");
        }
        return 7;
    }

    public int nestedCommit() {
        if (txojLogger.aitLogger.isDebugEnabled()) {
            txojLogger.aitLogger.debug(16L, 4L, 10L, "LockRecord::nestedCommit() for " + this.order());
        }
        if (this.managerAddress == null) {
            return 8;
        }
        if (this.actionHandle != null) {
            Uid toRelease = this.actionHandle.get_uid();
            this.actionHandle = this.actionHandle.parent();
            return this.managerAddress.propagate(toRelease, this.actionHandle.get_uid()) ? 7 : 8;
        }
        if (txojLogger.aitLoggerI18N.isWarnEnabled()) {
            txojLogger.aitLoggerI18N.warn("com.arjuna.ats.txoj.LockRecord_4");
        }
        return 8;
    }

    public int nestedPrepare() {
        if (txojLogger.aitLogger.isDebugEnabled()) {
            txojLogger.aitLogger.debug(16L, 4L, 10L, "LockRecord::nestedPrepare() for " + this.order());
        }
        return 0;
    }

    public int topLevelAbort() {
        if (txojLogger.aitLogger.isDebugEnabled()) {
            txojLogger.aitLogger.debug(16L, 4L, 10L, "LockRecord::topLevelAbort() for " + this.order());
        }
        return this.nestedAbort();
    }

    public int topLevelCommit() {
        if (txojLogger.aitLogger.isDebugEnabled()) {
            txojLogger.aitLogger.debug(16L, 4L, 10L, "LockRecord::topLevelCommit() for " + this.order());
        }
        if (this.managerAddress == null) {
            return 8;
        }
        if (this.actionHandle != null) {
            if (!this.managerAddress.releaseAll(this.actionHandle.get_uid())) {
                if (txojLogger.aitLoggerI18N.isWarnEnabled()) {
                    txojLogger.aitLoggerI18N.warn("com.arjuna.ats.txoj.LockRecord_5", new Object[]{this.actionHandle.get_uid()});
                }
                return 8;
            }
        } else {
            if (txojLogger.aitLoggerI18N.isWarnEnabled()) {
                txojLogger.aitLoggerI18N.warn("com.arjuna.ats.txoj.LockRecord_6");
            }
            return 8;
        }
        return 7;
    }

    public int topLevelPrepare() {
        if (txojLogger.aitLogger.isDebugEnabled()) {
            txojLogger.aitLogger.debug(16L, 4L, 10L, "LockRecord::topLevelPrepare() for " + this.order());
        }
        if (this.readOnly) {
            if (this.topLevelCommit() == 7) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public String toString() {
        StringWriter strm = new StringWriter();
        this.print(new PrintWriter(strm));
        return strm.toString();
    }

    public void print(PrintWriter strm) {
        super.print(strm);
        strm.println("LockRecord");
    }

    public boolean restore_state(InputObjectState o, int t) {
        if (txojLogger.aitLoggerI18N.isWarnEnabled()) {
            txojLogger.aitLoggerI18N.warn("com.arjuna.ats.txoj.LockRecord_7", new Object[]{this.type(), this.order()});
        }
        return false;
    }

    public boolean save_state(OutputObjectState o, int t) {
        return true;
    }

    public String type() {
        return "/StateManager/AbstractRecord/LockRecord";
    }

    public final boolean isReadOnly() {
        return this.readOnly;
    }

    public final String lockType() {
        return this.managerType;
    }

    public void merge(AbstractRecord a) {
    }

    public void alter(AbstractRecord a) {
    }

    public boolean shouldAdd(AbstractRecord a) {
        return false;
    }

    public boolean shouldAlter(AbstractRecord a) {
        return false;
    }

    public boolean shouldMerge(AbstractRecord a) {
        return false;
    }

    public boolean shouldReplace(AbstractRecord ar) {
        return this.order().equals(ar.order()) && this.typeIs() == ar.typeIs() && ((LockRecord)ar).isReadOnly() && !this.readOnly;
    }

    protected LockRecord() {
        if (txojLogger.aitLogger.isDebugEnabled()) {
            txojLogger.aitLogger.debug(1L, 2L, 10L, "LockRecord::LockRecord()");
        }
        this.actionHandle = null;
        this.managerAddress = null;
        this.readOnly = false;
        this.managerType = null;
    }
}

