/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.form.validator;

import org.exoplatform.commons.serialization.api.annotations.Serialized;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.exception.MessageException;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.validator.Validator;

@Serialized
public class ResourceValidator
implements Validator {
    public void validate(UIFormInput uiInput) throws Exception {
        String label;
        if (uiInput == null || ((String)uiInput.getValue()).trim().length() == 0) {
            return;
        }
        UIComponent uiComponent = (UIComponent)((Object)uiInput);
        UIForm uiForm = uiComponent.getAncestorOfType(UIForm.class);
        try {
            label = uiForm.getId() + ".label." + uiInput.getName();
        }
        catch (Exception e) {
            label = uiInput.getName();
        }
        String s = (String)uiInput.getValue();
        if (Character.isDigit(s.charAt(0)) || s.charAt(0) == '-' || s.charAt(0) == '.' || s.charAt(0) == '_') {
            Object[] args = new Object[]{label, uiInput.getBindingField()};
            throw new MessageException(new ApplicationMessage("FirstCharacterNameValidator.msg", args, 1));
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isLetter(c) || Character.isDigit(c) || c == '_' || c == '-' || c == '.') continue;
            Object[] args = new Object[]{label};
            throw new MessageException(new ApplicationMessage("ResourceValidator.msg.Invalid-char", args, 1));
        }
    }
}

