/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.server.tomcat;

import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TomcatLauncher {
    private Object tomcatInstance_;

    public TomcatLauncher(String javaHome, String tomcatHome, String sysPropertiesText) throws Exception {
        Map<String, String> sysProps = this.parseProperties(sysPropertiesText);
        System.setProperty("catalina.base", tomcatHome);
        System.setProperty("catalina.home", tomcatHome);
        System.setProperty("java.io.tmpdir", tomcatHome + "/temp");
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.SimpleLog");
        System.setProperty("java.security.auth.login.config", tomcatHome + "/conf/jaas.conf");
        URL[] sysClasspath = new URL[]{new URL("file:" + javaHome + "/lib/tools.jar"), new URL("file:" + tomcatHome + "/bin/commons-logging-api.jar")};
        this.addSystemClasspath(sysClasspath);
        URL[] tomcatClasspath = new URL[]{new URL("file:" + tomcatHome + "/bin/bootstrap.jar")};
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        URLClassLoader tomcatLoader = new URLClassLoader(tomcatClasspath, contextLoader);
        Thread.currentThread().setContextClassLoader(tomcatLoader);
        Class<?> bootstrap = tomcatLoader.loadClass("org.apache.catalina.startup.Bootstrap");
        this.tomcatInstance_ = bootstrap.newInstance();
        Thread.currentThread().setContextClassLoader(contextLoader);
    }

    public void init() throws Exception {
        Method method = this.tomcatInstance_.getClass().getDeclaredMethod("init", null);
        method.invoke(this.tomcatInstance_, (Object[])null);
    }

    public void start() throws Exception {
        Method method = this.tomcatInstance_.getClass().getDeclaredMethod("start", null);
        method.invoke(this.tomcatInstance_, (Object[])null);
    }

    public void stop() throws Exception {
        Method method = this.tomcatInstance_.getClass().getDeclaredMethod("stop", null);
        method.invoke(this.tomcatInstance_, (Object[])null);
    }

    private Map<String, String> parseProperties(String text) throws Exception {
        String[] lines;
        HashMap<String, String> properties = new HashMap<String, String>();
        for (String line : lines = text.split("\n")) {
            String[] token = line.trim().split("=");
            if (token.length != 2) {
                throw new Exception("Incorrect properties format \n" + text);
            }
            properties.put(token[0].trim(), token[1].trim());
        }
        return properties;
    }

    private void addSystemClasspath(URL[] url) throws Exception {
        ClassLoader sysClassLoader = ClassLoader.getSystemClassLoader();
        Class[] argTypes = new Class[]{URL.class};
        Method method = URLClassLoader.class.getDeclaredMethod("addURL", argTypes);
        method.setAccessible(true);
        for (int i = 0; i < url.length; ++i) {
            Object[] args = new Object[]{url[i]};
            method.invoke((Object)sysClassLoader, args);
        }
    }
}

