/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.activity.model;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.shindig.social.opensocial.model.MediaItem;
import org.exoplatform.social.core.activity.model.Stream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Activity {
    public static final String IS_COMMENT = "IS_COMMENT";
    private String body = null;
    private String bodyId = null;
    private String externalId = null;
    private String id = null;
    private Long updatedTimestamp = null;
    private List<MediaItem> mediaItems = null;
    private Long postedTime = null;
    private Integer priority = null;
    private Stream stream = null;
    private Map<String, String> templateParams = null;
    private String title = null;
    private String titleId = null;
    private String url = null;
    private String userId = null;
    private String type = null;
    private String replyToId = null;
    private boolean hidden = false;
    private String[] likeIdentityIds = null;

    public Activity(String userId, String type, String title, String body) {
        this.userId = userId;
        this.type = type;
        this.title = title;
        this.body = body;
    }

    public Activity() {
        this.setUpdated(new Date());
        this.setPostedTime(new Date().getTime());
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Long getUpdatedTimestamp() {
        return this.updatedTimestamp;
    }

    public void setUpdatedTimestamp(Long timestamp) {
        this.updatedTimestamp = timestamp;
    }

    public List<MediaItem> getMediaItems() {
        return this.mediaItems;
    }

    public void setMediaItems(List<MediaItem> mediaItems) {
        this.mediaItems = mediaItems;
    }

    public Long getPostedTime() {
        return this.postedTime;
    }

    public void setPostedTime(Long postedTime) {
        this.postedTime = postedTime;
    }

    public Float getPriority() {
        if (this.priority == null) {
            return null;
        }
        return Float.valueOf(this.priority > 0 ? (float)this.priority.intValue() / 100.0f : 0.0f);
    }

    public Integer getIntPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        if (priority == null) {
            this.priority = null;
            return;
        }
        if (priority < 0 || priority > 100) {
            throw new IllegalArgumentException("the priority should be between 0 and 100");
        }
        this.priority = priority;
    }

    public void setPriority(Float priority) {
        if (priority == null) {
            this.priority = null;
            return;
        }
        if (priority.floatValue() > 0.0f) {
            this.setPriority(new Float(priority.floatValue() * 100.0f).intValue());
        } else {
            this.setPriority(0);
        }
    }

    public Stream getStream() {
        if (this.stream == null) {
            this.stream = new Stream();
        }
        return this.stream;
    }

    public void setStream(Stream stream) {
        this.stream = stream;
    }

    public Map<String, String> getTemplateParams() {
        return this.templateParams;
    }

    public void setTemplateParams(Map<String, String> templateParams) {
        this.templateParams = templateParams;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getReplyToId() {
        return this.replyToId;
    }

    public void setReplyToId(String replyToId) {
        this.replyToId = replyToId;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public void setLikeIdentityIds(String[] likeIdentityIds) {
        this.likeIdentityIds = likeIdentityIds;
    }

    public String[] getLikeIdentityIds() {
        return this.likeIdentityIds;
    }

    public String getBodyId() {
        return this.bodyId;
    }

    public void setBodyId(String bodyId) {
        this.bodyId = bodyId;
    }

    public String getTitleId() {
        return this.titleId;
    }

    public void setTitleId(String titleId) {
        this.titleId = titleId;
    }

    public String getStreamUrl() {
        return this.getStream().getUrl();
    }

    public void setStreamUrl(String streamUrl) {
        this.getStream().setUrl(streamUrl);
    }

    public String getStreamSourceUrl() {
        return this.getStream().getSourceUrl();
    }

    public void setStreamSourceUrl(String streamSourceUrl) {
        this.getStream().setSourceUrl(streamSourceUrl);
    }

    public String getStreamTitle() {
        return this.getStream().getTitle();
    }

    public void setStreamTitle(String streamTitle) {
        this.getStream().setTitle(streamTitle);
    }

    public String getStreamFaviconUrl() {
        return this.getStream().getFaviconUrl();
    }

    public void setStreamFaviconUrl(String streamFaviconUrl) {
        this.getStream().setFaviconUrl(streamFaviconUrl);
    }

    public Date getUpdated() {
        return this.updatedTimestamp != null ? new Date(this.updatedTimestamp) : null;
    }

    public void setUpdated(Date updated) {
        this.updatedTimestamp = updated != null ? Long.valueOf(updated.getTime()) : null;
    }

    public String getAppId() {
        if (this.type != null && this.type.startsWith("opensocial:")) {
            return this.type.substring("opensocial:".length());
        }
        return null;
    }

    public void setAppId(String appId) {
        if (appId != null && !appId.startsWith("opensocial:")) {
            this.setType("opensocial:" + appId);
        }
    }

    public String getStreamId() {
        return this.getStream().getStreamId();
    }

    public void setStreamId(String streamId) {
        this.getStream().setStreamId(streamId);
    }

    public String getStreamOwner() {
        return this.getStream().getStreamOwner();
    }

    public void setStreamOwner(String streamOwner) {
        this.getStream().setStreamOwner(streamOwner);
    }
}

