/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui;

import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import nl.captcha.Captcha;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.exception.MessageException;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.validator.Validator;

public class CaptchaValidator
implements Validator,
Serializable {
    public void validate(UIFormInput uiInput) throws Exception {
        String label;
        PortalRequestContext prContext = Util.getPortalRequestContext();
        HttpServletRequest request = prContext.getRequest();
        HttpSession session = request.getSession();
        Captcha captcha = (Captcha)session.getAttribute("simpleCaptcha");
        if (captcha != null && captcha.isCorrect((String)uiInput.getValue())) {
            return;
        }
        UIComponent uiComponent = (UIComponent)uiInput;
        UIForm uiForm = (UIForm)uiComponent.getAncestorOfType(UIForm.class);
        try {
            label = uiForm.getLabel(uiInput.getName());
        }
        catch (Exception e) {
            label = uiInput.getName();
        }
        label = label.trim();
        if (label.charAt(label.length() - 1) == ':') {
            label = label.substring(0, label.length() - 1);
        }
        Object[] args = new Object[]{label, uiInput.getBindingField()};
        throw new MessageException(new ApplicationMessage("CaptchaValidator.msg.Invalid-input", args, 1));
    }
}

