/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Value;
import org.exoplatform.forum.service.Post;
import org.exoplatform.services.organization.User;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static final String TYPE_CATEGORY = "exo:forumCategory".intern();
    public static final String TYPE_FORUM = "exo:forum".intern();
    public static final String TYPE_TOPIC = "exo:topic".intern();
    public static final String USER_PROFILES_TYPE = "exo:forumUserProfile".intern();
    public static final String FORUM_SERVICE = "ForumService".intern();
    public static final String USER_PROFILES = "UserProfile".intern();
    public static final String FORUM_SUBSCRIOTION = "forumSubscription".intern();
    public static final String NT_UNSTRUCTURED = "nt:unstructured".intern();
    public static final String FORUMADMINISTRATION = "forumAdministration".intern();
    public static final String USER_PROFILE_DELETED = "userProfileDeleted".intern();
    public static final String CATEGORY = "forumCategory".intern();
    public static final String FORUM = "forum".intern();
    public static final String TOPIC = "topic".intern();
    public static final String POST = "post".intern();
    public static final String POLL = "poll".intern();
    public static final String TAG = "tag".intern();
    public static final String TOPICTYPE = "topicType".intern();
    public static final String PRUNESETTING = "pruneSetting".intern();
    public static final String RECEIVE_MESSAGE = "receive".intern();
    public static final String SEND_MESSAGE = "send".intern();
    public static final String ADMIN = "Administrator".intern();
    public static final String MODERATOR = "Moderator".intern();
    public static final String USER = "User".intern();
    public static final String GUEST = "Guest".intern();
    public static final String DELETED = "_deleted".intern();
    public static final String SPACE = " ".intern();
    public static final String ADMIN_ROLE = "ADMIN".intern();
    public static final String DEFAULT_EMAIL_CONTENT = "Hi ,</br> You have received this email because you registered for eXo Forum/Topic Watching notification.<br/>We would like to inform that $OBJECT_WATCH_TYPE <b>$OBJECT_NAME</b> has been added new $ADD_TYPE with content below: <div>_______________<br/>$POST_CONTENT<br/>_______________</div><div>At $TIME on $DATE, <b>$POSTER</b> posted</div> " + "For more detail, you can view at link : $LINK".intern();

    public static String removeCharterStrange(String s) {
        if (s == null || s.length() <= 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            if (s.codePointAt(i) <= 31) continue;
            builder.append(s.charAt(i));
        }
        return builder.toString();
    }

    public static boolean arraysHaveDifferentContent(String[] a, String[] b) {
        if (a.length == b.length) {
            List<Object> list = new ArrayList();
            list = Arrays.asList(b);
            for (int i = 0; i < a.length; ++i) {
                if (list.contains(a[i])) continue;
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    public static boolean listsHaveDifferentContent(List<String> a, List<String> b) {
        if (a.size() == b.size()) {
            for (String s : b) {
                if (a.contains(s)) continue;
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    public static String[] mapToArray(Map<String, String> map) {
        if (map.isEmpty()) {
            return new String[]{" "};
        }
        String[] strs = new String[map.size()];
        String str = map.toString().replace(" ", "").replace("{", "").replace("}", "");
        str = str.replace(",", ";").replace("=", ",");
        strs = str.split(";");
        return strs;
    }

    public static Map<String, String> arrayToMap(String[] strs) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < strs.length; ++i) {
            String[] arr = strs[i].split(",");
            if (arr.length != 2) continue;
            map.put(arr[0], arr[1]);
        }
        return map;
    }

    public static String propertyMatchAny(String property, List<String> list) {
        StringBuilder builder = new StringBuilder();
        if (!list.isEmpty()) {
            boolean t = false;
            for (String string : list) {
                if (!t) {
                    builder.append("(not(").append(property).append(") or ").append(property).append("='' or ").append(property).append("='").append(string).append("'");
                } else {
                    builder.append(" or ").append(property).append("='").append(string).append("'");
                }
                t = true;
            }
            if (t) {
                builder.append(")");
            }
        }
        return builder.toString();
    }

    public static boolean isListContentItemList(List<String> list, List<String> list1) {
        if (list1 == null || list1.size() == 1 && Utils.isEmpty(list1.get(0))) {
            return false;
        }
        for (String string : list1) {
            if (!list.contains(string)) continue;
            return true;
        }
        return false;
    }

    public static String[] getStringsInList(List<String> list) throws Exception {
        if (list.size() > 1) {
            while (list.contains(" ")) {
                list.remove(" ");
            }
        }
        return list.toArray(new String[list.size()]);
    }

    public static List<String> extractSameItems(List<String> pList, List<String> cList) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        for (String string : pList) {
            if (!cList.contains(string)) continue;
            list.add(string);
        }
        return list;
    }

    public static String[] valuesToArray(Value[] Val) throws Exception {
        if (Val.length < 1) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < Val.length; ++i) {
            String s = Val[i].getString();
            if (Utils.isEmpty(s)) continue;
            list.add(s);
        }
        return list.toArray(new String[list.size()]);
    }

    public static List<String> valuesToList(Value[] values) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        if (values.length < 1) {
            return list;
        }
        for (int i = 0; i < values.length; ++i) {
            String s = values[i].getString();
            if (Utils.isEmpty(s)) continue;
            list.add(s);
        }
        return list;
    }

    public static <T> T[] arrayCopy(T[] source) {
        if (source == null) {
            return null;
        }
        if (source.length == 0) {
            try {
                return (Object[])Array.newInstance(source.getClass().getComponentType(), 0);
            }
            catch (Exception e) {
                return null;
            }
        }
        Object[] dest = (Object[])Array.newInstance(source[0].getClass(), source.length);
        System.arraycopy(source, 0, dest, 0, source.length);
        return dest;
    }

    public static boolean isEmpty(String s) {
        return s == null || s.trim().length() <= 0;
    }

    public static StringBuilder getPathQuery(String isApproved, String isHidden, String userLogin) throws Exception {
        StringBuilder strBuilder = new StringBuilder();
        boolean isAnd = false;
        if (userLogin != null && userLogin.length() > 0) {
            isAnd = true;
            strBuilder.append("[((@exo:userPrivate='").append(userLogin).append("') or (@exo:userPrivate='exoUserPri'))");
        }
        if (isApproved != null && isApproved.length() > 0) {
            if (isAnd) {
                strBuilder.append(" and (@exo:isApproved='").append(isApproved).append("')");
            } else {
                strBuilder.append("[(@exo:isApproved='").append(isApproved).append("')");
            }
            if (isHidden.equals("false")) {
                strBuilder.append(" and (@exo:isHidden='false')");
            }
            strBuilder.append("]");
        } else if (!Utils.isEmpty(isHidden)) {
            if (isAnd) {
                strBuilder.append(" and (@exo:isHidden='" + isHidden + "')]");
            } else {
                strBuilder.append("[@exo:isHidden='" + isHidden + "']");
            }
        } else if (isAnd) {
            strBuilder.append("]");
        }
        return strBuilder;
    }

    public static boolean hasPermission(List<String> listOfCanviewrs, List<String> listOfBoundUsers) {
        if (listOfBoundUsers == null || listOfCanviewrs == null) {
            return false;
        }
        ArrayList<String> tem = new ArrayList<String>();
        for (String str : listOfCanviewrs) {
            if (str == null) continue;
            if (listOfBoundUsers.contains(str)) {
                return true;
            }
            if (!str.contains("*")) continue;
            str = str.substring(str.indexOf("/"), str.length());
            tem.add(str);
            if (!listOfBoundUsers.contains(str)) continue;
            return true;
        }
        for (String s : listOfBoundUsers) {
            if (!tem.contains(s)) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DatetimeComparatorPostDESC
    implements Comparator<Post> {
        @Override
        public int compare(Post o1, Post o2) throws ClassCastException {
            Date date1 = o2.getCreatedDate();
            Date date2 = o1.getCreatedDate();
            return date2.compareTo(date1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DatetimeComparatorDESC
    implements Comparator<Object> {
        @Override
        public int compare(Object o1, Object o2) throws ClassCastException {
            Date date1 = ((User)o1).getCreatedDate();
            Date date2 = ((User)o2).getCreatedDate();
            return date2.compareTo(date1);
        }
    }
}

