/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.HitQueue;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.util.PriorityQueue;

public class TopDocCollector
extends HitCollector {
    private ScoreDoc reusableSD;
    protected int totalHits;
    protected PriorityQueue hq;

    public TopDocCollector(int numHits) {
        this(new HitQueue(numHits));
    }

    TopDocCollector(int numHits, PriorityQueue hq) {
        this.hq = hq;
    }

    protected TopDocCollector(PriorityQueue hq) {
        this.hq = hq;
    }

    public void collect(int doc, float score) {
        if (score > 0.0f) {
            ++this.totalHits;
            if (this.reusableSD == null) {
                this.reusableSD = new ScoreDoc(doc, score);
            } else if (score >= this.reusableSD.score) {
                this.reusableSD.doc = doc;
                this.reusableSD.score = score;
            } else {
                return;
            }
            this.reusableSD = (ScoreDoc)this.hq.insertWithOverflow(this.reusableSD);
        }
    }

    public int getTotalHits() {
        return this.totalHits;
    }

    public TopDocs topDocs() {
        ScoreDoc[] scoreDocs = new ScoreDoc[this.hq.size()];
        for (int i = this.hq.size() - 1; i >= 0; --i) {
            scoreDocs[i] = (ScoreDoc)this.hq.pop();
        }
        float maxScore = this.totalHits == 0 ? Float.NEGATIVE_INFINITY : scoreDocs[0].score;
        return new TopDocs(this.totalHits, scoreDocs, maxScore);
    }
}

