/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.ArrayList;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.ChannelException;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenTest
extends ReceiverAdapter {
    JChannel ch;
    Address next;
    Address local_addr;
    final List<Address> members = new ArrayList<Address>(10);
    int num_tokens = 0;
    long last_token_timestamp;
    long sleep_time = 0L;
    boolean token_sent = false;
    private final Recovery recovery = new Recovery();

    private void start(String[] args) throws ChannelException {
        String props = "udp.xml";
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-props")) {
                props = args[++i];
                continue;
            }
            if (args[i].equals("-sleep")) {
                this.sleep_time = Long.valueOf(args[++i]);
                continue;
            }
            System.out.println("TokenTest [-props <props>] [-sleep <sleep time between token sends>]");
            return;
        }
        this.ch = new JChannel(props);
        this.ch.setReceiver(this);
        this.ch.connect("token-group");
        this.local_addr = this.ch.getLocalAddress();
        this.next = TokenTest.determineNext(this.members, this.local_addr);
        if (this.isCoord() && !this.token_sent) {
            this.ch.send(this.next, null, null);
            this.token_sent = true;
        }
        this.recovery.start();
    }

    @Override
    public void receive(Message msg) {
        ++this.num_tokens;
        if (this.last_token_timestamp == 0L) {
            this.last_token_timestamp = System.currentTimeMillis();
        } else if (this.num_tokens % 1000 == 0) {
            long diff = System.currentTimeMillis() - this.last_token_timestamp;
            System.out.println("round trip time=" + diff + " ms");
        }
        try {
            if (this.sleep_time > 0L) {
                Util.sleep(this.sleep_time);
            }
            while (!this.ch.isConnected()) {
                Util.sleep(10L);
            }
            this.last_token_timestamp = System.currentTimeMillis();
            this.ch.send(this.next, null, null);
            System.out.print(this.num_tokens + "\r");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void viewAccepted(View new_view) {
        System.out.println("view: " + new_view);
        this.members.clear();
        this.members.addAll(new_view.getMembers());
        this.next = TokenTest.determineNext(this.members, this.local_addr);
        if (this.local_addr != null && this.isCoord() && !this.token_sent) {
            try {
                this.ch.send(this.next, null, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.token_sent = true;
        }
    }

    private boolean isCoord() {
        return this.members.get(0).equals(this.local_addr);
    }

    private static Address determineNext(List<Address> members, Address local_addr) {
        Address retval;
        int index = members.indexOf(local_addr);
        if ((retval = members.get(++index % members.size())) == null) {
            retval = local_addr;
        }
        return retval;
    }

    public static void main(String[] args) throws ChannelException {
        new TokenTest().start(args);
    }

    private class Recovery
    implements Runnable {
        private Recovery() {
        }

        void start() {
            new Thread(this).start();
        }

        public void run() {
            while (true) {
                Util.sleep(5000L);
                if (TokenTest.this.last_token_timestamp <= 0L || System.currentTimeMillis() - TokenTest.this.last_token_timestamp <= 5000L || TokenTest.this.local_addr == null || !TokenTest.this.isCoord()) continue;
                try {
                    System.out.println("*** recovering token");
                    TokenTest.this.ch.send(TokenTest.this.next, null, null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                TokenTest.this.token_sent = true;
            }
        }
    }
}

