/*
 * Decompiled with CFR 0.152.
 */
package org.jcrom;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.nodetype.NodeType;
import javax.jcr.version.Version;
import org.jcrom.JcrDataProvider;
import org.jcrom.JcrDataProviderImpl;
import org.jcrom.JcrFile;
import org.jcrom.JcrMappingException;
import org.jcrom.annotations.JcrBaseVersionCreated;
import org.jcrom.annotations.JcrBaseVersionName;
import org.jcrom.annotations.JcrCheckedout;
import org.jcrom.annotations.JcrChildNode;
import org.jcrom.annotations.JcrCreated;
import org.jcrom.annotations.JcrFileNode;
import org.jcrom.annotations.JcrName;
import org.jcrom.annotations.JcrNode;
import org.jcrom.annotations.JcrParentNode;
import org.jcrom.annotations.JcrPath;
import org.jcrom.annotations.JcrProperty;
import org.jcrom.annotations.JcrReference;
import org.jcrom.annotations.JcrSerializedProperty;
import org.jcrom.annotations.JcrUUID;
import org.jcrom.annotations.JcrVersionCreated;
import org.jcrom.annotations.JcrVersionName;
import org.jcrom.util.NameFilter;
import org.jcrom.util.PathUtils;
import org.jcrom.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Mapper {
    private static final String DEFAULT_FIELDNAME = "fieldName";
    private final CopyOnWriteArraySet<Class> mappedClasses = new CopyOnWriteArraySet();
    private final boolean cleanNames;
    private final boolean dynamicInstantiation;

    Mapper(boolean cleanNames, boolean dynamicInstantiation) {
        this.cleanNames = cleanNames;
        this.dynamicInstantiation = dynamicInstantiation;
    }

    boolean isMapped(Class c) {
        return this.mappedClasses.contains(c);
    }

    void addMappedClass(Class c) {
        this.mappedClasses.add(c);
    }

    CopyOnWriteArraySet<Class> getMappedClasses() {
        return this.mappedClasses;
    }

    boolean isCleanNames() {
        return this.cleanNames;
    }

    boolean isDynamicInstantiation() {
        return this.dynamicInstantiation;
    }

    private String getCleanName(String name) {
        if (this.cleanNames) {
            return PathUtils.createValidName(name);
        }
        return name;
    }

    private Field findAnnotatedField(Object obj, Class annotationClass) {
        for (Field field : ReflectionUtils.getDeclaredAndInheritedFields(obj.getClass())) {
            if (!field.isAnnotationPresent(annotationClass)) continue;
            field.setAccessible(true);
            return field;
        }
        return null;
    }

    private Field findPathField(Object obj) {
        return this.findAnnotatedField(obj, JcrPath.class);
    }

    private Field findNameField(Object obj) {
        return this.findAnnotatedField(obj, JcrName.class);
    }

    private Field findUUIDField(Object obj) {
        return this.findAnnotatedField(obj, JcrUUID.class);
    }

    String getNodeName(Object object) throws Exception {
        return (String)this.findNameField(object).get(object);
    }

    String getNodePath(Object object) throws Exception {
        return (String)this.findPathField(object).get(object);
    }

    String getNodeUUID(Object object) throws Exception {
        return (String)this.findUUIDField(object).get(object);
    }

    void setBaseVersionInfo(Object object, String name, Calendar created) throws Exception {
        Field baseCreated;
        Field baseName = this.findAnnotatedField(object, JcrBaseVersionName.class);
        if (baseName != null) {
            baseName.set(object, name);
        }
        if ((baseCreated = this.findAnnotatedField(object, JcrBaseVersionCreated.class)) != null) {
            if (baseCreated.getType() == Date.class) {
                baseCreated.set(object, created.getTime());
            } else if (baseCreated.getType() == Timestamp.class) {
                baseCreated.set(object, new Timestamp(created.getTimeInMillis()));
            } else if (baseCreated.getType() == Calendar.class) {
                baseCreated.set(object, created);
            }
        }
    }

    private void setNodeName(Object object, String name) throws Exception {
        this.findNameField(object).set(object, name);
    }

    private void setNodePath(Object object, String path) throws Exception {
        this.findPathField(object).set(object, path);
    }

    private void setUUID(Object object, String uuid) throws Exception {
        Field uuidField = this.findUUIDField(object);
        if (uuidField != null) {
            uuidField.set(object, uuid);
        }
    }

    private Object createInstanceForNode(Class objClass, Node node) throws Exception {
        if (this.dynamicInstantiation) {
            String classNameProperty = "className";
            JcrNode jcrNode = this.getJcrNodeAnnotation(objClass);
            if (jcrNode != null && !jcrNode.classNameProperty().equals("none")) {
                classNameProperty = jcrNode.classNameProperty();
            }
            if (node.hasProperty(classNameProperty)) {
                String className = node.getProperty(classNameProperty).getString();
                Class<?> c = Class.forName(className);
                if (this.isMapped(c)) {
                    return c.newInstance();
                }
                throw new JcrMappingException("Trying to instantiate unmapped class: " + c.getName());
            }
            return objClass.newInstance();
        }
        return objClass.newInstance();
    }

    Object fromNode(Class entityClass, Node node, String childNodeFilter, int maxDepth) throws Exception {
        Object obj = this.createInstanceForNode(entityClass, node);
        this.mapNodeToClass(obj, node, new NameFilter(childNodeFilter), maxDepth, null, 0);
        return obj;
    }

    String updateNode(Node node, Object entity, String childNodeFilter, int maxDepth) throws Exception {
        return this.updateNode(node, entity, entity.getClass(), new NameFilter(childNodeFilter), maxDepth, 0);
    }

    private Object findEntityByName(List entities, String name) throws Exception {
        for (int i = 0; i < entities.size(); ++i) {
            Object entity = entities.get(i);
            if (!this.getCleanName(this.getNodeName(entity)).equals(name)) continue;
            return entity;
        }
        return null;
    }

    private String updateNode(Node node, Object obj, Class objClass, NameFilter childNameFilter, int maxDepth, int depth) throws Exception {
        JcrNode jcrNode;
        if (!node.getName().equals(this.getCleanName(this.getNodeName(obj)))) {
            node.getSession().move(node.getPath(), node.getParent().getPath() + "/" + this.getCleanName(this.getNodeName(obj)));
            this.setNodeName(obj, node.getName());
            this.setNodePath(obj, node.getPath());
        }
        if ((jcrNode = this.getJcrNodeAnnotation(objClass)) != null && !jcrNode.classNameProperty().equals("none")) {
            node.setProperty(jcrNode.classNameProperty(), obj.getClass().getCanonicalName());
        }
        for (Field field : ReflectionUtils.getDeclaredAndInheritedFields(objClass)) {
            Object child;
            Object childEntity;
            NodeIterator childNodes;
            Node childContainer;
            List children;
            String name;
            field.setAccessible(true);
            if (field.isAnnotationPresent(JcrProperty.class)) {
                this.mapFieldToProperty(field, obj, node);
                continue;
            }
            if (field.isAnnotationPresent(JcrSerializedProperty.class)) {
                this.mapSerializedFieldToProperty(field, obj, node);
                continue;
            }
            if (field.isAnnotationPresent(JcrChildNode.class) && (maxDepth < 0 || depth < maxDepth)) {
                JcrChildNode jcrChildNode = field.getAnnotation(JcrChildNode.class);
                name = field.getName();
                if (!jcrChildNode.name().equals(DEFAULT_FIELDNAME)) {
                    name = jcrChildNode.name();
                }
                if (!childNameFilter.isIncluded(field.getName())) continue;
                if (ReflectionUtils.implementsInterface(field.getType(), List.class)) {
                    boolean nullOrEmpty;
                    boolean bl = nullOrEmpty = field.get(obj) == null || ((List)field.get(obj)).isEmpty();
                    if (!nullOrEmpty) {
                        Class paramClass = ReflectionUtils.getParameterizedClass(field);
                        children = (List)field.get(obj);
                        if (node.hasNode(name)) {
                            childContainer = node.getNode(name);
                            childNodes = childContainer.getNodes();
                            while (childNodes.hasNext()) {
                                Node child2 = childNodes.nextNode();
                                childEntity = this.findEntityByName(children, child2.getName());
                                if (childEntity == null) {
                                    child2.remove();
                                    continue;
                                }
                                this.updateNode(child2, childEntity, paramClass, childNameFilter, maxDepth, depth + 1);
                            }
                            for (int i = 0; i < children.size(); ++i) {
                                child = children.get(i);
                                if (childContainer.hasNode(this.getCleanName(this.getNodeName(child)))) continue;
                                this.addNode(childContainer, child, null);
                            }
                            continue;
                        }
                        childContainer = node.addNode(this.getCleanName(name));
                        for (int i = 0; i < children.size(); ++i) {
                            this.addNode(childContainer, children.get(i), null);
                        }
                        continue;
                    }
                    NodeIterator nodeIterator = node.getNodes(name);
                    while (nodeIterator.hasNext()) {
                        nodeIterator.nextNode().remove();
                    }
                    continue;
                }
                if (ReflectionUtils.implementsInterface(field.getType(), Map.class)) {
                    Map map = (Map)field.get(obj);
                    boolean nullOrEmpty = map == null || map.isEmpty();
                    NodeIterator nodeIterator = node.getNodes(name);
                    while (nodeIterator.hasNext()) {
                        nodeIterator.nextNode().remove();
                    }
                    if (nullOrEmpty) continue;
                    childContainer = node.addNode(this.getCleanName(name));
                    for (Map.Entry entry : map.entrySet()) {
                        this.mapToProperty((String)entry.getKey(), ReflectionUtils.getParameterizedClass(field, 1), null, entry.getValue(), childContainer);
                    }
                    continue;
                }
                if (!node.hasNode(name)) {
                    if (field.get(obj) == null) continue;
                    Node childContainer2 = node.addNode(this.getCleanName(name));
                    this.addNode(childContainer2, field.get(obj), null);
                    continue;
                }
                if (field.get(obj) != null) {
                    this.updateNode(node.getNode(name).getNodes().nextNode(), field.get(obj), field.getType(), childNameFilter, maxDepth, depth + 1);
                    continue;
                }
                NodeIterator nodeIterator = node.getNodes(name);
                while (nodeIterator.hasNext()) {
                    nodeIterator.nextNode().remove();
                }
                continue;
            }
            if (field.isAnnotationPresent(JcrReference.class)) {
                String referencedUUID;
                Node referencedNode;
                JcrReference jcrReference = field.getAnnotation(JcrReference.class);
                name = field.getName();
                if (!jcrReference.name().equals(DEFAULT_FIELDNAME)) {
                    name = jcrReference.name();
                }
                if (!childNameFilter.isIncluded(field.getName())) continue;
                if (!node.hasProperty(name)) {
                    String referencedUUID2;
                    Object referencedObject = field.get(obj);
                    String string = referencedUUID2 = referencedObject == null ? null : this.getNodeUUID(referencedObject);
                    if (referencedObject == null || referencedUUID2 == null || referencedUUID2.equals("")) continue;
                    referencedNode = node.getSession().getNodeByUUID(referencedUUID2);
                    node.setProperty(name, referencedNode);
                    continue;
                }
                Object referencedObject = field.get(obj);
                String string = referencedUUID = referencedObject == null ? null : this.getNodeUUID(referencedObject);
                if (referencedObject != null && referencedUUID != null && !referencedUUID.equals("")) {
                    if (node.getProperty(name).getString().equals(referencedUUID)) continue;
                    referencedNode = node.getSession().getNodeByUUID(referencedUUID);
                    node.setProperty(name, referencedNode);
                    continue;
                }
                node.setProperty(name, (Value)null);
                continue;
            }
            if (!field.isAnnotationPresent(JcrFileNode.class) || maxDepth >= 0 && depth >= maxDepth) continue;
            JcrFileNode jcrFileNode = field.getAnnotation(JcrFileNode.class);
            name = field.getName();
            if (!jcrFileNode.name().equals(DEFAULT_FIELDNAME)) {
                name = jcrFileNode.name();
            }
            if (!childNameFilter.isIncluded(field.getName())) continue;
            if (ReflectionUtils.implementsInterface(field.getType(), List.class)) {
                boolean nullOrEmpty;
                boolean bl = nullOrEmpty = field.get(obj) == null || ((List)field.get(obj)).isEmpty();
                if (!nullOrEmpty) {
                    int i;
                    Class paramClass = ReflectionUtils.getParameterizedClass(field);
                    children = (List)field.get(obj);
                    if (node.hasNode(name)) {
                        childContainer = node.getNode(name);
                        childNodes = childContainer.getNodes();
                        while (childNodes.hasNext()) {
                            Node child3 = childNodes.nextNode();
                            childEntity = (JcrFile)this.findEntityByName(children, child3.getName());
                            if (childEntity == null) {
                                child3.remove();
                                continue;
                            }
                            this.updateFileNode(child3, childEntity, childNameFilter, maxDepth, depth);
                        }
                        for (i = 0; i < children.size(); ++i) {
                            child = children.get(i);
                            if (childContainer.hasNode(this.getCleanName(this.getNodeName(child)))) continue;
                            this.addNode(childContainer, child, null);
                        }
                        continue;
                    }
                    JcrNode fileJcrNode = this.getJcrNodeAnnotation(ReflectionUtils.getParameterizedClass(field));
                    Node fileContainer = this.createFileFolderNode(fileJcrNode, name, node);
                    for (i = 0; i < children.size(); ++i) {
                        this.addFileNode(fileJcrNode, fileContainer, (JcrFile)children.get(i));
                    }
                    continue;
                }
                NodeIterator nodeIterator = node.getNodes(name);
                while (nodeIterator.hasNext()) {
                    nodeIterator.nextNode().remove();
                }
                continue;
            }
            if (!node.hasNode(name)) {
                if (field.get(obj) == null) continue;
                JcrNode fileJcrNode = this.getJcrNodeAnnotation(field.getType());
                Node fileContainer = this.createFileFolderNode(fileJcrNode, name, node);
                this.addFileNode(fileJcrNode, fileContainer, (JcrFile)field.get(obj));
                continue;
            }
            if (field.get(obj) != null) {
                this.updateFileNode(node.getNode(name).getNodes().nextNode(), (JcrFile)field.get(obj), childNameFilter, maxDepth, depth);
                continue;
            }
            NodeIterator nodeIterator = node.getNodes(name);
            while (nodeIterator.hasNext()) {
                nodeIterator.nextNode().remove();
            }
        }
        return node.getName();
    }

    private JcrNode getJcrNodeAnnotation(Class c) throws Exception {
        if (c.isAnnotationPresent(JcrNode.class)) {
            return c.getAnnotation(JcrNode.class);
        }
        for (Class parent = c.getSuperclass(); parent != null && parent != Object.class; parent = parent.getSuperclass()) {
            if (!parent.isAnnotationPresent(JcrNode.class)) continue;
            return parent.getAnnotation(JcrNode.class);
        }
        for (Class<?> interfaceClass : c.getInterfaces()) {
            if (!interfaceClass.isAnnotationPresent(JcrNode.class)) continue;
            return interfaceClass.getAnnotation(JcrNode.class);
        }
        return null;
    }

    private Node createFileFolderNode(JcrNode jcrNode, String nodeName, Node parentNode) throws Exception {
        if (jcrNode != null && jcrNode.nodeType().equals("nt:unstructured")) {
            return parentNode.addNode(this.getCleanName(nodeName));
        }
        return parentNode.addNode(this.getCleanName(nodeName), "nt:folder");
    }

    Node addNode(Node parentNode, Object entity, String[] mixinTypes) throws Exception {
        return this.addNode(parentNode, entity, mixinTypes, true);
    }

    private Node addNode(Node parentNode, Object entity, String[] mixinTypes, boolean createNode) throws Exception {
        Node node;
        JcrNode jcrNode = this.getJcrNodeAnnotation(entity.getClass());
        if (createNode) {
            node = jcrNode == null || jcrNode.nodeType().equals("nt:unstructured") ? parentNode.addNode(this.getCleanName(this.getNodeName(entity))) : parentNode.addNode(this.getCleanName(this.getNodeName(entity)), jcrNode.nodeType());
            if (mixinTypes != null) {
                for (String string : mixinTypes) {
                    if (!node.canAddMixin(string)) continue;
                    node.addMixin(string);
                }
            }
            if (jcrNode != null && jcrNode.mixinTypes() != null) {
                for (String string : jcrNode.mixinTypes()) {
                    if (!node.canAddMixin(string)) continue;
                    node.addMixin(string);
                }
            }
            this.setNodeName(entity, node.getName());
            this.setNodePath(entity, node.getPath());
            if (node.hasProperty("jcr:uuid")) {
                this.setUUID(entity, node.getUUID());
            }
        } else {
            node = parentNode;
        }
        if (jcrNode != null && !jcrNode.classNameProperty().equals("none")) {
            node.setProperty(jcrNode.classNameProperty(), entity.getClass().getCanonicalName());
        }
        for (Field field : ReflectionUtils.getDeclaredAndInheritedFields(entity.getClass())) {
            String name;
            field.setAccessible(true);
            if (field.isAnnotationPresent(JcrProperty.class)) {
                this.mapFieldToProperty(field, entity, node);
                continue;
            }
            if (field.isAnnotationPresent(JcrSerializedProperty.class)) {
                this.mapSerializedFieldToProperty(field, entity, node);
                continue;
            }
            if (field.isAnnotationPresent(JcrChildNode.class)) {
                Node childContainer;
                JcrChildNode jcrChildNode = field.getAnnotation(JcrChildNode.class);
                name = field.getName();
                if (!jcrChildNode.name().equals(DEFAULT_FIELDNAME)) {
                    name = jcrChildNode.name();
                }
                if (ReflectionUtils.implementsInterface(field.getType(), List.class)) {
                    childContainer = node.addNode(this.getCleanName(name), jcrChildNode.containerNodeType());
                    List children = (List)field.get(entity);
                    if (children == null || children.isEmpty()) continue;
                    for (int i = 0; i < children.size(); ++i) {
                        this.addNode(childContainer, children.get(i), null);
                    }
                    continue;
                }
                if (ReflectionUtils.implementsInterface(field.getType(), Map.class)) {
                    Map map = (Map)field.get(entity);
                    boolean nullOrEmpty = map == null || map.isEmpty();
                    NodeIterator nodeIterator = node.getNodes(name);
                    while (nodeIterator.hasNext()) {
                        nodeIterator.nextNode().remove();
                    }
                    if (nullOrEmpty) continue;
                    Node childContainer2 = node.addNode(this.getCleanName(name));
                    for (Map.Entry entry : map.entrySet()) {
                        this.mapToProperty((String)entry.getKey(), ReflectionUtils.getParameterizedClass(field, 1), null, entry.getValue(), childContainer2);
                    }
                    continue;
                }
                if (field.get(entity) == null) continue;
                childContainer = node.addNode(this.getCleanName(name), jcrChildNode.containerNodeType());
                this.addNode(childContainer, field.get(entity), null);
                continue;
            }
            if (field.isAnnotationPresent(JcrReference.class)) {
                String referenceUUID;
                Object referenceObject;
                JcrReference jcrReference = field.getAnnotation(JcrReference.class);
                name = field.getName();
                if (!jcrReference.name().equals(DEFAULT_FIELDNAME)) {
                    name = jcrReference.name();
                }
                if ((referenceObject = field.get(entity)) == null || (referenceUUID = this.getNodeUUID(referenceObject)) == null || referenceUUID.equals("")) continue;
                Node referencedNode = node.getSession().getNodeByUUID(referenceUUID);
                node.setProperty(name, referencedNode);
                continue;
            }
            if (!field.isAnnotationPresent(JcrFileNode.class)) continue;
            JcrFileNode jcrFileNode = field.getAnnotation(JcrFileNode.class);
            name = field.getName();
            if (!jcrFileNode.name().equals(DEFAULT_FIELDNAME)) {
                name = jcrFileNode.name();
            }
            if (field.get(entity) == null) continue;
            if (ReflectionUtils.implementsInterface(field.getType(), List.class)) {
                List children = (List)field.get(entity);
                if (children.isEmpty()) continue;
                JcrNode fileJcrNode = this.getJcrNodeAnnotation(ReflectionUtils.getParameterizedClass(field));
                Node fileContainer = this.createFileFolderNode(fileJcrNode, name, node);
                for (int i = 0; i < children.size(); ++i) {
                    this.addFileNode(fileJcrNode, fileContainer, (JcrFile)children.get(i));
                }
                continue;
            }
            JcrNode fileJcrNode = this.getJcrNodeAnnotation(field.getType());
            Node fileContainer = this.createFileFolderNode(fileJcrNode, name, node);
            this.addFileNode(fileJcrNode, fileContainer, (JcrFile)field.get(entity));
        }
        return node;
    }

    private <T extends JcrFile> void updateFileNode(Node fileNode, T file, NameFilter childNameFilter, int maxDepth, int depth) throws Exception {
        Node contentNode = fileNode.getNode("jcr:content");
        this.setFileNodeProperties(contentNode, file);
        this.updateNode(fileNode, file, file.getClass(), childNameFilter, maxDepth, depth + 1);
    }

    private <T extends JcrFile> void addFileNode(JcrNode jcrNode, Node parentNode, T file) throws Exception {
        Node fileNode = jcrNode == null || jcrNode.nodeType().equals("nt:unstructured") ? parentNode.addNode(this.getCleanName(file.getName())) : parentNode.addNode(this.getCleanName(file.getName()), jcrNode.nodeType());
        Node contentNode = fileNode.addNode("jcr:content", "nt:resource");
        this.setFileNodeProperties(contentNode, file);
        this.addNode(fileNode, file, null, false);
    }

    private <T extends JcrFile> void setFileNodeProperties(Node contentNode, T file) throws Exception {
        JcrDataProvider dataProvider;
        contentNode.setProperty("jcr:mimeType", file.getMimeType());
        contentNode.setProperty("jcr:lastModified", file.getLastModified());
        if (file.getEncoding() != null) {
            contentNode.setProperty("jcr:encoding", file.getEncoding());
        }
        if ((dataProvider = file.getDataProvider()) != null) {
            if (dataProvider.getType() == JcrDataProvider.TYPE.FILE && dataProvider.getFile() != null) {
                contentNode.setProperty("jcr:data", (InputStream)new FileInputStream(dataProvider.getFile()));
            } else if (dataProvider.getType() == JcrDataProvider.TYPE.BYTES && dataProvider.getBytes() != null) {
                contentNode.setProperty("jcr:data", (InputStream)new ByteArrayInputStream(dataProvider.getBytes()));
            } else if (dataProvider.getType() == JcrDataProvider.TYPE.STREAM && dataProvider.getInputStream() != null) {
                contentNode.setProperty("jcr:data", dataProvider.getInputStream());
            }
        }
    }

    private void mapSerializedFieldToProperty(Field field, Object obj, Node node) throws Exception {
        Object fieldValue;
        JcrSerializedProperty jcrProperty = field.getAnnotation(JcrSerializedProperty.class);
        String propertyName = field.getName();
        if (!jcrProperty.name().equals(DEFAULT_FIELDNAME)) {
            propertyName = jcrProperty.name();
        }
        if ((fieldValue = field.get(obj)) != null) {
            node.setProperty(propertyName, (InputStream)new ByteArrayInputStream(this.serialize(fieldValue)));
        } else {
            node.setProperty(propertyName, (Value)null);
        }
    }

    private void mapFieldToProperty(Field field, Object obj, Node node) throws Exception {
        JcrProperty jcrProperty = field.getAnnotation(JcrProperty.class);
        String name = field.getName();
        if (!jcrProperty.name().equals(DEFAULT_FIELDNAME)) {
            name = jcrProperty.name();
        }
        Class paramClass = ReflectionUtils.implementsInterface(field.getType(), List.class) ? ReflectionUtils.getParameterizedClass(field) : null;
        this.mapToProperty(name, field.getType(), paramClass, field.get(obj), node);
    }

    private void mapToProperty(String propertyName, Class type, Class paramClass, Object propertyValue, Node node) throws Exception {
        if (propertyValue != null) {
            ValueFactory valueFactory = node.getSession().getValueFactory();
            if (ReflectionUtils.implementsInterface(type, List.class)) {
                List fieldValues = (List)propertyValue;
                if (!fieldValues.isEmpty()) {
                    Value[] values = new Value[fieldValues.size()];
                    for (int i = 0; i < fieldValues.size(); ++i) {
                        values[i] = this.createValue(paramClass, fieldValues.get(i), valueFactory);
                    }
                    node.setProperty(propertyName, values);
                }
            } else if (type.isArray() && type.getComponentType() != Byte.TYPE) {
                Value[] values;
                if (type.getComponentType() == Integer.TYPE) {
                    int[] ints = (int[])propertyValue;
                    values = new Value[ints.length];
                    for (int i = 0; i < ints.length; ++i) {
                        values[i] = this.createValue(Integer.TYPE, ints[i], valueFactory);
                    }
                } else if (type.getComponentType() == Long.TYPE) {
                    long[] longs = (long[])propertyValue;
                    values = new Value[longs.length];
                    for (int i = 0; i < longs.length; ++i) {
                        values[i] = this.createValue(Long.TYPE, longs[i], valueFactory);
                    }
                } else if (type.getComponentType() == Double.TYPE) {
                    double[] doubles = (double[])propertyValue;
                    values = new Value[doubles.length];
                    for (int i = 0; i < doubles.length; ++i) {
                        values[i] = this.createValue(Double.TYPE, doubles[i], valueFactory);
                    }
                } else if (type.getComponentType() == Boolean.TYPE) {
                    boolean[] booleans = (boolean[])propertyValue;
                    values = new Value[booleans.length];
                    for (int i = 0; i < booleans.length; ++i) {
                        values[i] = this.createValue(Boolean.TYPE, booleans[i], valueFactory);
                    }
                } else if (type.getComponentType() == Locale.class) {
                    Locale[] locales = (Locale[])propertyValue;
                    values = new Value[locales.length];
                    for (int i = 0; i < locales.length; ++i) {
                        values[i] = this.createValue(Locale.class, locales[i], valueFactory);
                    }
                } else {
                    Object[] objects = (Object[])propertyValue;
                    values = new Value[objects.length];
                    for (int i = 0; i < objects.length; ++i) {
                        values[i] = this.createValue(type.getComponentType(), objects[i], valueFactory);
                    }
                }
                node.setProperty(propertyName, values);
            } else {
                Value value = this.createValue(type, propertyValue, valueFactory);
                if (value != null) {
                    node.setProperty(propertyName, value);
                }
            }
        } else {
            node.setProperty(propertyName, (Value)null);
        }
    }

    private boolean isVersionable(Node node) throws Exception {
        for (NodeType mixinType : node.getMixinNodeTypes()) {
            if (!mixinType.getName().equals("mix:versionable")) continue;
            return true;
        }
        return false;
    }

    private void mapNodeToClass(Object obj, Node node, NameFilter nameFilter, int maxDepth, Object parentObject, int depth) throws Exception {
        if (!ReflectionUtils.extendsClass(obj.getClass(), JcrFile.class)) {
            this.setNodeName(obj, node.getName());
        }
        for (Field field : ReflectionUtils.getDeclaredAndInheritedFields(obj.getClass())) {
            Class childObjClass;
            NodeIterator iterator;
            ParameterizedType ptype;
            ArrayList<Object> children;
            String name;
            field.setAccessible(true);
            if (field.isAnnotationPresent(JcrProperty.class)) {
                this.mapPropertyToField(obj, field, node);
                continue;
            }
            if (field.isAnnotationPresent(JcrSerializedProperty.class)) {
                this.mapSerializedPropertyToField(obj, field, node);
                continue;
            }
            if (field.isAnnotationPresent(JcrUUID.class)) {
                if (!node.hasProperty("jcr:uuid")) continue;
                field.set(obj, node.getUUID());
                continue;
            }
            if (field.isAnnotationPresent(JcrBaseVersionName.class)) {
                if (!this.isVersionable(node)) continue;
                field.set(obj, node.getBaseVersion().getName());
                continue;
            }
            if (field.isAnnotationPresent(JcrBaseVersionCreated.class)) {
                if (!this.isVersionable(node)) continue;
                field.set(obj, this.getValue(field.getType(), node.getSession().getValueFactory().createValue(node.getBaseVersion().getCreated())));
                continue;
            }
            if (field.isAnnotationPresent(JcrVersionName.class)) {
                if (node.getParent() != null && node.getParent().isNodeType("nt:version")) {
                    field.set(obj, node.getParent().getName());
                    continue;
                }
                if (!this.isVersionable(node)) continue;
                field.set(obj, node.getBaseVersion().getName());
                continue;
            }
            if (field.isAnnotationPresent(JcrVersionCreated.class)) {
                if (node.getParent() != null && node.getParent().isNodeType("nt:version")) {
                    Version version = (Version)node.getParent();
                    field.set(obj, this.getValue(field.getType(), node.getSession().getValueFactory().createValue(version.getCreated())));
                    continue;
                }
                if (!this.isVersionable(node)) continue;
                field.set(obj, this.getValue(field.getType(), node.getSession().getValueFactory().createValue(node.getBaseVersion().getCreated())));
                continue;
            }
            if (field.isAnnotationPresent(JcrCheckedout.class)) {
                field.set(obj, node.isCheckedOut());
                continue;
            }
            if (field.isAnnotationPresent(JcrCreated.class)) {
                if (!node.hasProperty("jcr:created")) continue;
                field.set(obj, this.getValue(field.getType(), node.getProperty("jcr:created").getValue()));
                continue;
            }
            if (field.isAnnotationPresent(JcrParentNode.class)) {
                if (parentObject == null) continue;
                field.set(obj, parentObject);
                continue;
            }
            if (field.isAnnotationPresent(JcrChildNode.class) && (maxDepth < 0 || depth < maxDepth)) {
                JcrChildNode jcrChildNode = field.getAnnotation(JcrChildNode.class);
                name = field.getName();
                if (!jcrChildNode.name().equals(DEFAULT_FIELDNAME)) {
                    name = jcrChildNode.name();
                }
                if (!node.hasNode(name) || !nameFilter.isIncluded(field.getName())) continue;
                Node childrenContainer = node.getNode(name);
                if (ReflectionUtils.implementsInterface(field.getType(), List.class)) {
                    children = new ArrayList<Object>();
                    ptype = (ParameterizedType)field.getGenericType();
                    iterator = childrenContainer.getNodes();
                    while (iterator.hasNext()) {
                        childObjClass = (Class)ptype.getActualTypeArguments()[0];
                        Node childNode = iterator.nextNode();
                        Object childObj = this.createInstanceForNode(childObjClass, childNode);
                        this.mapNodeToClass(childObj, childNode, nameFilter, maxDepth, obj, depth + 1);
                        children.add(childObj);
                    }
                    field.set(obj, children);
                    continue;
                }
                if (ReflectionUtils.implementsInterface(field.getType(), Map.class)) {
                    Class valueType = ReflectionUtils.getParameterizedClass(field, 1);
                    PropertyIterator propIterator = childrenContainer.getProperties();
                    this.mapPropertiesToMap(obj, field, valueType, propIterator);
                    continue;
                }
                Class<?> childObjClass2 = field.getType();
                Node childNode = childrenContainer.getNodes().nextNode();
                Object childObj = this.createInstanceForNode(childObjClass2, childNode);
                this.mapNodeToClass(childObj, childNode, nameFilter, maxDepth, obj, depth + 1);
                field.set(obj, childObj);
                continue;
            }
            if (field.isAnnotationPresent(JcrReference.class)) {
                JcrReference jcrReference = field.getAnnotation(JcrReference.class);
                name = field.getName();
                if (!jcrReference.name().equals(DEFAULT_FIELDNAME)) {
                    name = jcrReference.name();
                }
                if (!node.hasProperty(name)) continue;
                Node referencedNode = node.getProperty(name).getNode();
                Class<?> referenceObjClass = field.getType();
                Object referencedObject = this.createInstanceForNode(referenceObjClass, referencedNode);
                if (nameFilter.isIncluded(field.getName()) && (maxDepth < 0 || depth < maxDepth)) {
                    this.mapNodeToClass(referencedObject, referencedNode, nameFilter, maxDepth, obj, depth + 1);
                } else {
                    this.setUUID(obj, node.getProperty(name).getString());
                }
                field.set(obj, referencedObject);
                continue;
            }
            if (field.isAnnotationPresent(JcrFileNode.class) && (maxDepth < 0 || depth < maxDepth)) {
                JcrFileNode jcrFileNode = field.getAnnotation(JcrFileNode.class);
                name = field.getName();
                if (!jcrFileNode.name().equals(DEFAULT_FIELDNAME)) {
                    name = jcrFileNode.name();
                }
                if (!node.hasNode(name) || !nameFilter.isIncluded(field.getName())) continue;
                Node fileContainer = node.getNode(name);
                if (ReflectionUtils.implementsInterface(field.getType(), List.class)) {
                    children = new ArrayList();
                    ptype = (ParameterizedType)field.getGenericType();
                    iterator = fileContainer.getNodes();
                    while (iterator.hasNext()) {
                        childObjClass = (Class)ptype.getActualTypeArguments()[0];
                        JcrFile fileObj = (JcrFile)childObjClass.newInstance();
                        this.mapNodeToFileObject(jcrFileNode, fileObj, iterator.nextNode(), nameFilter, maxDepth, obj, depth);
                        children.add(fileObj);
                    }
                    field.set(obj, children);
                    continue;
                }
                JcrFile fileObj = (JcrFile)field.getType().newInstance();
                this.mapNodeToFileObject(jcrFileNode, fileObj, fileContainer.getNodes().nextNode(), nameFilter, maxDepth, obj, depth);
                field.set(obj, fileObj);
                continue;
            }
            if (!field.getName().equals("path")) continue;
            field.set(obj, node.getPath());
        }
    }

    private <T extends JcrFile> void mapNodeToFileObject(JcrFileNode jcrFileNode, T fileObj, Node fileNode, NameFilter nameFilter, int maxDepth, Object parentObject, int depth) throws Exception {
        Node contentNode = fileNode.getNode("jcr:content");
        fileObj.setName(fileNode.getName());
        fileObj.setPath(fileNode.getPath());
        fileObj.setMimeType(contentNode.getProperty("jcr:mimeType").getString());
        fileObj.setLastModified(contentNode.getProperty("jcr:lastModified").getDate());
        if (contentNode.hasProperty("jcr:encoding")) {
            fileObj.setEncoding(contentNode.getProperty("jcr:encoding").getString());
        }
        if (jcrFileNode.loadType() == JcrFileNode.LoadType.BYTES) {
            JcrDataProviderImpl dataProvider = new JcrDataProviderImpl(JcrDataProvider.TYPE.BYTES, this.readBytes(contentNode.getProperty("jcr:data").getStream()));
            fileObj.setDataProvider(dataProvider);
        } else if (jcrFileNode.loadType() == JcrFileNode.LoadType.STREAM) {
            JcrDataProviderImpl dataProvider = new JcrDataProviderImpl(JcrDataProvider.TYPE.STREAM, contentNode.getProperty("jcr:data").getStream());
            fileObj.setDataProvider(dataProvider);
        }
        this.mapNodeToClass(fileObj, fileNode, nameFilter, maxDepth, parentObject, depth + 1);
    }

    private void mapPropertiesToMap(Object obj, Field field, Class valueType, PropertyIterator propIterator) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        while (propIterator.hasNext()) {
            Property p = propIterator.nextProperty();
            if (p.getName().startsWith("jcr:") || p.getName().startsWith("nt:")) continue;
            if (valueType.isArray()) {
                if (p.getDefinition().isMultiple()) {
                    map.put(p.getName(), this.valuesToArray(valueType.getComponentType(), p.getValues()));
                    continue;
                }
                Value[] values = new Value[]{p.getValue()};
                map.put(p.getName(), this.valuesToArray(valueType.getComponentType(), values));
                continue;
            }
            map.put(p.getName(), this.getValue(valueType, p.getValue()));
        }
        field.set(obj, map);
    }

    private Object[] valuesToArray(Class type, Value[] values) throws Exception {
        Object[] arr = (Object[])Array.newInstance(type, values.length);
        for (int i = 0; i < values.length; ++i) {
            arr[i] = this.getValue(type, values[i]);
        }
        return arr;
    }

    private void mapSerializedPropertyToField(Object obj, Field field, Node node) throws Exception {
        JcrSerializedProperty jcrProperty = field.getAnnotation(JcrSerializedProperty.class);
        String propertyName = field.getName();
        if (!jcrProperty.name().equals(DEFAULT_FIELDNAME)) {
            propertyName = jcrProperty.name();
        }
        if (node.hasProperty(propertyName)) {
            Property p = node.getProperty(propertyName);
            field.set(obj, this.deserialize(p.getStream()));
        }
    }

    private void mapPropertyToField(Object obj, Field field, Node node) throws Exception {
        JcrProperty jcrProperty = field.getAnnotation(JcrProperty.class);
        String name = field.getName();
        if (!jcrProperty.name().equals(DEFAULT_FIELDNAME)) {
            name = jcrProperty.name();
        }
        if (node.hasProperty(name)) {
            Property p = node.getProperty(name);
            if (ReflectionUtils.implementsInterface(field.getType(), List.class)) {
                ArrayList<Object> properties = new ArrayList<Object>();
                Class paramClass = ReflectionUtils.getParameterizedClass(field);
                for (Value value : p.getValues()) {
                    properties.add(this.getValue(paramClass, value));
                }
                field.set(obj, properties);
            } else if (field.getType().isArray() && field.getType().getComponentType() != Byte.TYPE) {
                Value[] values = p.getValues();
                if (field.getType().getComponentType() == Integer.TYPE) {
                    int[] arr = new int[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        arr[i] = (int)values[i].getDouble();
                    }
                    field.set(obj, arr);
                } else if (field.getType().getComponentType() == Long.TYPE) {
                    long[] arr = new long[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        arr[i] = values[i].getLong();
                    }
                    field.set(obj, arr);
                } else if (field.getType().getComponentType() == Double.TYPE) {
                    double[] arr = new double[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        arr[i] = values[i].getDouble();
                    }
                    field.set(obj, arr);
                } else if (field.getType().getComponentType() == Boolean.TYPE) {
                    boolean[] arr = new boolean[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        arr[i] = values[i].getBoolean();
                    }
                    field.set(obj, arr);
                } else if (field.getType().getComponentType() == Locale.class) {
                    Locale[] arr = new Locale[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        arr[i] = Mapper.parseLocale(values[i].getString());
                    }
                    field.set(obj, arr);
                } else {
                    Object[] arr = this.valuesToArray(field.getType().getComponentType(), values);
                    field.set(obj, arr);
                }
            } else {
                field.set(obj, this.getValue(field.getType(), p.getValue()));
            }
        }
    }

    private Value createValue(Class c, Object fieldValue, ValueFactory valueFactory) throws Exception {
        if (c == String.class) {
            return valueFactory.createValue((String)fieldValue);
        }
        if (c == Date.class) {
            Calendar cal = Calendar.getInstance();
            cal.setTime((Date)fieldValue);
            return valueFactory.createValue(cal);
        }
        if (c == Timestamp.class) {
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(((Timestamp)fieldValue).getTime());
            return valueFactory.createValue(cal);
        }
        if (c == Calendar.class) {
            return valueFactory.createValue((Calendar)fieldValue);
        }
        if (c == InputStream.class) {
            return valueFactory.createValue((InputStream)fieldValue);
        }
        if (c.isArray() && c.getComponentType() == Byte.TYPE) {
            return valueFactory.createValue((InputStream)new ByteArrayInputStream((byte[])fieldValue));
        }
        if (c == Integer.class || c == Integer.TYPE) {
            return valueFactory.createValue((long)((Integer)fieldValue).intValue());
        }
        if (c == Long.class || c == Long.TYPE) {
            return valueFactory.createValue(((Long)fieldValue).longValue());
        }
        if (c == Double.class || c == Double.TYPE) {
            return valueFactory.createValue(((Double)fieldValue).doubleValue());
        }
        if (c == Boolean.class || c == Boolean.TYPE) {
            return valueFactory.createValue(((Boolean)fieldValue).booleanValue());
        }
        if (c == Locale.class) {
            return valueFactory.createValue(((Locale)fieldValue).toString());
        }
        return null;
    }

    private Object getValue(Class c, Value value) throws Exception {
        if (c == String.class) {
            return value.getString();
        }
        if (c == Date.class) {
            return value.getDate().getTime();
        }
        if (c == Timestamp.class) {
            return new Timestamp(value.getDate().getTimeInMillis());
        }
        if (c == Calendar.class) {
            return value.getDate();
        }
        if (c == InputStream.class) {
            return value.getStream();
        }
        if (c.isArray() && c.getComponentType() == Byte.TYPE) {
            return this.readBytes(value.getStream());
        }
        if (c == Integer.class || c == Integer.TYPE) {
            return (int)value.getDouble();
        }
        if (c == Long.class || c == Long.TYPE) {
            return value.getLong();
        }
        if (c == Double.class || c == Double.TYPE) {
            return value.getDouble();
        }
        if (c == Boolean.class || c == Boolean.TYPE) {
            return value.getBoolean();
        }
        if (c == Locale.class) {
            return Mapper.parseLocale(value.getString());
        }
        return null;
    }

    private static Locale parseLocale(String localeString) {
        if (localeString != null && localeString.length() > 0) {
            StringTokenizer st = new StringTokenizer(localeString, "_");
            String language = st.hasMoreElements() ? st.nextToken() : Locale.getDefault().getLanguage();
            String country = st.hasMoreElements() ? st.nextToken() : "";
            String variant = st.hasMoreElements() ? st.nextToken() : "";
            return new Locale(language, country, variant);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readBytes(InputStream in) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            int len;
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
        finally {
            in.close();
            out.close();
        }
        return out.toByteArray();
    }

    private byte[] serialize(Object obj) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bos);
        out.writeObject(obj);
        out.close();
        return bos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object deserialize(InputStream byteStream) throws Exception {
        ObjectInputStream in = new ObjectInputStream(byteStream);
        try {
            Object object = in.readObject();
            return object;
        }
        finally {
            in.close();
        }
    }
}

