/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.jar;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import org.gatein.common.jar.JarEntryInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarInfo {
    private SortedSet<JarEntryInfo> entries;

    public JarInfo(JarFile file) {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        this.entries = new TreeSet<JarEntryInfo>();
        Enumeration<JarEntry> e = file.entries();
        while (e.hasMoreElements()) {
            JarEntry entry = e.nextElement();
            JarEntryInfo info = new JarEntryInfo(entry);
            this.entries.add(info);
        }
    }

    public JarInfo(JarInputStream in) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException();
        }
        this.entries = new TreeSet<JarEntryInfo>();
        JarEntry entry = in.getNextJarEntry();
        while (entry != null) {
            JarEntryInfo info = new JarEntryInfo(entry);
            this.entries.add(info);
            entry = in.getNextJarEntry();
        }
    }

    public Iterator<JarEntryInfo> entries() {
        return this.entries.iterator();
    }
}

