/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.search.lucene.index.merge;

import java.util.Collection;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.xcmis.search.lucene.index.LuceneIndexDataManager;
import org.xcmis.search.lucene.index.merge.AggregatePolicy;
import org.xcmis.search.lucene.index.merge.InheritanceAggregationPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaxCandidatsCountAggrigatePolicy
extends InheritanceAggregationPolicy {
    private static final Log LOG = ExoLogger.getLogger(MaxCandidatsCountAggrigatePolicy.class);
    public static final int DEFAULT_MAX_CHAINS_COUNT = 40;

    public MaxCandidatsCountAggrigatePolicy(AggregatePolicy superAggregatePolicy) {
        super(superAggregatePolicy);
    }

    @Override
    public Collection<LuceneIndexDataManager> findIndexDataManagerToAggrigate(Collection<LuceneIndexDataManager> aggregateCandidat, long requiredCandidatCount, long reguiredTotalCandidatSize) {
        long required = Math.max(requiredCandidatCount, (long)(aggregateCandidat.size() - 40));
        if (required > 0L) {
            required = Math.max(required, Math.round((double)aggregateCandidat.size() * 0.3));
        }
        return super.findIndexDataManagerToAggrigate(aggregateCandidat, required, reguiredTotalCandidatSize);
    }
}

