/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.search.query.plan;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.xcmis.search.content.Schema;
import org.xcmis.search.model.Limit;
import org.xcmis.search.model.column.Column;
import org.xcmis.search.model.constraint.Constraint;
import org.xcmis.search.model.ordering.Ordering;
import org.xcmis.search.model.source.SelectorName;
import org.xcmis.search.model.source.join.JoinCondition;
import org.xcmis.search.model.source.join.JoinType;
import org.xcmis.search.query.plan.JoinAlgorithm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QueryExecutionPlan
implements Iterator<QueryExecutionPlan> {
    private Set<SelectorName> selectors;
    private final Type type;

    public QueryExecutionPlan(Type type) {
        this.type = type;
        this.selectors = new HashSet<SelectorName>();
    }

    @Override
    public boolean hasNext() {
        return false;
    }

    @Override
    public QueryExecutionPlan next() {
        return null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void addSelector(SelectorName symbol) {
        if (symbol != null) {
            this.selectors.add(symbol);
        }
    }

    public void addSelector(SelectorName first, SelectorName second) {
        if (first != null) {
            this.selectors.add(first);
        }
        if (second != null) {
            this.selectors.add(second);
        }
    }

    public void addSelectors(Iterable<SelectorName> names) {
        for (SelectorName name : names) {
            if (name == null) continue;
            this.selectors.add(name);
        }
    }

    public QueryExecutionPlan findPlanByType(Type type) {
        if (this.type.equals((Object)type)) {
            return this;
        }
        return null;
    }

    public Set<SelectorName> getSelectors() {
        return this.selectors;
    }

    public Type getType() {
        return this.type;
    }

    public int getSize() {
        return 1;
    }

    protected void getRecursiveString(StringBuilder str, int indentLevel) {
        str.append("\n");
        str.append(StringUtils.repeat((String)"\t", (int)indentLevel));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.getRecursiveString(sb, 0);
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        JOIN("Join"),
        SELECTOR("Selector"),
        PROJECT("Project"),
        WHERE("Where"),
        SORT("Sort"),
        LIMIT("Limit");

        private static final Map<String, Type> TYPE_BY_SYMBOL;
        private final String symbol;

        private Type(String symbol) {
            this.symbol = symbol;
        }

        public String getSymbol() {
            return this.symbol;
        }

        public String toString() {
            return this.symbol;
        }

        public static Type forSymbol(String symbol) {
            Validate.notNull((Object)symbol, (String)"The symbol argument may not be null");
            return TYPE_BY_SYMBOL.get(symbol.toUpperCase().trim());
        }

        static {
            HashMap<String, Type> typesBySymbol = new HashMap<String, Type>();
            for (Type type : Type.values()) {
                typesBySymbol.put(type.getSymbol().toUpperCase(), type);
            }
            TYPE_BY_SYMBOL = Collections.unmodifiableMap(typesBySymbol);
        }
    }

    public static class WhereExecutionPlan
    extends NestedExecutionPlan {
        private Constraint constraint;

        public WhereExecutionPlan() {
            super(Type.WHERE);
        }

        public WhereExecutionPlan(QueryExecutionPlan childPlan) {
            super(Type.WHERE, childPlan);
        }

        public Constraint getConstraint() {
            return this.constraint;
        }

        public void setConstraint(Constraint constraint) {
            this.constraint = constraint;
        }

        protected void getRecursiveString(StringBuilder str, int indentLevel) {
            super.getRecursiveString(str, indentLevel);
            str.append("Type.WHERE=" + this.constraint);
            this.childPlan.getRecursiveString(str, indentLevel++);
        }
    }

    public static abstract class SourceExecutionPlan
    extends QueryExecutionPlan {
        public SourceExecutionPlan(Type type) {
            super(type);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SortExecutionPlan
    extends NestedExecutionPlan {
        private List<Ordering> orderings;

        public SortExecutionPlan() {
            super(Type.SORT);
        }

        public SortExecutionPlan(QueryExecutionPlan childPlan) {
            super(Type.SORT, childPlan);
        }

        public List<Ordering> getOrderings() {
            return this.orderings;
        }

        public void setOrderings(List<Ordering> orderings) {
            this.orderings = orderings;
        }

        @Override
        protected void getRecursiveString(StringBuilder str, int indentLevel) {
            super.getRecursiveString(str, indentLevel);
            str.append(this.getType().getSymbol() + "=" + this.orderings);
            this.childPlan.getRecursiveString(str, indentLevel++);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectorExecutionPlan
    extends SourceExecutionPlan {
        private SelectorName alias;
        private SelectorName name;
        private List<Schema.Column> columns;

        public SelectorExecutionPlan() {
            super(Type.SELECTOR);
        }

        public SelectorName getAlias() {
            return this.alias;
        }

        public List<Schema.Column> getColumns() {
            return this.columns;
        }

        public SelectorName getName() {
            return this.name;
        }

        public void setAlias(SelectorName alias) {
            this.alias = alias;
        }

        public void setColumns(List<Schema.Column> columns) {
            this.columns = columns;
        }

        public void setName(SelectorName name) {
            this.name = name;
        }

        @Override
        protected void getRecursiveString(StringBuilder str, int indentLevel) {
            super.getRecursiveString(str, indentLevel);
            str.append(this.getType().getSymbol() + "[" + this.name + "=" + this.alias + "{" + this.columns + "}]");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ProjectExecutionPlan
    extends NestedExecutionPlan {
        private List<Column> columns;

        public ProjectExecutionPlan() {
            super(Type.PROJECT);
        }

        public ProjectExecutionPlan(QueryExecutionPlan childPlan) {
            super(Type.PROJECT, childPlan);
        }

        @Override
        protected void getRecursiveString(StringBuilder str, int indentLevel) {
            super.getRecursiveString(str, indentLevel);
            str.append(this.getType().getSymbol() + "=" + this.columns);
            this.childPlan.getRecursiveString(str, ++indentLevel);
        }

        public List<Column> getColumns() {
            return this.columns;
        }

        public void setColumns(List<Column> columns2) {
            this.columns = columns2;
        }
    }

    public static class NestedExecutionPlan
    extends QueryExecutionPlan {
        protected QueryExecutionPlan childPlan;
        private QueryExecutionPlan next;

        public boolean hasNext() {
            return this.next != null;
        }

        public QueryExecutionPlan next() {
            if (this.next != null) {
                QueryExecutionPlan result = this.next;
                this.next = null;
                return result;
            }
            return null;
        }

        public NestedExecutionPlan(Type type) {
            super(type);
        }

        public NestedExecutionPlan(Type type, QueryExecutionPlan childPlan) {
            super(type);
            this.childPlan = childPlan;
            this.next = childPlan;
        }

        public int getSize() {
            return 1 + this.childPlan.getSize();
        }

        public QueryExecutionPlan findPlanByType(Type type) {
            if (this.getType().equals((Object)type)) {
                return this;
            }
            return this.childPlan.findPlanByType(type);
        }

        public QueryExecutionPlan getChildPlan() {
            return this.childPlan;
        }

        public void setChildPlan(QueryExecutionPlan childPlan) {
            this.childPlan = childPlan;
        }
    }

    public static class LimitExecutionPlan
    extends NestedExecutionPlan {
        private Limit limit;

        public LimitExecutionPlan() {
            super(Type.LIMIT);
        }

        public LimitExecutionPlan(QueryExecutionPlan childPlan) {
            super(Type.LIMIT, childPlan);
        }

        public Limit getLimit() {
            return this.limit;
        }

        public void setLimit(Limit limit) {
            this.limit = limit;
        }

        protected void getRecursiveString(StringBuilder str, int indentLevel) {
            super.getRecursiveString(str, indentLevel);
            str.append(this.getType().getSymbol() + "=" + this.limit);
            this.childPlan.getRecursiveString(str, indentLevel++);
        }
    }

    public static class JoinExecutionPlan
    extends SourceExecutionPlan {
        private JoinType joinType;
        private JoinAlgorithm joinAlgorithm;
        private JoinCondition joinCondition;
        private SourceExecutionPlan leftPlan;
        private SourceExecutionPlan rightPlan;

        public JoinExecutionPlan() {
            super(Type.JOIN);
        }

        public int getSize() {
            return 1 + this.leftPlan.getSize() + this.rightPlan.getSize();
        }

        public JoinAlgorithm getJoinAlgorithm() {
            return this.joinAlgorithm;
        }

        public JoinCondition getJoinCondition() {
            return this.joinCondition;
        }

        public JoinType getJoinType() {
            return this.joinType;
        }

        public SourceExecutionPlan getLeftPlan() {
            return this.leftPlan;
        }

        public SourceExecutionPlan getRightPlan() {
            return this.rightPlan;
        }

        public void setJoinAlgorithm(JoinAlgorithm joinAlgorithm) {
            this.joinAlgorithm = joinAlgorithm;
        }

        public void setJoinCondition(JoinCondition joinCondition) {
            this.joinCondition = joinCondition;
        }

        public void setJoinType(JoinType joinType) {
            this.joinType = joinType;
        }

        public void setLeftPlan(SourceExecutionPlan leftPlan) {
            this.leftPlan = leftPlan;
        }

        public void setRightPlan(SourceExecutionPlan rightPlan) {
            this.rightPlan = rightPlan;
        }

        protected void getRecursiveString(StringBuilder str, int indentLevel) {
            super.getRecursiveString(str, indentLevel);
            str.append("Left:" + this.leftPlan.toString());
            str.append("Right:" + this.rightPlan.toString());
        }
    }
}

