/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.ext.proxy;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.common.http.client.HTTPConnection;
import org.exoplatform.common.http.client.HTTPResponse;
import org.exoplatform.common.http.client.HttpOutputStream;
import org.exoplatform.common.http.client.ModuleException;
import org.exoplatform.common.http.client.NVPair;
import org.exoplatform.common.http.client.ProtocolNotSuppException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="proxy")
public class ProxyService
implements ResourceContainer {
    protected static final int DEFAULT_CONNECT_TIMEOUT_MS = 5000;
    private static final Log LOG = ExoLogger.getLogger(ProxyService.class);

    @DELETE
    public Response doProxyDelete(@Context HttpHeaders headers, @Context UriInfo uriInfo, @QueryParam(value="url") String urlParam) {
        if (urlParam == null) {
            IllegalArgumentException e = new IllegalArgumentException("'url' parameter not found in proxy request");
            throw new WebApplicationException((Throwable)e, this.createErrorResponse(e, 404));
        }
        try {
            HTTPResponse resp;
            URL url = new URL(urlParam);
            HTTPConnection conn = new HTTPConnection(url);
            conn.setTimeout(5000);
            NVPair[] headerPairs = this.toNVPair((MultivaluedMap<String, String>)headers.getRequestHeaders(), Collections.singleton(new CaseInsensitiveStringWrapper("Host")));
            conn.setAllowUserInteraction(false);
            NVPair credentials = this.getCredentials(url);
            if (credentials != null) {
                conn.addBasicAuthorization(null, credentials.getName(), credentials.getValue());
            }
            if ((resp = conn.Delete(url.getFile(), headerPairs)).getStatusCode() >= 300 && LOG.isDebugEnabled()) {
                LOG.debug((Object)("DELETE. received status " + resp.getStatusCode() + ", " + resp.getReasonLine()));
                byte[] data = resp.getData();
                if (data != null) {
                    LOG.debug((Object)("DELETE. Text : " + new String(data)));
                }
            }
            return this.createResponse(resp);
        }
        catch (MalformedURLException mue) {
            throw new WebApplicationException((Throwable)mue, this.createErrorResponse(mue, 400));
        }
        catch (ProtocolNotSuppException pnse) {
            throw new WebApplicationException((Throwable)pnse, this.createErrorResponse(pnse, 400));
        }
        catch (IOException ioe) {
            throw new WebApplicationException((Throwable)ioe, this.createErrorResponse(ioe, 500));
        }
        catch (ModuleException me) {
            throw new WebApplicationException((Throwable)me, this.createErrorResponse(me, 500));
        }
    }

    @GET
    public Response doProxyGet(@Context HttpHeaders headers, @Context UriInfo uriInfo, @QueryParam(value="url") String urlParam) {
        if (urlParam == null) {
            IllegalArgumentException e = new IllegalArgumentException("'url' parameter not found in proxy request");
            throw new WebApplicationException((Throwable)e, this.createErrorResponse(e, 404));
        }
        try {
            HTTPResponse resp;
            URL url = new URL(urlParam);
            HTTPConnection conn = new HTTPConnection(url);
            conn.setTimeout(5000);
            NVPair[] headerPairs = this.toNVPair((MultivaluedMap<String, String>)headers.getRequestHeaders(), Collections.singleton(new CaseInsensitiveStringWrapper("Host")));
            conn.setAllowUserInteraction(false);
            NVPair credentials = this.getCredentials(url);
            if (credentials != null) {
                conn.addBasicAuthorization(null, credentials.getName(), credentials.getValue());
            }
            if ((resp = conn.Get(url.getFile(), (NVPair[])null, headerPairs)).getStatusCode() >= 300 && LOG.isDebugEnabled()) {
                LOG.debug((Object)("GET. received status " + resp.getStatusCode() + ", " + resp.getReasonLine()));
                byte[] data = resp.getData();
                if (data != null) {
                    LOG.debug((Object)("GET. Text : " + new String(data)));
                }
            }
            return this.createResponse(resp);
        }
        catch (MalformedURLException mue) {
            throw new WebApplicationException((Throwable)mue, this.createErrorResponse(mue, 400));
        }
        catch (ProtocolNotSuppException pnse) {
            throw new WebApplicationException((Throwable)pnse, this.createErrorResponse(pnse, 400));
        }
        catch (IOException ioe) {
            throw new WebApplicationException((Throwable)ioe, this.createErrorResponse(ioe, 500));
        }
        catch (ModuleException me) {
            throw new WebApplicationException((Throwable)me, this.createErrorResponse(me, 500));
        }
    }

    @POST
    public Response doProxyPost(@Context HttpHeaders headers, @Context UriInfo uriInfo, @QueryParam(value="url") String urlParam, InputStream entity) {
        if (urlParam == null) {
            IllegalArgumentException e = new IllegalArgumentException("'url' parameter not found in proxy request");
            throw new WebApplicationException((Throwable)e, this.createErrorResponse(e, 404));
        }
        try {
            URL url = new URL(urlParam);
            HTTPConnection conn = new HTTPConnection(url);
            conn.setTimeout(5000);
            NVPair[] headerPairs = this.toNVPair((MultivaluedMap<String, String>)headers.getRequestHeaders(), Collections.singleton(new CaseInsensitiveStringWrapper("Host")));
            conn.setAllowUserInteraction(false);
            NVPair credentials = this.getCredentials(url);
            if (credentials != null) {
                conn.addBasicAuthorization(null, credentials.getName(), credentials.getValue());
            }
            HTTPResponse resp = null;
            if (entity != null) {
                HttpOutputStream stream = new HttpOutputStream();
                resp = conn.Post(url.getFile(), stream, headerPairs);
                byte[] buf = new byte[1024];
                int r = -1;
                while ((r = entity.read(buf)) != -1) {
                    stream.write(buf, 0, r);
                }
                stream.close();
            } else {
                resp = conn.Post(url.getFile(), (NVPair[])null, headerPairs);
            }
            if (resp.getStatusCode() >= 300 && LOG.isDebugEnabled()) {
                LOG.debug((Object)("POST. received status " + resp.getStatusCode() + ", " + resp.getReasonLine()));
                byte[] data = resp.getData();
                if (data != null) {
                    LOG.debug((Object)("POST. Text : " + new String(data)));
                }
            }
            return this.createResponse(resp);
        }
        catch (MalformedURLException mue) {
            throw new WebApplicationException((Throwable)mue, this.createErrorResponse(mue, 400));
        }
        catch (ProtocolNotSuppException pnse) {
            throw new WebApplicationException((Throwable)pnse, this.createErrorResponse(pnse, 400));
        }
        catch (IOException ioe) {
            throw new WebApplicationException((Throwable)ioe, this.createErrorResponse(ioe, 500));
        }
        catch (ModuleException me) {
            throw new WebApplicationException((Throwable)me, this.createErrorResponse(me, 500));
        }
    }

    @PUT
    public Response doProxyPut(@Context HttpHeaders headers, @Context UriInfo uriInfo, @QueryParam(value="url") String urlParam, InputStream entity) {
        if (urlParam == null) {
            IllegalArgumentException e = new IllegalArgumentException("'url' parameter not found in proxy request");
            throw new WebApplicationException((Throwable)e, this.createErrorResponse(e, 404));
        }
        try {
            URL url = new URL(urlParam);
            HTTPConnection conn = new HTTPConnection(url);
            conn.setTimeout(5000);
            NVPair[] headerPairs = this.toNVPair((MultivaluedMap<String, String>)headers.getRequestHeaders(), Collections.singleton(new CaseInsensitiveStringWrapper("Host")));
            conn.setAllowUserInteraction(false);
            NVPair credentials = this.getCredentials(url);
            if (credentials != null) {
                conn.addBasicAuthorization(null, credentials.getName(), credentials.getValue());
            }
            HTTPResponse resp = null;
            if (entity != null) {
                HttpOutputStream stream = new HttpOutputStream();
                resp = conn.Put(url.getFile(), stream, headerPairs);
                byte[] buf = new byte[1024];
                int r = -1;
                while ((r = entity.read(buf)) != -1) {
                    stream.write(buf, 0, r);
                }
                stream.close();
            } else {
                resp = conn.Put(url.getFile(), new byte[0], headerPairs);
            }
            if (resp.getStatusCode() >= 300 && LOG.isDebugEnabled()) {
                LOG.debug((Object)("PUT. received status " + resp.getStatusCode() + ", " + resp.getReasonLine()));
                byte[] data = resp.getData();
                if (data != null) {
                    LOG.debug((Object)("PUT Received : " + new String(data)));
                }
            }
            return this.createResponse(resp);
        }
        catch (MalformedURLException mue) {
            throw new WebApplicationException((Throwable)mue, this.createErrorResponse(mue, 400));
        }
        catch (ProtocolNotSuppException pnse) {
            throw new WebApplicationException((Throwable)pnse, this.createErrorResponse(pnse, 400));
        }
        catch (IOException ioe) {
            throw new WebApplicationException((Throwable)ioe, this.createErrorResponse(ioe, 500));
        }
        catch (ModuleException me) {
            throw new WebApplicationException((Throwable)me, this.createErrorResponse(me, 500));
        }
    }

    private Response createErrorResponse(Throwable t, int status) {
        return Response.status((int)status).entity((Object)t.getMessage()).type("text/plain").build();
    }

    private Response createResponse(HTTPResponse httpResponse) {
        try {
            Response.ResponseBuilder responseBuilder = Response.status((int)httpResponse.getStatusCode());
            Enumeration en = httpResponse.listHeaders();
            while (en.hasMoreElements()) {
                String headerName = (String)en.nextElement();
                responseBuilder.header(headerName, (Object)httpResponse.getHeader(headerName));
            }
            return responseBuilder.entity((Object)httpResponse.getInputStream()).build();
        }
        catch (IOException e) {
            throw new WebApplicationException((Throwable)e, this.createErrorResponse(e, 500));
        }
        catch (ModuleException me) {
            throw new WebApplicationException((Throwable)me, this.createErrorResponse(me, 400));
        }
    }

    private NVPair getCredentials(URL url) {
        String userInfo = url.getUserInfo();
        NVPair credentials = null;
        if (userInfo != null) {
            int col = userInfo.indexOf(58);
            credentials = col == -1 ? new NVPair(userInfo, "") : (col == userInfo.length() - 1 ? new NVPair(userInfo.substring(0, userInfo.length() - 1), "") : new NVPair(userInfo.substring(0, col), userInfo.substring(col + 1)));
        }
        return credentials;
    }

    private NVPair[] toNVPair(MultivaluedMap<String, String> map, Set<CaseInsensitiveStringWrapper> skip) {
        ArrayList<NVPair> hds = new ArrayList<NVPair>();
        for (Map.Entry e : map.entrySet()) {
            if (skip.contains(new CaseInsensitiveStringWrapper((String)e.getKey()))) continue;
            for (String v : (List)e.getValue()) {
                hds.add(new NVPair((String)e.getKey(), v));
            }
        }
        return hds.toArray(new NVPair[hds.size()]);
    }

    private class CaseInsensitiveStringWrapper {
        private final String string;
        private final String caselessString;

        CaseInsensitiveStringWrapper(String string) {
            this.string = string;
            this.caselessString = string != null ? string.toLowerCase() : null;
        }

        public String toString() {
            return this.string == null ? "null" : this.string;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            CaseInsensitiveStringWrapper other = (CaseInsensitiveStringWrapper)obj;
            return this.caselessString == null && other.caselessString == null || this.caselessString != null && this.caselessString.equals(other.caselessString);
        }

        public int hashCode() {
            return this.caselessString == null ? 0 : this.caselessString.hashCode();
        }
    }
}

