/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.jcr.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionReference
extends WeakReference<Session> {
    private static final int INITIAL_DELAY = 10;
    private static final int DELAY = 15;
    private static ScheduledExecutorService executor;
    private static ConcurrentHashMap<Object, SessionReference> objects;
    private static boolean started;
    private static long maxAgeMillis_;
    private static final Runnable detectorTask;
    private final StackTraceElement[] stack = new Exception().getStackTrace();
    private final Object key = new Object();
    private final long timestamp = System.currentTimeMillis() + maxAgeMillis_;
    volatile boolean closed = false;

    public static synchronized void start(long maxAgeMillis) {
        if (!started) {
            if (maxAgeMillis < 0L) {
                throw new IllegalStateException("Wrong max age value " + maxAgeMillis);
            }
            objects = new ConcurrentHashMap();
            executor = Executors.newSingleThreadScheduledExecutor();
            executor.scheduleWithFixedDelay(detectorTask, 10L, 15L, TimeUnit.SECONDS);
            maxAgeMillis_ = maxAgeMillis;
            started = true;
        }
    }

    public static synchronized boolean isStarted() {
        return started;
    }

    SessionReference(Session referent) {
        super(referent);
        objects.put(this.key, this);
    }

    static {
        started = false;
        detectorTask = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                System.out.println("Starting detector task");
                Class<SessionReference> clazz = SessionReference.class;
                synchronized (SessionReference.class) {
                    ArrayList list = new ArrayList(objects.values());
                    // ** MonitorExit[var2_1] (shouldn't be in output)
                    for (SessionReference ref : list) {
                        if (ref.closed) {
                            objects.remove(ref.key);
                            continue;
                        }
                        Session session = (Session)ref.get();
                        String error = null;
                        if (session == null) {
                            error = "garbagednotclosed";
                        } else if (ref.timestamp < System.currentTimeMillis()) {
                            error = "expired";
                        }
                        if (error == null) continue;
                        objects.remove(ref.key);
                        Exception e = new Exception();
                        e.setStackTrace(ref.stack);
                        System.out.println("<" + error + ">");
                        e.printStackTrace();
                        System.out.println("</" + error + ">");
                    }
                    System.out.println("Finished detector task");
                    return;
                }
            }
        };
    }
}

