/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.xml.exporting;

import java.io.IOException;
import java.util.List;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.value.ValueFactoryImpl;
import org.exoplatform.services.jcr.impl.util.StringConverter;
import org.exoplatform.services.jcr.impl.xml.exporting.StreamExporter;

public class DocumentViewStreamExporter
extends StreamExporter {
    public DocumentViewStreamExporter(XMLStreamWriter writer, ItemDataConsumer dataManager, NamespaceRegistry namespaceRegistry, ValueFactoryImpl systemValueFactory, boolean skipBinary, boolean noRecurse) throws NamespaceException, RepositoryException {
        super(writer, dataManager, namespaceRegistry, systemValueFactory, skipBinary, noRecurse);
    }

    protected void entering(NodeData node, int level) throws RepositoryException {
        try {
            if (!node.getQPath().getName().equals((Object)Constants.JCR_XMLTEXT)) {
                List<NodeData> nodes = this.dataManager.getChildNodesData(node);
                if (nodes.size() > 0) {
                    this.writer.writeStartElement("", this.getExportName(node, true), "");
                } else {
                    this.writer.writeEmptyElement("", this.getExportName(node, true), "");
                }
            }
            if (level == 0) {
                this.startPrefixMapping();
            }
        }
        catch (XMLStreamException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    protected void entering(PropertyData property, int level) throws RepositoryException {
        InternalQName propName = property.getQPath().getName();
        try {
            if (propName.equals((Object)Constants.JCR_XMLCHARACTERS)) {
                this.writer.writeCharacters(new String(property.getValues().get(0).getAsByteArray(), "UTF-8"));
            } else {
                ItemData parentNodeData = this.dataManager.getItemData(property.getParentIdentifier());
                if (parentNodeData.getQPath().getName().equals((Object)Constants.JCR_XMLTEXT)) {
                    return;
                }
                String strValue = "";
                for (ValueData valueData : property.getValues()) {
                    String strVal = this.getValueAsStringForExport(valueData, property.getType());
                    if (strVal == "") continue;
                    strValue = strValue + " " + (property.getType() == 2 ? strVal : StringConverter.normalizeString(strVal, true));
                }
                this.writer.writeAttribute(this.getExportName(property, true), strValue.length() > 0 ? strValue.substring(1) : strValue);
            }
        }
        catch (IllegalStateException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (XMLStreamException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    protected void leaving(NodeData node, int level) throws RepositoryException {
        try {
            List<NodeData> nodes;
            if (!node.getQPath().getName().equals((Object)Constants.JCR_XMLTEXT) && (nodes = this.dataManager.getChildNodesData(node)).size() > 0) {
                this.writer.writeEndElement();
            }
        }
        catch (XMLStreamException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    protected void leaving(PropertyData property, int level) throws RepositoryException {
    }
}

