/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.List;
import net.jcip.annotations.Immutable;
import org.jboss.cache.FqnComparator;
import org.jboss.cache.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class Fqn<E>
implements Comparable<Fqn<?>>,
Externalizable {
    private static final long serialVersionUID = -6901735117605327068L;
    public static final String SEPARATOR = "/";
    protected Object[] elements;
    private transient int hash_code = 0;
    public static final Fqn ROOT = new Fqn();
    protected String stringRepresentation;

    public Fqn() {
        this.elements = new Object[0];
    }

    @Deprecated
    public Fqn(List<? extends E> names) {
        this(names.toArray(), true);
    }

    @Deprecated
    public Fqn(E ... names) {
        this((Object[])names, true);
    }

    @Deprecated
    public Fqn(Fqn<? extends E> base, Fqn<? extends E> relative) {
        this(base, relative.elements);
    }

    @Deprecated
    public Fqn(Fqn<? extends E> base, E ... childNames) {
        this.elements = new Object[base.elements.length + childNames.length];
        System.arraycopy(base.elements, 0, this.elements, 0, base.elements.length);
        System.arraycopy(childNames, 0, this.elements, base.elements.length, childNames.length);
    }

    @Deprecated
    protected Fqn(Object[] names, boolean safe) {
        if (names != null) {
            if (safe) {
                this.elements = names;
            } else {
                this.elements = new Object[names.length];
                System.arraycopy(names, 0, this.elements, 0, names.length);
            }
        } else {
            this.elements = new Object[0];
        }
    }

    public static <T> Fqn<T> fromList(List<? extends T> names) {
        return new Fqn(names.toArray(), true);
    }

    public static <T> Fqn<T> fromList(List<? extends T> names, boolean safe) {
        return new Fqn(names.toArray(), true);
    }

    public static <T> Fqn<T> fromElements(T ... elements) {
        return new Fqn(elements, true);
    }

    public static <T> Fqn<T> fromRelativeFqn(Fqn<? extends T> base, Fqn<? extends T> relative) {
        return new Fqn<Object>(base, relative.elements);
    }

    public static <T> Fqn<T> fromRelativeList(Fqn<? extends T> base, List<? extends T> relativeElements) {
        return new Fqn<Object>(base, relativeElements.toArray());
    }

    public static <T> Fqn<T> fromRelativeElements(Fqn<? extends T> base, T ... relativeElements) {
        return new Fqn<T>(base, relativeElements);
    }

    public static Fqn<String> fromString(String stringRepresentation) {
        if (stringRepresentation == null || stringRepresentation.equals(SEPARATOR) || stringRepresentation.equals("")) {
            return Fqn.root();
        }
        String toMatch = stringRepresentation.startsWith(SEPARATOR) ? stringRepresentation.substring(1) : stringRepresentation;
        Object[] el = toMatch.split(SEPARATOR);
        return new Fqn<String>(el, true);
    }

    public static Fqn<?> fromExternalStream(ObjectInput in) throws IOException, ClassNotFoundException {
        Fqn f = new Fqn();
        f.readExternal(in);
        return f;
    }

    public Fqn<E> getAncestor(int generation) {
        if (generation == 0) {
            return Fqn.root();
        }
        return this.getSubFqn(0, generation);
    }

    public Fqn<E> getSubFqn(int startIndex, int endIndex) {
        if (endIndex < startIndex) {
            throw new IllegalArgumentException("End index cannot be less than start index!");
        }
        int len = endIndex - startIndex;
        Object[] subElements = new Object[len];
        System.arraycopy(this.elements, startIndex, subElements, 0, len);
        return new Fqn<E>(subElements, true);
    }

    public int size() {
        return this.elements.length;
    }

    public Object get(int n) {
        return this.elements[n];
    }

    public Object getLastElement() {
        if (this.isRoot()) {
            return null;
        }
        return this.elements[this.elements.length - 1];
    }

    public boolean hasElement(Object element) {
        return this.indexOf(element) != -1;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Fqn)) {
            return false;
        }
        Fqn other = (Fqn)obj;
        if (this.elements.length != other.elements.length) {
            return false;
        }
        for (int i = this.elements.length - 1; i >= 0; --i) {
            if (Util.safeEquals(this.elements[i], other.elements[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hash_code == 0) {
            this.hash_code = this.calculateHashCode();
        }
        return this.hash_code;
    }

    public String toString() {
        if (this.stringRepresentation == null) {
            this.stringRepresentation = this.getStringRepresentation(this.elements);
        }
        return this.stringRepresentation;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeShort(this.elements.length);
        for (Object element : this.elements) {
            out.writeObject(element);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readShort();
        this.elements = new Object[size];
        for (int i = 0; i < size; ++i) {
            this.elements[i] = in.readObject();
        }
    }

    public boolean isChildOf(Fqn<? super E> parentFqn) {
        return parentFqn.size() != this.elements.length && this.isChildOrEquals(parentFqn);
    }

    public boolean isDirectChildOf(Fqn<? super E> parentFqn) {
        return this.elements.length == parentFqn.size() + 1 && this.isChildOf(parentFqn);
    }

    public boolean isChildOrEquals(Fqn<? super E> parentFqn) {
        Object[] parentElems = parentFqn.elements;
        if (parentElems.length > this.elements.length) {
            return false;
        }
        for (int i = parentElems.length - 1; i >= 0; --i) {
            if (parentElems[i].equals(this.elements[i])) continue;
            return false;
        }
        return true;
    }

    protected int calculateHashCode() {
        int hashCode = 19;
        for (Object o : this.elements) {
            hashCode = 31 * hashCode + (o == null ? 0 : o.hashCode());
        }
        if (hashCode == 0) {
            hashCode = -559038737;
        }
        return hashCode;
    }

    protected String getStringRepresentation(List<E> elements) {
        return this.getStringRepresentation(elements.toArray());
    }

    protected String getStringRepresentation(Object[] elements) {
        StringBuilder builder = new StringBuilder();
        for (Object e : elements) {
            if (SEPARATOR.equals(e) || "".equals(e)) continue;
            builder.append(SEPARATOR);
            builder.append(e);
        }
        return builder.length() == 0 ? SEPARATOR : builder.toString();
    }

    public Fqn<E> getParent() {
        switch (this.elements.length) {
            case 0: 
            case 1: {
                return Fqn.root();
            }
        }
        return this.getSubFqn(0, this.elements.length - 1);
    }

    public static final <T> Fqn<T> root() {
        return ROOT;
    }

    public boolean isRoot() {
        return this.elements.length == 0;
    }

    public String getLastElementAsString() {
        if (this.isRoot()) {
            return SEPARATOR;
        }
        Object last = this.getLastElement();
        if (last instanceof String) {
            return (String)last;
        }
        return String.valueOf(this.getLastElement());
    }

    public List<E> peekElements() {
        return Arrays.asList(this.elements);
    }

    private int indexOf(Object o) {
        if (o == null) {
            for (int i = 0; i < this.elements.length; ++i) {
                if (this.elements[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.elements.length; ++i) {
                if (!o.equals(this.elements[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int compareTo(Fqn<?> fqn) {
        return FqnComparator.INSTANCE.compare(this, fqn);
    }

    public Fqn<E> replaceAncestor(Fqn<E> oldAncestor, Fqn<E> newAncestor) {
        if (!this.isChildOf(oldAncestor)) {
            throw new IllegalArgumentException("Old ancestor must be an ancestor of the current Fqn!");
        }
        Fqn<E> subFqn = this.getSubFqn(oldAncestor.size(), this.size());
        return Fqn.fromRelativeFqn(newAncestor, subFqn);
    }
}

