/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.mvcc;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.DataContainer;
import org.jboss.cache.Fqn;
import org.jboss.cache.InternalNode;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.mvcc.ReadCommittedNode;
import org.jboss.cache.optimistic.DataVersioningException;

public class RepeatableReadNode
extends ReadCommittedNode {
    private static final Log log = LogFactory.getLog(RepeatableReadNode.class);

    public RepeatableReadNode(InternalNode node, InternalNode parent) {
        super(node, parent);
    }

    public void markForUpdate(DataContainer container, boolean writeSkewCheck) {
        InternalNode underlyingNode;
        if (this.isFlagSet(ReadCommittedNode.Flags.CHANGED)) {
            return;
        }
        Fqn fqn = this.getFqn();
        this.setFlag(ReadCommittedNode.Flags.CHANGED);
        if (writeSkewCheck && (underlyingNode = container.peekInternalNode(fqn, true)) != null && underlyingNode != this.node) {
            String errormsg = "Detected write skew on Fqn [" + fqn + "].  Another process has changed the node since we last read it!";
            if (log.isWarnEnabled()) {
                log.warn((Object)(errormsg + ".  Unable to copy node for update."));
            }
            throw new DataVersioningException(errormsg);
        }
        this.backup = this.node;
        this.node = this.copyNode(this.backup);
    }

    private InternalNode copyNode(InternalNode nodeToCopy) {
        return nodeToCopy == null ? null : nodeToCopy.copy();
    }

    protected void updateNode(Fqn fqn, InvocationContext ctx, DataContainer dataContainer) {
        if (fqn.isRoot()) {
            dataContainer.setRoot(this.node);
        } else if (!this.isFlagSet(ReadCommittedNode.Flags.DELETED)) {
            InternalNode parent = this.lookupParent(fqn, ctx, dataContainer);
            parent.addChild(this.node, true);
        }
    }
}

