/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.svc.save;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.context.exe.VariableContainer;
import org.jbpm.context.exe.VariableInstance;
import org.jbpm.context.exe.variableinstance.UnpersistableInstance;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.svc.save.SaveOperation;

public class CheckUnpersistableVariablesOperation
implements SaveOperation {
    private static final long serialVersionUID = 1L;

    public void save(ProcessInstance processInstance, JbpmContext jbpmContext) {
        Collection updatedVariableContainers = VariableContainer.getUpdatedVariableContainers(processInstance);
        if (updatedVariableContainers != null) {
            Iterator iter = updatedVariableContainers.iterator();
            while (iter.hasNext()) {
                VariableContainer variableContainer = (VariableContainer)iter.next();
                Map variableInstances = variableContainer.getVariableInstances();
                if (variableInstances == null) continue;
                Iterator varInstancesIter = variableInstances.entrySet().iterator();
                while (varInstancesIter.hasNext()) {
                    Map.Entry entry = varInstancesIter.next();
                    String name = (String)entry.getKey();
                    VariableInstance variableInstance = (VariableInstance)entry.getValue();
                    if (!(variableInstance instanceof UnpersistableInstance)) continue;
                    Object value = variableInstance.getValue();
                    if (value != null) {
                        throw new JbpmException("variable '" + name + "' in '" + variableContainer + "' contains '" + value + "': type '" + value.getClass().getName() + "' is unpersistable according to the jbpm.varmapping.xml configuration");
                    }
                    throw new JbpmException("variable '" + name + "' in '" + variableContainer + "' was created with a non persistable value");
                }
            }
        }
    }
}

