/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.TreeSet;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.protocols.TransportedVectorTime;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Streamable;

public class CAUSAL
extends Protocol {
    private final Object lock = new Object();
    private Address localAddress;
    private final LinkedList upwardWaitingQueue = new LinkedList();
    private final LinkedList downwardWaitingQueue = new LinkedList();
    private boolean enabled = false;
    private ActiveCausalView currentView;
    private NewViewThread newViewThread;
    private boolean debug = false;

    public boolean setProperties(Properties props) {
        if (!super.setProperties(props)) {
            return false;
        }
        String s = props.getProperty("debug");
        this.debug = "debug".equalsIgnoreCase(s);
        return true;
    }

    private void addToDelayQueue(TransportedVectorTime tvt) {
        ListIterator i = this.upwardWaitingQueue.listIterator(0);
        TransportedVectorTime current = null;
        while (i.hasNext()) {
            current = (TransportedVectorTime)i.next();
            if (!tvt.lessThanOrEqual(current)) continue;
            this.upwardWaitingQueue.add(i.previousIndex(), tvt);
            return;
        }
        this.upwardWaitingQueue.add(tvt);
    }

    private void disable() {
        this.enabled = false;
    }

    private boolean isEnabled() {
        return this.enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object down(Event evt) {
        try {
            if (evt.getType() != 1) {
                return this.down_prot.down(evt);
            }
            Message msg = (Message)evt.getArg();
            if (msg.getDest() != null && !msg.getDest().isMulticastAddress()) {
                return this.down_prot.down(evt);
            }
            TransportedVectorTime tvt = null;
            Object object = this.lock;
            synchronized (object) {
                if (this.isEnabled()) {
                    this.currentView.increment();
                    tvt = this.currentView.getTransportedVectorTime();
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("Sent 1 down message @ " + this.currentView.timeVectorString()));
                    }
                } else {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)"Enqueued 1 down message...");
                    }
                    this.downwardWaitingQueue.add(evt);
                }
            }
            if (tvt != null) {
                msg.putHeader(this.getName(), new CausalHeader(tvt));
                return this.down_prot.down(evt);
            }
        }
        catch (RuntimeException e) {
            if (this.debug) {
                this.log.error((Object)("*** down: " + e.getMessage()), (Throwable)e);
            }
            throw e;
        }
        return null;
    }

    public Object up(Event evt) {
        try {
            switch (evt.getType()) {
                case 8: {
                    this.upSetLocalAddress(evt);
                    break;
                }
                case 6: {
                    this.upViewChange(evt);
                    break;
                }
                case 1: {
                    return this.upMsg(evt);
                }
                default: {
                    return this.up_prot.up(evt);
                }
            }
        }
        catch (RuntimeException e) {
            if (this.debug) {
                this.log.error((Object)("*** up: " + e.getMessage()), (Throwable)e);
            }
            throw e;
        }
        return null;
    }

    private void upSetLocalAddress(Event evt) {
        this.localAddress = (Address)evt.getArg();
        this.up_prot.up(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upViewChange(Event evt) {
        View view = (View)evt.getArg();
        InternalView iView = new InternalView(view.getVid(), view.getMembers(), this.localAddress);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("New view: " + view));
        }
        Object object = this.lock;
        synchronized (object) {
            this.disable();
            NewCausalView newView = new NewCausalView(this.currentView, iView);
            if (this.currentView != null) {
                this.currentView.clearFinalTimeVector();
                newView.setMemberLocalTime(this.localAddress, this.currentView.getLocalTime());
            } else {
                newView.setMemberLocalTime(this.localAddress, 0);
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Starting synchronization thread for " + newView));
            }
            this.newViewThread = new NewViewThread(newView);
            this.newViewThread.start();
        }
        this.up_prot.up(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object upMsg(Event evt) {
        Message msg = (Message)evt.getArg();
        Address src = msg.getSrc();
        Header obj = msg.getHeader("CAUSAL_NEWVIEW_HEADER");
        if (obj instanceof CausalNewViewHeader) {
            this.processNewViewSynchronization(src, (CausalNewViewHeader)obj, msg.getObject());
            return null;
        }
        obj = msg.getHeader(this.getName());
        if (!(obj instanceof CausalHeader)) {
            if ((msg.getDest() == null || msg.getDest().isMulticastAddress()) && this.log.isErrorEnabled()) {
                this.log.error((Object)"NO CAUSAL.Header found");
            }
            return this.up_prot.up(evt);
        }
        TransportedVectorTime messageVector = ((CausalHeader)obj).getVectorTime();
        Object object = this.lock;
        synchronized (object) {
            if (this.currentView == null || this.currentView.getView().getIndex(src) < 0) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Discarding " + obj + " from " + msg.getSrc()));
                }
                return null;
            }
            if (this.currentView.isCausallyNext(messageVector)) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("passing up message " + msg + ", headers are " + msg.printHeaders() + ", local vector is " + this.currentView.timeVectorString()));
                }
                this.up_prot.up(evt);
                this.currentView.max(messageVector);
            } else {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("queuing message " + msg + ", headers are " + msg.printHeaders()));
                }
                messageVector.setAssociatedMessage(msg);
                this.addToDelayQueue(messageVector);
            }
            TransportedVectorTime queuedVector = null;
            while (!this.upwardWaitingQueue.isEmpty() && this.currentView.isCausallyNext(queuedVector = (TransportedVectorTime)this.upwardWaitingQueue.getFirst())) {
                this.upwardWaitingQueue.remove(queuedVector);
                Message tmp = queuedVector.getAssociatedMessage();
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("released message " + tmp + ", headers are " + tmp.printHeaders()));
                }
                this.up_prot.up(new Event(1, tmp));
                this.currentView.max(queuedVector);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processNewViewSynchronization(Address src, CausalNewViewHeader header, Object object) {
        if (this.localAddress.equals(src)) {
            return;
        }
        MissingIndexesMessage content = (MissingIndexesMessage)object;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Got sync update from " + src));
        }
        Object object2 = this.lock;
        synchronized (object2) {
            if (this.newViewThread == null) {
                if (this.currentView != null && this.currentView.getView().getViewId().equals(header.newViewId)) {
                    int localIndex = this.currentView.getLocalIndex();
                    if (Arrays.binarySearch(content.getMissingCompletionIndexes(), localIndex) >= 0) {
                        Message update = new Message(null, this.localAddress, null);
                        update.putHeader("CAUSAL_NEWVIEW_HEADER", new CausalNewViewHeader(this.currentView.getView().getViewId(), 0, true));
                        update.setObject(new MissingIndexesMessage(Collections.EMPTY_LIST, Collections.EMPTY_LIST));
                        this.down_prot.down(new Event(1, update));
                    }
                    if (Arrays.binarySearch(content.getMissingTimeIndexes(), localIndex) < 0) return;
                }
                this.disable();
                // empty if block
                return;
            }
            if (!this.newViewThread.getCausalView().getViewId().equals(header.newViewId)) {
                return;
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("From " + src + ": " + header));
            }
            this.newViewThread.getCausalView().setMemberLocalTime(src, header.localTime);
            if (header.isComplete()) {
                this.newViewThread.getCausalView().setMemberCompleted(src);
            }
            int localIndex = this.newViewThread.getCausalView().getLocalIndex();
            if (Arrays.binarySearch(content.getMissingTimeIndexes(), localIndex) < 0 && Arrays.binarySearch(content.getMissingCompletionIndexes(), localIndex) < 0) return;
            this.newViewThread.updateRequested();
            return;
        }
    }

    public String getName() {
        return "CAUSAL";
    }

    private final class NewViewThread
    extends Thread {
        private final NewCausalView newView;
        private boolean updateRequested;

        NewViewThread(NewCausalView newView) {
            super(newView.getViewId().toString());
            this.updateRequested = false;
            this.newView = newView;
            this.setDaemon(true);
        }

        NewCausalView getCausalView() {
            return this.newView;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean sendUpdate = false;
            boolean complete = false;
            LinkedList flush = null;
            while (true) {
                Message update = null;
                Object object = CAUSAL.this.lock;
                synchronized (object) {
                    if (this != CAUSAL.this.newViewThread) {
                        break;
                    }
                    if (this.newView.hasMissingTimes()) {
                        sendUpdate = true;
                    } else if (CAUSAL.this.currentView == null || !CAUSAL.this.currentView.getViewId().equals(this.newView.getViewId()) && CAUSAL.this.currentView.hasEnded()) {
                        CAUSAL.this.currentView = new ActiveCausalView(this.newView.getView(), this.newView.timeVector);
                        complete = true;
                        this.newView.setMemberCompleted(CAUSAL.this.localAddress);
                        if (CAUSAL.this.log.isTraceEnabled()) {
                            CAUSAL.this.log.trace((Object)("Set up new active view: " + CAUSAL.this.currentView + " @ " + CAUSAL.this.currentView.timeVectorString()));
                        }
                    }
                    if (!this.newView.hasMissingCompletions()) {
                        CAUSAL.this.newViewThread = null;
                        CAUSAL.this.enabled = true;
                        flush = (LinkedList)CAUSAL.this.downwardWaitingQueue.clone();
                        CAUSAL.this.downwardWaitingQueue.clear();
                        if (CAUSAL.this.log.isTraceEnabled()) {
                            CAUSAL.this.log.trace((Object)("Done synchronizing, enabled view: " + CAUSAL.this.currentView + " @ " + CAUSAL.this.currentView.timeVectorString()));
                        }
                        break;
                    }
                    sendUpdate = true;
                    if (sendUpdate) {
                        update = new Message(null, CAUSAL.this.localAddress, null);
                        update.putHeader("CAUSAL_NEWVIEW_HEADER", new CausalNewViewHeader(this.newView.getViewId(), this.newView.getLocalTime(), complete));
                        update.setObject(new MissingIndexesMessage(this.newView.getMissingTimes(), this.newView.getMissingCompletions()));
                    }
                }
                if (update != null) {
                    if (CAUSAL.this.log.isTraceEnabled()) {
                        CAUSAL.this.log.trace((Object)"Sending sync update");
                    }
                    CAUSAL.this.down_prot.down(new Event(1, update));
                }
                object = this;
                synchronized (object) {
                    try {
                        this.wait(500L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        CAUSAL.this.log.warn((Object)"Interrupted?!?", (Throwable)e);
                    }
                    sendUpdate = this.updateRequested;
                    this.updateRequested = false;
                }
            }
            if (flush != null) {
                int n = flush.size();
                if (CAUSAL.this.log.isDebugEnabled()) {
                    CAUSAL.this.log.debug((Object)("Flushing " + n + " messages down..."));
                }
                while (!flush.isEmpty()) {
                    Event evt = (Event)flush.removeFirst();
                    CAUSAL.this.down(evt);
                }
                if (CAUSAL.this.log.isDebugEnabled()) {
                    CAUSAL.this.log.debug((Object)("Done flushing " + n + " messages down..."));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void updateRequested() {
            NewViewThread newViewThread = this;
            synchronized (newViewThread) {
                this.updateRequested = true;
            }
        }
    }

    private final class ActiveCausalView {
        private final InternalView view;
        private final int[] timeVector;
        private int[] finalTimeVector;

        ActiveCausalView(InternalView view, int[] initialTimeVector) {
            this.view = view;
            this.timeVector = initialTimeVector;
            this.finalTimeVector = null;
            if (view.getLocalIndex() >= initialTimeVector.length) {
                throw new IllegalStateException("View: " + view + " timevector.length=" + initialTimeVector.length);
            }
        }

        public InternalView getView() {
            return this.view;
        }

        public ViewId getViewId() {
            return this.view.getViewId();
        }

        public int getLocalIndex() {
            return this.view.getLocalIndex();
        }

        public synchronized int getLocalTime() {
            return this.timeVector[this.view.getLocalIndex()];
        }

        public synchronized void increment() {
            int n = this.view.getLocalIndex();
            this.timeVector[n] = this.timeVector[n] + 1;
        }

        public synchronized TransportedVectorTime getTransportedVectorTime() {
            int[] tmpTimeVector = new int[this.timeVector.length];
            System.arraycopy(this.timeVector, 0, tmpTimeVector, 0, tmpTimeVector.length);
            return new TransportedVectorTime(this.view.getLocalIndex(), tmpTimeVector);
        }

        public synchronized boolean isCausallyNext(TransportedVectorTime vector) {
            int senderIndex = vector.getSenderIndex();
            if (senderIndex == this.view.getLocalIndex()) {
                return true;
            }
            int[] otherTimeVector = vector.getValues();
            if (otherTimeVector.length != this.timeVector.length) {
                if (CAUSAL.this.log.isWarnEnabled()) {
                    CAUSAL.this.log.warn((Object)("isCausallyNext: got message with wrong time vector length: " + otherTimeVector.length + ", expected: " + this.timeVector.length));
                }
                return true;
            }
            boolean nextCausalFromSender = false;
            boolean nextCausal = true;
            for (int i = 0; i < this.timeVector.length; ++i) {
                if (i == senderIndex && otherTimeVector[i] == this.timeVector[i] + 1) {
                    nextCausalFromSender = true;
                    continue;
                }
                if (i == this.view.getLocalIndex() || otherTimeVector[i] <= this.timeVector[i]) continue;
                nextCausal = false;
            }
            return nextCausalFromSender && nextCausal;
        }

        public synchronized void max(TransportedVectorTime vector) {
            int[] otherTimeVector = vector.getValues();
            if (otherTimeVector.length != this.timeVector.length) {
                if (CAUSAL.this.log.isWarnEnabled()) {
                    CAUSAL.this.log.warn((Object)("max: got message with wrong time vector length: " + otherTimeVector.length + ", expected: " + this.timeVector.length));
                }
                return;
            }
            for (int i = 0; i < this.timeVector.length; ++i) {
                if (otherTimeVector[i] <= this.timeVector[i]) continue;
                this.timeVector[i] = otherTimeVector[i];
            }
        }

        public synchronized void setFinalTimeVector(InternalView newView, int[] startTimeVector) {
            this.finalTimeVector = new int[this.timeVector.length];
            System.arraycopy(this.timeVector, 0, this.finalTimeVector, 0, this.timeVector.length);
            for (int i = 0; i < this.view.size(); ++i) {
                Address member = this.view.getMember(i);
                int startIndex = newView.getIndex(member);
                if (startIndex < 0) continue;
                this.finalTimeVector[i] = startTimeVector[startIndex];
            }
            if (CAUSAL.this.log.isTraceEnabled()) {
                CAUSAL.this.log.trace((Object)(this + ": final vector time set @ " + this.timeVectorString()));
            }
        }

        public synchronized void clearFinalTimeVector() {
            this.finalTimeVector = null;
        }

        public synchronized boolean hasEnded() {
            if (this.finalTimeVector == null) {
                return false;
            }
            for (int i = 0; i < this.timeVector.length; ++i) {
                if (this.timeVector[i] >= this.finalTimeVector[i]) continue;
                return false;
            }
            return true;
        }

        public synchronized String timeVectorString() {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.timeVector.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.timeVector[i]);
            }
            return sb.toString();
        }

        public String toString() {
            return "ActiveCausalView[" + this.view + ']';
        }
    }

    private final class NewCausalView {
        private final ActiveCausalView active;
        private final InternalView view;
        private final int[] timeVector;
        private final TreeSet missingTimes = new TreeSet();
        private final TreeSet missingCompletions = new TreeSet();

        public NewCausalView(ActiveCausalView active, InternalView view) {
            this.active = active;
            this.view = view;
            this.timeVector = new int[view.size()];
            if (view.getLocalIndex() >= this.timeVector.length) {
                throw new IllegalStateException("View: " + view + " timevector.length=" + this.timeVector.length);
            }
            for (int i = 0; i < view.size(); ++i) {
                Integer index = new Integer(i);
                this.missingTimes.add(index);
                this.missingCompletions.add(index);
            }
        }

        public InternalView getView() {
            return this.view;
        }

        public ViewId getViewId() {
            return this.view.getViewId();
        }

        public int getLocalIndex() {
            return this.view.getLocalIndex();
        }

        public synchronized int getLocalTime() {
            return this.timeVector[this.view.getLocalIndex()];
        }

        public synchronized void setMemberLocalTime(Address address, int time) {
            if (this.missingTimes.isEmpty()) {
                return;
            }
            int index = this.view.getIndex(address);
            if (index < 0) {
                return;
            }
            this.timeVector[index] = time;
            this.missingTimes.remove(new Integer(index));
            if (this.missingTimes.isEmpty()) {
                if (this.active != null) {
                    this.active.setFinalTimeVector(this.view, this.timeVector);
                }
                if (CAUSAL.this.log.isTraceEnabled()) {
                    CAUSAL.this.log.trace((Object)(this + " has all the times"));
                }
            } else if (CAUSAL.this.log.isTraceEnabled()) {
                CAUSAL.this.log.trace((Object)(this + " missing times: " + this.missingTimes));
            }
        }

        public synchronized void setMemberCompleted(Address address) {
            if (this.missingCompletions.isEmpty()) {
                return;
            }
            int index = this.view.getIndex(address);
            if (index < 0) {
                return;
            }
            this.missingCompletions.remove(new Integer(index));
            if (this.missingCompletions.isEmpty()) {
                if (CAUSAL.this.log.isTraceEnabled()) {
                    CAUSAL.this.log.trace((Object)(this + " has all the completions"));
                }
            } else if (CAUSAL.this.log.isTraceEnabled()) {
                CAUSAL.this.log.trace((Object)(this + " missing completions: " + this.missingCompletions));
            }
        }

        public synchronized boolean hasMissingTimes() {
            return !this.missingTimes.isEmpty();
        }

        public synchronized Collection getMissingTimes() {
            return this.missingTimes;
        }

        public synchronized boolean hasMissingCompletions() {
            return !this.missingCompletions.isEmpty();
        }

        public synchronized Collection getMissingCompletions() {
            return this.missingCompletions;
        }

        public String toString() {
            return "NewCausalView[" + this.view + ']';
        }
    }

    private static final class InternalView {
        private final ViewId viewId;
        private final Address[] members;
        private final int localIndex;

        InternalView(ViewId viewId, List viewMembers, Address localAddress) {
            this.viewId = viewId;
            this.members = new Address[viewMembers.size()];
            for (int i = 0; i < viewMembers.size(); ++i) {
                this.members[i] = (Address)viewMembers.get(i);
            }
            Arrays.sort(this.members);
            int tmpLocalIndex = -1;
            for (int i = 0; i < this.members.length; ++i) {
                Address member = this.members[i];
                if (!localAddress.equals(member)) continue;
                tmpLocalIndex = i;
            }
            if (tmpLocalIndex == -1) {
                throw new IllegalStateException("view does not contain the local address");
            }
            this.localIndex = tmpLocalIndex;
        }

        public ViewId getViewId() {
            return this.viewId;
        }

        public int getIndex(Address member) {
            return Arrays.binarySearch(this.members, member);
        }

        public Address getMember(int index) {
            return this.members[index];
        }

        public int getLocalIndex() {
            return this.localIndex;
        }

        public int size() {
            return this.members.length;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.viewId).append("; ").append(this.members.length).append(" members: ");
            for (int i = 0; i < this.members.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(i).append(':').append(this.members[i]);
            }
            sb.append(" - local is ").append(this.localIndex);
            return sb.toString();
        }
    }

    public static final class MissingIndexesMessage
    implements Externalizable,
    Streamable {
        private static final long serialVersionUID = 3257007644266213432L;
        private int[] missingTimeIndexes;
        private int[] missingCompletionIndexes;

        public MissingIndexesMessage(Collection missingLocalTimes, Collection missingCompletions) {
            this.missingTimeIndexes = new int[missingLocalTimes.size()];
            int i = 0;
            Iterator it = missingLocalTimes.iterator();
            while (it.hasNext()) {
                this.missingTimeIndexes[i++] = (Integer)it.next();
            }
            this.missingCompletionIndexes = new int[missingCompletions.size()];
            i = 0;
            it = missingCompletions.iterator();
            while (it.hasNext()) {
                this.missingCompletionIndexes[i++] = (Integer)it.next();
            }
        }

        public MissingIndexesMessage() {
        }

        public int[] getMissingTimeIndexes() {
            return this.missingTimeIndexes;
        }

        public int[] getMissingCompletionIndexes() {
            return this.missingCompletionIndexes;
        }

        private static void writeIntArray(DataOutput out, int[] array) throws IOException {
            out.writeInt(array.length);
            for (int i = 0; i < array.length; ++i) {
                out.writeInt(array[i]);
            }
        }

        private static int[] readIntArray(DataInput in) throws IOException {
            int length = in.readInt();
            if (length < 0) {
                throw new IOException("array length is < 0: " + length);
            }
            int[] array = new int[length];
            for (int i = 0; i < array.length; ++i) {
                array[i] = in.readInt();
            }
            return array;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            MissingIndexesMessage.writeIntArray(out, this.missingTimeIndexes);
            MissingIndexesMessage.writeIntArray(out, this.missingCompletionIndexes);
        }

        public void readExternal(ObjectInput in) throws IOException {
            this.missingTimeIndexes = MissingIndexesMessage.readIntArray(in);
            this.missingCompletionIndexes = MissingIndexesMessage.readIntArray(in);
        }

        public void writeTo(DataOutputStream out) throws IOException {
            MissingIndexesMessage.writeIntArray(out, this.missingTimeIndexes);
            MissingIndexesMessage.writeIntArray(out, this.missingCompletionIndexes);
        }

        public void readFrom(DataInputStream in) throws IOException {
            this.missingTimeIndexes = MissingIndexesMessage.readIntArray(in);
            this.missingCompletionIndexes = MissingIndexesMessage.readIntArray(in);
        }

        public String toString() {
            int[] missingLocalTimes = this.missingTimeIndexes;
            int[] tmpMissingCompletionIndexes = this.missingCompletionIndexes;
            StringBuilder sb = new StringBuilder("MissingIndexes[");
            if (missingLocalTimes == null) {
                sb.append("? missing times - not deserialized, ");
            } else {
                sb.append(missingLocalTimes.length).append(" times missing, ");
            }
            if (tmpMissingCompletionIndexes == null) {
                sb.append("? missing completions - not deserialized]");
            } else {
                sb.append(tmpMissingCompletionIndexes.length).append(" completions missing]");
            }
            return sb.toString();
        }
    }

    public static final class CausalNewViewHeader
    extends Header
    implements Streamable {
        private static final long serialVersionUID = 3257569486185183289L;
        public static final String NAME = "CAUSAL_NEWVIEW_HEADER";
        private ViewId newViewId;
        private int localTime;
        private boolean complete;

        public CausalNewViewHeader(ViewId newViewId, int localTime, boolean complete) {
            this.newViewId = newViewId;
            this.localTime = localTime;
            this.complete = complete;
        }

        public CausalNewViewHeader() {
        }

        public ViewId getNewViewId() {
            return this.newViewId;
        }

        public int getLocalTime() {
            return this.localTime;
        }

        public boolean isComplete() {
            return this.complete;
        }

        public int size() {
            return 231;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.newViewId);
            out.writeInt(this.localTime);
            out.writeBoolean(this.complete);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.newViewId = (ViewId)in.readObject();
            this.localTime = in.readInt();
            this.complete = in.readBoolean();
        }

        public void writeTo(DataOutputStream out) throws IOException {
            this.newViewId.writeTo(out);
            out.writeInt(this.localTime);
            out.writeBoolean(this.complete);
        }

        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.newViewId = new ViewId();
            this.newViewId.readFrom(in);
            this.localTime = in.readInt();
            this.complete = in.readBoolean();
        }

        public String toString() {
            return "[CAUSAL_NEWVIEW_HEADER:" + this.newViewId + "; @" + this.localTime + (this.complete ? "; complete]" : "; incomplete]");
        }
    }

    public static final class CausalHeader
    extends Header
    implements Streamable {
        private static final long serialVersionUID = 3760846744526927667L;
        private TransportedVectorTime t = null;

        public CausalHeader() {
        }

        public CausalHeader(TransportedVectorTime timeVector) {
            this.t = timeVector;
        }

        public TransportedVectorTime getVectorTime() {
            return this.t;
        }

        public int size() {
            int retval = 1;
            if (this.t == null) {
                return retval;
            }
            retval += this.t.senderPosition;
            if (this.t.values != null) {
                retval += this.t.values.length * 4;
            }
            return retval;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.t);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.t = (TransportedVectorTime)in.readObject();
        }

        public void writeTo(DataOutputStream out) throws IOException {
            if (this.t == null) {
                out.writeBoolean(false);
                return;
            }
            out.writeBoolean(true);
            out.writeInt(this.t.senderPosition);
            int[] values = this.t.values;
            int len = values.length;
            out.writeInt(len);
            for (int i = 0; i < len; ++i) {
                out.writeInt(values[i]);
            }
        }

        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            if (!in.readBoolean()) {
                return;
            }
            this.t = new TransportedVectorTime();
            this.t.senderPosition = in.readInt();
            int len = in.readInt();
            if (this.t.senderPosition < 0 || len < 0 || this.t.senderPosition >= len) {
                throw new InstantiationException("sender position=" + this.t.senderPosition + ", values length=" + len);
            }
            this.t.values = new int[len];
            for (int i = 0; i < len; ++i) {
                this.t.values[i] = in.readInt();
            }
        }

        public String toString() {
            return "[CAUSALHEADER:" + this.t + ']';
        }
    }
}

