/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.LinkedList;
import junit.framework.TestCase;
import org.jgroups.util.PortsManager;
import org.jgroups.util.Util;

public class PortManagerTest
extends TestCase {
    PortsManager pm;
    static final int START_PORT = 15550;

    protected void setUp() throws Exception {
        super.setUp();
        this.pm = new PortsManager();
        this.pm.deleteFile();
    }

    protected void tearDown() throws Exception {
        this.pm = new PortsManager();
        this.pm.deleteFile();
        super.tearDown();
    }

    public void testAddition() {
        this.pm = new PortsManager(30000L);
        LinkedList<Integer> ports = new LinkedList<Integer>();
        for (int i = 0; i < 10; ++i) {
            int port = this.pm.getNextAvailablePort(15550);
            PortManagerTest.assertTrue((port > 0 ? 1 : 0) != 0);
            ports.add(port);
        }
        System.out.println("ports: " + ports);
        PortManagerTest.assertEquals((int)10, (int)ports.size());
    }

    public void testNonDuplicateAddition() {
        this.pm = new PortsManager(30000L);
        int port = this.pm.getNextAvailablePort(15550);
        System.out.println("port=" + port);
        PortManagerTest.assertEquals((int)15550, (int)port);
        int port2 = this.pm.getNextAvailablePort(15550);
        System.out.println("port2 = " + port2);
        PortManagerTest.assertNotSame((Object)port, (Object)port2);
    }

    public void testExpiration() {
        this.pm = new PortsManager(800L);
        int port = this.pm.getNextAvailablePort(15550);
        System.out.println("port = " + port);
        Util.sleep(900L);
        int port2 = this.pm.getNextAvailablePort(15550);
        System.out.println("port2 = " + port2);
        PortManagerTest.assertEquals((int)port, (int)port2);
        Util.sleep(900L);
        port = this.pm.getNextAvailablePort(15550);
        port2 = this.pm.getNextAvailablePort(15550);
        System.out.println("port=" + port + ", port2=" + port2);
        PortManagerTest.assertNotSame((Object)port, (Object)port2);
    }

    public void testRemove() {
        int port;
        this.pm = new PortsManager(10000L);
        int old_port = port = this.pm.getNextAvailablePort(15550);
        System.out.println("port = " + port);
        PortManagerTest.assertEquals((int)15550, (int)port);
        int port2 = this.pm.getNextAvailablePort(15550);
        System.out.println("port2 = " + port2);
        PortManagerTest.assertNotSame((Object)port, (Object)port2);
        this.pm.removePort(port);
        port2 = this.pm.getNextAvailablePort(15550);
        System.out.println("port2 = " + port2);
        PortManagerTest.assertEquals((int)port, (int)port2);
        this.pm.removePort(port);
        this.pm.removePort(port2);
        port = this.pm.getNextAvailablePort(15550);
        System.out.println("port = " + port);
        PortManagerTest.assertEquals((int)old_port, (int)port);
    }
}

