/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.search.model.constraint;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Operator {
    EQUAL_TO("="),
    GREATER_THAN(">"),
    GREATER_THAN_OR_EQUAL_TO(">="),
    LESS_THAN("<"),
    LESS_THAN_OR_EQUAL_TO("<="),
    LIKE("LIKE"),
    NOT_EQUAL_TO("!=");

    private static final Map<String, Operator> OPERATORS_BY_SYMBOL;
    public static final Operator[] ALL;
    private final String symbol;

    private Operator(String symbol) {
        this.symbol = symbol;
    }

    public Operator getReverse() {
        switch (this) {
            case GREATER_THAN: {
                return LESS_THAN;
            }
            case GREATER_THAN_OR_EQUAL_TO: {
                return LESS_THAN_OR_EQUAL_TO;
            }
            case LESS_THAN: {
                return GREATER_THAN;
            }
            case LESS_THAN_OR_EQUAL_TO: {
                return GREATER_THAN_OR_EQUAL_TO;
            }
        }
        return this;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public boolean isRangeOperator() {
        switch (this) {
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL_TO: 
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL_TO: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.symbol;
    }

    public static Operator forSymbol(String symbol) {
        return OPERATORS_BY_SYMBOL.get(symbol.toUpperCase());
    }

    static {
        ALL = new Operator[]{EQUAL_TO, GREATER_THAN, GREATER_THAN_OR_EQUAL_TO, LESS_THAN, LESS_THAN_OR_EQUAL_TO, LIKE, NOT_EQUAL_TO};
        HashMap<String, Operator> opsBySymbol = new HashMap<String, Operator>();
        for (Operator operator : Operator.values()) {
            opsBySymbol.put(operator.getSymbol().toUpperCase(), operator);
        }
        opsBySymbol.put("<>", NOT_EQUAL_TO);
        OPERATORS_BY_SYMBOL = Collections.unmodifiableMap(opsBySymbol);
    }
}

