/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.ldap;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.exoplatform.services.ldap.LDAPService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.MembershipTypeHandler;
import org.exoplatform.services.organization.impl.MembershipTypeImpl;
import org.exoplatform.services.organization.ldap.BaseDAO;
import org.exoplatform.services.organization.ldap.LDAPAttributeMapping;

public class MembershipTypeDAOImpl
extends BaseDAO
implements MembershipTypeHandler {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.core.component.organization.ldap.MembershipTypeDAOImpl");

    public MembershipTypeDAOImpl(LDAPAttributeMapping ldapAttrMapping, LDAPService ldapService) throws Exception {
        super(ldapAttrMapping, ldapService);
    }

    public final MembershipType createMembershipTypeInstance() {
        return new MembershipTypeImpl();
    }

    public MembershipType createMembershipType(MembershipType mt, boolean broadcast) throws Exception {
        String membershipTypeDN = this.ldapAttrMapping.membershipTypeNameAttr + "=" + mt.getName() + "," + this.ldapAttrMapping.membershipTypeURL;
        LdapContext ctx = this.ldapService.getLdapContext();
        try {
            int err = 0;
            while (true) {
                try {
                    try {
                        ctx.lookup(membershipTypeDN);
                    }
                    catch (NameNotFoundException e) {
                        Date now = new Date();
                        mt.setCreatedDate(now);
                        mt.setModifiedDate(now);
                        ctx.createSubcontext(membershipTypeDN, this.ldapAttrMapping.membershipTypeToAttributes(mt));
                    }
                    MembershipType e = mt;
                    return e;
                }
                catch (NamingException e1) {
                    if (!MembershipTypeDAOImpl.isConnectionError(e1) || err >= MembershipTypeDAOImpl.getMaxConnectionError()) {
                        throw e1;
                    }
                    ctx = this.ldapService.getLdapContext(true);
                    ++err;
                    continue;
                }
                break;
            }
        }
        finally {
            this.ldapService.release(ctx);
        }
    }

    public MembershipType saveMembershipType(MembershipType mt, boolean broadcast) throws Exception {
        String membershipTypeDN = this.ldapAttrMapping.membershipTypeNameAttr + "=" + mt.getName() + "," + this.ldapAttrMapping.membershipTypeURL;
        LdapContext ctx = this.ldapService.getLdapContext();
        try {
            int err = 0;
            while (true) {
                block9: {
                    try {
                        Attributes attrs = ctx.getAttributes(membershipTypeDN);
                        if (attrs.size() != 0) break block9;
                        MembershipType membershipType = mt;
                        return membershipType;
                    }
                    catch (NamingException e) {
                        if (!MembershipTypeDAOImpl.isConnectionError(e) || err >= MembershipTypeDAOImpl.getMaxConnectionError()) {
                            throw e;
                        }
                        ctx = this.ldapService.getLdapContext(true);
                        ++err;
                        continue;
                    }
                }
                ModificationItem[] mods = new ModificationItem[1];
                String desc = mt.getDescription();
                mods[0] = desc != null && desc.length() > 0 ? new ModificationItem(2, new BasicAttribute(this.ldapAttrMapping.ldapDescriptionAttr, mt.getDescription())) : new ModificationItem(3, new BasicAttribute(this.ldapAttrMapping.ldapDescriptionAttr, mt.getDescription()));
                ctx.modifyAttributes(membershipTypeDN, mods);
                MembershipType membershipType = mt;
                return membershipType;
            }
        }
        finally {
            this.ldapService.release(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MembershipType removeMembershipType(String name, boolean broadcast) throws Exception {
        String membershipTypeDN = this.ldapAttrMapping.membershipTypeNameAttr + "=" + name + "," + this.ldapAttrMapping.membershipTypeURL;
        LdapContext ctx = this.ldapService.getLdapContext();
        try {
            int err = 0;
            while (true) {
                try {
                    Attributes attrs = ctx.getAttributes(membershipTypeDN);
                    MembershipType m = this.ldapAttrMapping.attributesToMembershipType(attrs);
                    this.removeMembership(ctx, name);
                    ctx.destroySubcontext(membershipTypeDN);
                    MembershipType membershipType = m;
                    return membershipType;
                }
                catch (NamingException e) {
                    try {
                        if (!MembershipTypeDAOImpl.isConnectionError(e) || err >= MembershipTypeDAOImpl.getMaxConnectionError()) {
                            throw e;
                        }
                        ctx = this.ldapService.getLdapContext(true);
                        ++err;
                        continue;
                    }
                    catch (NameNotFoundException e2) {
                        if (LOG.isDebugEnabled()) {
                            e2.printStackTrace();
                        }
                        MembershipType membershipType = null;
                        return membershipType;
                    }
                }
                break;
            }
        }
        finally {
            this.ldapService.release(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MembershipType findMembershipType(String name) throws Exception {
        String membershipTypeDN = this.ldapAttrMapping.membershipTypeNameAttr + "=" + name + "," + this.ldapAttrMapping.membershipTypeURL;
        LdapContext ctx = this.ldapService.getLdapContext();
        try {
            int err = 0;
            while (true) {
                try {
                    Attributes attrs = ctx.getAttributes(membershipTypeDN);
                    MembershipType membershipType = this.ldapAttrMapping.attributesToMembershipType(attrs);
                    return membershipType;
                }
                catch (NamingException e) {
                    try {
                        if (!MembershipTypeDAOImpl.isConnectionError(e) || err >= MembershipTypeDAOImpl.getMaxConnectionError()) {
                            throw e;
                        }
                        ctx = this.ldapService.getLdapContext(true);
                        ++err;
                        continue;
                    }
                    catch (NameNotFoundException e2) {
                        if (LOG.isDebugEnabled()) {
                            e2.printStackTrace();
                        }
                        MembershipType membershipType = null;
                        return membershipType;
                    }
                }
                break;
            }
        }
        finally {
            this.ldapService.release(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection findMembershipTypes() throws Exception {
        ArrayList<MembershipType> memberships = new ArrayList<MembershipType>();
        String filter = this.ldapAttrMapping.membershipTypeNameAttr + "=*";
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        LdapContext ctx = this.ldapService.getLdapContext();
        try {
            NamingEnumeration<SearchResult> results = null;
            int err = 0;
            while (true) {
                Serializable sr;
                block13: {
                    memberships.clear();
                    try {
                        results = ctx.search(this.ldapAttrMapping.membershipTypeURL, filter, constraints);
                        while (results.hasMore()) {
                            sr = results.next();
                            Attributes attrs = ((SearchResult)sr).getAttributes();
                            memberships.add(this.ldapAttrMapping.attributesToMembershipType(attrs));
                        }
                        sr = memberships;
                        if (results == null) break block13;
                    }
                    catch (NamingException e) {
                        block14: {
                            try {
                                if (MembershipTypeDAOImpl.isConnectionError(e) && err < MembershipTypeDAOImpl.getMaxConnectionError()) {
                                    ctx = this.ldapService.getLdapContext(true);
                                    break block14;
                                }
                                throw e;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                if (results != null) {
                                    results.close();
                                }
                            }
                        }
                        ++err;
                        continue;
                    }
                    results.close();
                }
                return sr;
                break;
            }
        }
        finally {
            this.ldapService.release(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeMembership(LdapContext ctx, String name) throws NamingException {
        NamingEnumeration<SearchResult> results = null;
        try {
            SearchControls constraints = new SearchControls();
            constraints.setSearchScope(2);
            String filter = this.ldapAttrMapping.membershipTypeNameAttr + "=" + name;
            results = ctx.search(this.ldapAttrMapping.groupsURL, filter, constraints);
            while (results.hasMore()) {
                SearchResult sr = results.next();
                ctx.destroySubcontext(sr.getNameInNamespace());
            }
        }
        finally {
            if (results != null) {
                results.close();
            }
        }
    }
}

