/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.common.collect.Lists;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import java.util.List;
import org.apache.shindig.gadgets.render.RenderingGadgetRewriter;
import org.apache.shindig.gadgets.render.SanitizingGadgetRewriter;
import org.apache.shindig.gadgets.render.SanitizingRequestRewriter;
import org.apache.shindig.gadgets.rewrite.CssRequestRewriter;
import org.apache.shindig.gadgets.rewrite.GadgetRewriter;
import org.apache.shindig.gadgets.rewrite.HTMLContentRewriter;
import org.apache.shindig.gadgets.rewrite.PipelineDataGadgetRewriter;
import org.apache.shindig.gadgets.rewrite.RequestRewriter;
import org.apache.shindig.gadgets.rewrite.TemplateRewriter;
import org.apache.shindig.gadgets.servlet.CajaContentRewriter;

public class RewriteModule
extends AbstractModule {
    protected void configure() {
        this.bind((TypeLiteral)new TypeLiteral<List<GadgetRewriter>>(){}).toProvider(GadgetRewritersProvider.class);
        this.bind((TypeLiteral)new TypeLiteral<List<RequestRewriter>>(){}).toProvider(RequestRewritersProvider.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RequestRewritersProvider
    implements Provider<List<RequestRewriter>> {
        private final List<RequestRewriter> rewriters = Lists.newArrayList();

        @Inject
        public RequestRewritersProvider(HTMLContentRewriter optimizingRewriter, CssRequestRewriter cssRewriter, SanitizingRequestRewriter sanitizedRewriter) {
            this.rewriters.add(optimizingRewriter);
            this.rewriters.add(cssRewriter);
            this.rewriters.add(sanitizedRewriter);
        }

        public List<RequestRewriter> get() {
            return this.rewriters;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GadgetRewritersProvider
    implements Provider<List<GadgetRewriter>> {
        private final List<GadgetRewriter> rewriters = Lists.newArrayList();

        @Inject
        public GadgetRewritersProvider(PipelineDataGadgetRewriter pipelineRewriter, TemplateRewriter templateRewriter, HTMLContentRewriter optimizingRewriter, CssRequestRewriter cssRewriter, CajaContentRewriter cajaRewriter, SanitizingGadgetRewriter sanitizedRewriter, RenderingGadgetRewriter renderingRewriter) {
            this.rewriters.add(pipelineRewriter);
            this.rewriters.add(templateRewriter);
            this.rewriters.add(optimizingRewriter);
            this.rewriters.add(cajaRewriter);
            this.rewriters.add(sanitizedRewriter);
            this.rewriters.add(renderingRewriter);
        }

        public List<GadgetRewriter> get() {
            return this.rewriters;
        }
    }
}

