/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.context.exe.matcher;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.SessionFactory;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.type.LongType;
import org.jbpm.JbpmContext;
import org.jbpm.context.exe.JbpmTypeMatcher;

public class HibernateLongIdMatcher
implements JbpmTypeMatcher {
    private static final long serialVersionUID = 1L;
    private static Log log = LogFactory.getLog((Class)HibernateLongIdMatcher.class);

    public boolean matches(Object value) {
        boolean matches = false;
        JbpmContext jbpmContext = JbpmContext.getCurrentJbpmContext();
        if (jbpmContext != null) {
            SessionFactory sessionFactory;
            Class<?> valueClass = value.getClass();
            if (value instanceof HibernateProxy) {
                valueClass = valueClass.getSuperclass();
            }
            if ((sessionFactory = jbpmContext.getSessionFactory()) != null) {
                ClassMetadata classMetadata = sessionFactory.getClassMetadata(valueClass);
                matches = classMetadata != null && classMetadata.getIdentifierType().getClass() == LongType.class;
            }
        } else {
            log.debug((Object)"no current context so valueClass cannot be stored as a long-id-ref to a hibernate object");
            matches = false;
        }
        return matches;
    }
}

